/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.base;

import com.huawei.lego.core.base.framework.container.IDataSourceInitializer;
import com.huawei.lego.core.base.service.DefaultSystem;
import com.huawei.lego.core.sdk.base.IAppManager;
import com.huawei.lego.core.sdk.base.event.EventTrigger;
import com.huawei.lego.core.sdk.base.event.StatusChangedListener;
import com.huawei.lego.core.sdk.base.model.Status;
import com.huawei.lego.core.sdk.base.structure.IApplication;
import com.huawei.lego.core.sdk.base.structure.ICallback;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.PathUtil;
import java.util.ArrayList;
import java.util.List;

public final class LegoSystem
extends DefaultSystem {
    private static final Log LOGGER = LogFactory.getInstance(LegoSystem.class);
    private IDataSourceInitializer ormInitializer;

    public void setOrmInitializer(IDataSourceInitializer ormInitializer) {
        this.ormInitializer = ormInitializer;
    }

    public void setService(IAppManager service) {
    }

    public IApplication findApp(String appName) {
        IApplication result = null;
        List<IApplication> applications = this.getAppHolder().getHeldStructureEles();
        if (!applications.isEmpty()) {
            for (IApplication app : applications) {
                if (!app.getInfor().getAppName().equalsIgnoreCase(appName)) continue;
                result = app;
                break;
            }
        } else {
            LOGGER.warn((Object)(this.getClass().getSimpleName() + " does not have any appliations!"), 1L);
        }
        return result;
    }

    public List<IApplication> getAllApplications() {
        List<IApplication> applications = this.getAppHolder().getHeldStructureEles();
        if (!applications.isEmpty()) {
            return applications;
        }
        LOGGER.warn((Object)(this.getClass().getSimpleName() + " does not have any appliations!"), 1L);
        return null;
    }

    public void afterPropertiesSet() {
        this.initPath();
        if (this.ormInitializer.initialize()) {
            LOGGER.info((Object)"Database connection and session factory has been initialized successful!", 1L);
        } else {
            LOGGER.error((Object)"Failed to initialize Database connection and session factory!", 1L);
        }
        this.setListeners(new ArrayList<StatusChangedListener>());
    }

    private void initPath() {
        String basePath = System.getProperty("user.dir");
        PathUtil.setBasePath((String)basePath);
    }

    public void destroy() {
        this.ormInitializer.destroy();
        this.stop(new ArrayList<ICallback>());
        EventTrigger.fireEventListener((Object)this, this.getListeners(), (Status)Status.STATUS_DESTROYED);
        this.getListeners().clear();
    }
}

