/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.base.framework.container.support;

import com.huawei.lego.core.base.framework.container.Monitor;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BundleRefreshedMonitor
implements Monitor {
    private static final Log LOGGER = LogFactory.getInstance(BundleRefreshedMonitor.class);
    private int bundleFailedCount = 0;
    private Map<Long, Boolean> allBundles = new HashMap<Long, Boolean>();
    private Map<Long, String> bNames;
    private List<String> outOfRangBundles = new ArrayList<String>();

    public BundleRefreshedMonitor() {
        this.bNames = new HashMap<Long, String>();
    }

    @Override
    public boolean count(Object object) {
        return true;
    }

    @Override
    public int getCount() {
        StringBuffer msg = new StringBuffer();
        msg.append("Bundles :[");
        Set<Map.Entry<Long, Boolean>> entries = this.allBundles.entrySet();
        for (Map.Entry<Long, Boolean> entry : entries) {
            if (entry.getValue().booleanValue()) continue;
            String name = this.bNames.get(entry.getKey());
            msg.append(name).append(',');
            ++this.bundleFailedCount;
        }
        msg.append("] total:" + this.bundleFailedCount + " may be refreshed right now or not recognised! ");
        if (this.outOfRangBundles.size() > 0) {
            msg.append(System.lineSeparator());
            msg.append("missing Spring-Context identifier bundles:[");
            for (String name : this.outOfRangBundles) {
                msg.append(name + ",");
            }
            msg.append(']');
        }
        LOGGER.warn((Object)msg.toString(), 1L);
        return this.bundleFailedCount;
    }

    @Override
    public void monitor(Object object) {
    }

    @Override
    public void reset() {
        this.bundleFailedCount = 0;
    }
}

