/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.base.persistance.service;

import com.huawei.lego.core.base.persistance.HibernateUtil;
import com.huawei.lego.core.base.persistance.initializer.SessionEndListener;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionEventListener;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.engine.spi.SessionImplementor;
import org.springframework.orm.hibernate5.SessionHolder;
import org.springframework.orm.hibernate5.SpringSessionSynchronization;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.w3c.dom.Document;

public class DynamicConfiguration {
    private static final Set<Method> NEED_MODIFY_JPA_STYLE_METHOD = new HashSet<Method>();
    private static final Log LOGGER = LogFactory.getInstance(DynamicConfiguration.class);
    private Configuration cfg = new Configuration();
    private Properties hibernateProperties = new Properties();
    private List<Class> annotatedClasses = new ArrayList<Class>();
    private List<URL> hbms = new ArrayList<URL>();
    private List<URL> cfgs = new ArrayList<URL>();
    private SessionFactory proxiedSessionFactory;
    private SessionFactory sessionFactory;
    private boolean isTracked = false;

    public DynamicConfiguration(boolean isTracked) {
        this.isTracked = isTracked;
    }

    public void addProperties(Properties properties) {
        this.hibernateProperties.putAll((Map<?, ?>)properties);
    }

    public void addDocument(Document document) {
        this.cfg.configure(document);
    }

    public void addHbm(URL url) {
        this.hbms.add(url);
    }

    public void addConfig(URL url) {
        this.cfgs.add(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStream(InputStream is) {
        Properties props = new Properties();
        try {
            props.load(is);
        }
        catch (IOException e) {
            LOGGER.error((Object)"ORM read properties error!", (Throwable)e, 1L);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                LOGGER.error((Object)"ORM read properties error!", (Throwable)e, 1L);
            }
        }
        this.addProperties(props);
    }

    public void addClass(Class anotadedClass) {
        this.annotatedClasses.add(anotadedClass);
    }

    public SessionFactory getSessionFactory() {
        return this.proxiedSessionFactory;
    }

    public Configuration getConfiguration() {
        return this.cfg;
    }

    public void createNewSessionFactory() {
        this.initConfiguration();
        try {
            this.sessionFactory = this.cfg.buildSessionFactory();
            this.sessionFactory.getStatistics().setStatisticsEnabled(this.isTracked);
            this.proxiedSessionFactory = (SessionFactory)Proxy.newProxyInstance(SessionFactory.class.getClassLoader(), new Class[]{SessionFactory.class}, (proxy, method, args) -> {
                if (method.getName().equals("getCurrentSession")) {
                    Session session = this.currentSession();
                    HibernateUtil.setCurrentSessionFlag(session, "currentType");
                    session.addEventListeners(new SessionEventListener[]{new SessionEndListener(session)});
                    return this.proxySession(session);
                }
                if (method.getName().equals("openSession")) {
                    Session session = (Session)method.invoke((Object)this.sessionFactory, args);
                    HibernateUtil.setCurrentSessionFlag(session, "openType");
                    session.addEventListeners(new SessionEventListener[]{new SessionEndListener(session)});
                    return this.proxySession(session);
                }
                return method.invoke((Object)this.sessionFactory, args);
            });
        }
        catch (Exception e) {
            LOGGER.error((Object)"build session factory error,error is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        }
        LOGGER.info((Object)"Created new session factory: ", 1L);
    }

    private Session proxySession(Session session) {
        return (Session)Proxy.newProxyInstance(SessionImplementor.class.getClassLoader(), new Class[]{SessionImplementor.class}, (proxy, method, args) -> {
            if (NEED_MODIFY_JPA_STYLE_METHOD.contains(method)) {
                String queryString = (String)args[0];
                String jpaStyle = HibernateUtil.convertToJpaStyle(queryString);
                args[0] = jpaStyle;
            }
            return method.invoke((Object)session, args);
        });
    }

    private void initConfiguration() {
        if (this.hibernateProperties.isEmpty()) {
            return;
        }
        for (Class clazz : this.annotatedClasses) {
            this.cfg.addClass(clazz);
        }
        LOGGER.info((Object)String.format(Locale.ENGLISH, "Hbms is : %s.", this.hbms), 1L);
        for (URL uRL : this.hbms) {
            this.cfg.addURL(uRL);
        }
        LOGGER.info((Object)String.format(Locale.ENGLISH, "Cfgs is :%s.", this.cfgs), 1L);
        for (URL uRL : this.cfgs) {
            this.cfg.configure(uRL);
        }
        for (Map.Entry entry : this.hibernateProperties.entrySet()) {
            this.cfg.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
    }

    private Session currentSession() throws HibernateException {
        Object value = TransactionSynchronizationManager.getResource((Object)this.proxiedSessionFactory);
        if (!TransactionSynchronizationManager.isSynchronizationActive()) {
            TransactionSynchronizationManager.initSynchronization();
        }
        if (value instanceof Session) {
            return (Session)value;
        }
        if (value instanceof SessionHolder) {
            SessionHolder sessionHolder = (SessionHolder)value;
            Session session = sessionHolder.getSession();
            if (!sessionHolder.isSynchronizedWithTransaction() && TransactionSynchronizationManager.isSynchronizationActive()) {
                TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new SpringSessionSynchronization(sessionHolder, this.proxiedSessionFactory, false));
                sessionHolder.setSynchronizedWithTransaction(true);
                FlushMode flushMode = session.getHibernateFlushMode();
                if (flushMode.equals((Object)FlushMode.MANUAL) && !TransactionSynchronizationManager.isCurrentTransactionReadOnly()) {
                    session.setFlushMode(FlushMode.AUTO);
                    sessionHolder.setPreviousFlushMode(flushMode);
                }
            }
            return session;
        }
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            Session session = this.sessionFactory.openSession();
            if (TransactionSynchronizationManager.isCurrentTransactionReadOnly()) {
                session.setFlushMode(FlushMode.MANUAL);
            }
            SessionHolder sessionHolder = new SessionHolder(session);
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new SpringSessionSynchronization(sessionHolder, this.proxiedSessionFactory, true));
            TransactionSynchronizationManager.bindResource((Object)this.proxiedSessionFactory, (Object)sessionHolder);
            sessionHolder.setSynchronizedWithTransaction(true);
            return session;
        }
        throw new HibernateException("Could not obtain transaction-synchronized Session for current thread");
    }

    static {
        try {
            NEED_MODIFY_JPA_STYLE_METHOD.add(SessionImplementor.class.getMethod("createQuery", String.class));
            NEED_MODIFY_JPA_STYLE_METHOD.add(SessionImplementor.class.getMethod("createQuery", String.class, Class.class));
            NEED_MODIFY_JPA_STYLE_METHOD.add(SessionImplementor.class.getMethod("createSQLQuery", String.class));
            String methodName = "createNativeQuery";
            NEED_MODIFY_JPA_STYLE_METHOD.add(SessionImplementor.class.getMethod(methodName, String.class));
            NEED_MODIFY_JPA_STYLE_METHOD.add(SessionImplementor.class.getMethod(methodName, String.class, Class.class));
            NEED_MODIFY_JPA_STYLE_METHOD.add(SessionImplementor.class.getMethod(methodName, String.class, String.class));
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalStateException("Incompatible Hibernate Session API", ex);
        }
    }
}

