/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.base.registry;

import com.huawei.lego.core.sdk.base.IAppManager;
import com.huawei.lego.core.sdk.base.StaticRmiServerSocketFactory;
import com.huawei.lego.core.sdk.base.StaticRmiSocketFactory;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.LegoProperties;
import com.huawei.lego.core.sdk.util.NumberUtil;
import java.rmi.registry.Registry;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.remoting.rmi.RmiServiceExporter;

public class AppManagerExporter
implements InitializingBean {
    private static final String KEY_SPRING_EXP_RMI2 = "spring.expRmi2";
    private static final String DEFAULT_RMI_SERVICE_PORT_10093 = "10093";
    private static final String LOCAL_HOST_IP = "127.0.0.1";
    private static final int VALUE_5 = 5;
    private static StaticRmiServerSocketFactory srsf = new StaticRmiServerSocketFactory();
    private static Map<String, RmiServiceExporter> rmiExperHandlerMap = new ConcurrentHashMap<String, RmiServiceExporter>(5);
    private static final Log LOGGER = LogFactory.getInstance(AppManagerExporter.class);
    private Registry registry;
    private IAppManager service;

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    public void setService(IAppManager service) {
        this.service = service;
    }

    public void afterPropertiesSet() {
        RmiServiceExporter exporter = new RmiServiceExporter();
        try {
            exporter.setServiceInterface(IAppManager.class);
            exporter.setServiceName("appManager/appManager");
            exporter.setService((Object)this.service);
            exporter.setRegistry(this.registry);
            exporter.setServicePort(NumberUtil.convertToInteger((Object)LegoProperties.getProperty((String)KEY_SPRING_EXP_RMI2, (String)DEFAULT_RMI_SERVICE_PORT_10093)).intValue());
            StaticRmiSocketFactory cfy = new StaticRmiSocketFactory(LOCAL_HOST_IP, 0);
            exporter.setClientSocketFactory((RMIClientSocketFactory)cfy);
            exporter.setServerSocketFactory((RMIServerSocketFactory)srsf);
            exporter.afterPropertiesSet();
            rmiExperHandlerMap.put("appManager/appManager", exporter);
            LOGGER.info((Object)"AppManager Service Export as A RMI Service OK!");
        }
        catch (Exception e) {
            LOGGER.error((Object)ExceptionUtil.getErrorMessage((Throwable)e), 1L);
        }
    }
}

