/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.base.util;

import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.time.Duration;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public class KeyLocker {
    private static final Log LOGGER = LogFactory.getInstance(KeyLocker.class);
    private static final ConcurrentMap<String, ReentrantLock> lockMap = new ConcurrentHashMap<String, ReentrantLock>();
    private final String keyPrefix;

    public KeyLocker(Class<?> clazz, String lockName) {
        if (VerifyUtil.isEmpty(clazz) || VerifyUtil.isEmpty((String)lockName)) {
            throw new LegoCheckedException(1073947393L, "The Clazz or lockName is empty.");
        }
        this.keyPrefix = String.format(Locale.ROOT, "%s#%s:", clazz.getName(), lockName);
    }

    public boolean tryLock(String key) {
        return this.getOrCreateLock(key).tryLock();
    }

    public boolean tryLock(String key, Duration timeout) {
        return this.tryLock(key, timeout.toNanos(), TimeUnit.NANOSECONDS);
    }

    public boolean tryLock(String key, long timeout) {
        return this.tryLock(key, timeout, TimeUnit.MILLISECONDS);
    }

    public boolean tryLock(String key, long timeout, TimeUnit unit) {
        try {
            return this.getOrCreateLock(key).tryLock(timeout, unit);
        }
        catch (InterruptedException e) {
            LOGGER.warn((Object)"Try to lock was interrupted. key: %s", new Object[]{key});
            return false;
        }
    }

    public void unlock(String key) {
        ReentrantLock lock = this.getLock(key);
        if (lock == null || !lock.isHeldByCurrentThread()) {
            LOGGER.warn((Object)"Attempt to release an unheld lock. key: %s", new Object[]{key});
            return;
        }
        try {
            if (lock.getHoldCount() == 1) {
                lockMap.remove(key, lock);
                LOGGER.debug((Object)"Remove lock object. key: %s", new Object[]{key});
            }
        }
        finally {
            lock.unlock();
        }
    }

    public boolean isHeldByCurrentThread(String key) {
        ReentrantLock lock = this.getLock(key);
        return lock != null && lock.isHeldByCurrentThread();
    }

    public boolean isLocked(String key) {
        ReentrantLock lock = this.getLock(key);
        return lock != null && lock.isLocked();
    }

    private ReentrantLock getLock(String key) {
        return (ReentrantLock)lockMap.get(this.buildKey(key));
    }

    private ReentrantLock getOrCreateLock(String key) {
        return lockMap.computeIfAbsent(this.buildKey(key), s -> new ReentrantLock());
    }

    private String buildKey(String key) {
        if (VerifyUtil.isEmpty((String)key)) {
            throw new LegoCheckedException(1073947393L, "The key is empty.");
        }
        return this.keyPrefix + key;
    }
}

