/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.base.util;

import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Watcher {
    private static final Log logger = LogFactory.getInstance(Watcher.class);
    private static final Map<WatchEvent.Kind, Kind> EVENT_KIND_MAP = Watcher.getEventKindMap();
    private static final long DEFAULT_DELAY_TIME = 1000L;
    private Queue<Consumer<Event>> handlers = new ConcurrentLinkedQueue<Consumer<Event>>();
    private AtomicLong delay = new AtomicLong(1000L);
    private AtomicBoolean running = new AtomicBoolean();
    private AtomicBoolean waiting = new AtomicBoolean();
    private BlockingQueue<Event> queue = new LinkedBlockingQueue<Event>();
    private Map<WatchKey, Target> watchKeyTargetMap = new ConcurrentHashMap<WatchKey, Target>();
    private ConcurrentLinkedQueue<Target> targets = new ConcurrentLinkedQueue();
    private AtomicReference<WatchService> serviceReference = new AtomicReference();
    private Thread shutdownHook;
    private final Object lock = new Object();
    private Boolean runningTest = null;

    public Watcher() {
    }

    public Watcher(String path, Kind ... kinds) {
        this(Paths.get(path, new String[0]), kinds);
    }

    public Watcher(Path file, Kind ... kinds) {
        this(Watcher.getBasePath(file), Watcher.getFileName(file), kinds);
    }

    public Watcher(Path path, String glob, Kind ... kinds) {
        this(false, path, glob, kinds);
    }

    public Watcher(boolean recursive, Path path, String glob, Kind ... kinds) {
        this.watch(recursive, path, glob, kinds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isRunningTest() {
        Object object = this.lock;
        synchronized (object) {
            if (this.runningTest == null) {
                try {
                    Class.forName("org.junit.Test");
                    this.runningTest = true;
                }
                catch (ClassNotFoundException ignore) {
                    this.runningTest = false;
                }
            }
        }
        return this.runningTest;
    }

    private static Path getBasePath(Path file) {
        return Optional.ofNullable(file).map(Path::getParent).orElse(null);
    }

    private static String getFileName(Path file) {
        return Optional.ofNullable(file).map(Path::getFileName).map(Path::toString).orElse(null);
    }

    public Watcher delay(long delayTime) {
        this.delay.set(Math.max(delayTime, 1000L));
        return this;
    }

    private WatchService getWatchService() {
        return this.serviceReference.get();
    }

    public Watcher handle(Consumer<Event> handler) {
        if (handler != null) {
            this.handlers.add(handler);
            if (this.running.get() && this.waiting.get()) {
                logger.info((Object)"Auto start watcher.");
                this.launch();
            }
        }
        return this;
    }

    private void handle(Event event) {
        for (Consumer consumer : this.handlers) {
            try {
                consumer.accept(event);
            }
            catch (Throwable e) {
                logger.error((Object)"handler runtime error, cause: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            }
        }
    }

    public boolean running() {
        return this.running.get();
    }

    public Watcher start() {
        if (this.running.compareAndSet(false, true)) {
            if (!this.handlers.isEmpty()) {
                this.launch();
            } else {
                this.waiting.set(true);
                logger.info((Object)"Watcher handler list of getWatchedPaths empty, watcher will start after a handler added.");
            }
        }
        return this;
    }

    private List<Path> getWatchedPaths() {
        return Stream.of(this.watchKeyTargetMap.values(), this.targets).flatMap(Collection::stream).filter(target -> !((Target)target).temporary).map(target -> ((Target)target).path).collect(Collectors.toList());
    }

    private void launch() {
        logger.info((Object)"Watcher is starting");
        this.waiting.set(false);
        this.walk();
        new Thread(this::watch, "FileSystemEventWatch").start();
        new Thread(this::dispatch, "FileSystemEventDispatch").start();
        this.shutdownHook = new Thread(this::onShutdown);
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
    }

    private boolean offer(Event event) {
        logger.debug((Object)event);
        return this.queue.offer(event);
    }

    private void walk() {
        for (Target target : this.targets) {
            target.walk();
        }
    }

    private void dispatch() {
        while (this.running.get()) {
            try {
                long delayTime;
                Event event = this.queue.take();
                if (event.getPath() == null) {
                    return;
                }
                Date now = new Date();
                long diff = now.getTime() - event.getTimestamp().getTime();
                if (diff < (delayTime = this.delay.get())) {
                    CommonUtil.sleep((long)(delayTime - diff));
                }
                if (this.combine(event)) continue;
                this.handle(event);
            }
            catch (InterruptedException e) {
                logger.error((Object)"take event from queue failed, cause: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            }
        }
    }

    private boolean combine(Event event) {
        for (Event item : this.queue) {
            if (!item.getPath().equals(event.getPath())) continue;
            logger.info((Object)"combine %s to %s", new Object[]{event, item});
            item.getKinds().addAll(event.getKinds());
            return true;
        }
        return false;
    }

    private void onShutdown() {
        logger.info((Object)"Close watcher before system shutdown");
        this.stop(false);
    }

    public Watcher stop() {
        this.stop(true);
        return this;
    }

    private void stop(boolean manual) {
        if (this.running.compareAndSet(true, false)) {
            logger.info((Object)"Watcher will be stop.");
            if (this.waiting.get()) {
                return;
            }
            WatchService service = this.getWatchService();
            if (service != null) {
                try {
                    service.close();
                    logger.info((Object)"Close watch service success.");
                }
                catch (IOException e) {
                    logger.error((Object)"Close watch service failed, cause: %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
                }
            }
            if (!this.offer(new Event(null, Collections.emptyList()))) {
                logger.error((Object)"fail to add end event to queue");
            }
            if (manual) {
                this.removeShutdownHook();
            }
        }
    }

    private void removeShutdownHook() {
        if (this.shutdownHook == null) {
            return;
        }
        try {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
        }
        catch (IllegalStateException e) {
            logger.error((Object)"remove shutdown hook failed", (Throwable)e);
        }
    }

    public void watch(boolean recursive, String path, String glob, Kind ... kinds) {
        this.watch(recursive, Paths.get(path, new String[0]), glob, kinds);
    }

    public void watch(boolean recursive, Path path, String glob, Kind ... kinds) {
        Set<Kind> kindSet = Optional.ofNullable(kinds).map(Arrays::asList).orElse(Collections.emptyList()).stream().filter(Objects::nonNull).collect(Collectors.toSet());
        this.watch(recursive, false, path, glob, kindSet);
    }

    private void watch(boolean recursive, boolean temporary, Path path, String glob, Set<Kind> kinds) {
        if (path == null || kinds.isEmpty()) {
            return;
        }
        Target target = new Target(recursive, path, glob, kinds);
        target.temporary = temporary;
        WatchService service = this.getWatchService();
        if (service == null) {
            this.targets.add(target);
        } else {
            this.register(service, target, false);
        }
    }

    private void watch() {
        logger.info((Object)"Watcher is started.");
        if (!this.initWatchService()) {
            return;
        }
        WatchService service = this.serviceReference.get();
        while (this.running.get()) {
            WatchKey wk;
            try {
                wk = service.take();
                logger.debug((Object)"take a watch key");
            }
            catch (InterruptedException | ClosedWatchServiceException e) {
                logger.error((Object)"get watch key failed", (Throwable)e);
                this.stop();
                return;
            }
            Target target = this.watchKeyTargetMap.get(wk);
            Iterator<WatchEvent<?>> iterator = wk.pollEvents().iterator();
            while (iterator.hasNext()) {
                Path item;
                WatchEvent<Path> event;
                WatchEvent<Path> watchEvent = event = iterator.next();
                this.revise(target, watchEvent);
                if (!target.kinds.contains((Object)EVENT_KIND_MAP.get(watchEvent.kind())) || !target.matches(item = watchEvent.context())) continue;
                String kind = watchEvent.kind().name().replaceFirst("^[^_]*_", "").toLowerCase(Locale.ENGLISH);
                if (this.offer(new Event(target.path.resolve(item), kind))) continue;
                logger.error((Object)"fail to add %s event to queue", new Object[]{kind});
            }
            if (wk.reset()) continue;
            logger.error((Object)"reset watch key failed after event processed");
            this.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void register(WatchService service, Target target, boolean exitOnFail) {
        WatchKey watchKey;
        try {
            watchKey = target.path.register(service, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
        }
        catch (IOException e) {
            logger.error((Object)"fail to register watch service for %s.", new Object[]{target});
            if (exitOnFail && !this.isRunningTest()) {
                logger.error((Object)"exit on fail to register watch service for %s.", new Object[]{target});
                System.exit(1);
            }
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
        Target origin = this.watchKeyTargetMap.putIfAbsent(watchKey, target);
        if (origin != null) {
            Target target2 = origin;
            synchronized (target2) {
                Target parent = origin;
                while (parent.isotope != null) {
                    parent = parent.isotope;
                }
                parent.isotope = target;
            }
        }
    }

    private void revise(Target target, WatchEvent<Path> watchEvent) {
        if (!target.recursive) {
            return;
        }
        Target resolved = target.resolve(watchEvent.context(), Kind.CREATE);
        if (!resolved.path.toFile().isDirectory()) {
            return;
        }
        WatchEvent.Kind<Path> kind = watchEvent.kind();
        if (kind == StandardWatchEventKinds.ENTRY_CREATE) {
            resolved.walk();
        } else if (kind == StandardWatchEventKinds.ENTRY_DELETE) {
            this.deleteWatchRegistration(resolved.path);
        }
    }

    private void deleteWatchRegistration(Path path) {
        Iterator<Map.Entry<WatchKey, Target>> it = this.watchKeyTargetMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<WatchKey, Target> entry = it.next();
            Target target = entry.getValue();
            if (!path.equals(target.path)) continue;
            entry.getKey().cancel();
            it.remove();
            logger.debug((Object)"TargetPath is deleted, it will not be watched. temporary: %s.", new Object[]{target.temporary});
            break;
        }
    }

    private boolean initWatchService() {
        WatchService service;
        try {
            service = FileSystems.getDefault().newWatchService();
            this.serviceReference.set(service);
        }
        catch (IOException | ClosedWatchServiceException e) {
            logger.error((Object)"start watcher failed, cause: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            this.stop();
            return false;
        }
        Iterator<Target> it = this.targets.iterator();
        while (it.hasNext()) {
            Target target = it.next();
            this.register(service, target, true);
            it.remove();
        }
        return true;
    }

    private static Map<WatchEvent.Kind, Kind> getEventKindMap() {
        HashMap<WatchEvent.Kind<Path>, Kind> map = new HashMap<WatchEvent.Kind<Path>, Kind>();
        map.put(StandardWatchEventKinds.ENTRY_CREATE, Kind.CREATE);
        map.put(StandardWatchEventKinds.ENTRY_MODIFY, Kind.MODIFY);
        map.put(StandardWatchEventKinds.ENTRY_DELETE, Kind.DELETE);
        return Collections.unmodifiableMap(map);
    }

    public static class Event {
        private Path path;
        private List<Kind> kinds;
        private Date timestamp;

        public Event(Path path, String kind) {
            this(path, Collections.singletonList(kind.toUpperCase(Locale.getDefault())));
        }

        public Event(Path path, List<String> kinds) {
            this.path = path;
            this.kinds = kinds.stream().map(Kind::get).collect(Collectors.toList());
            this.timestamp = new Date();
        }

        public List<Kind> getKinds() {
            return this.kinds;
        }

        public Path getPath() {
            return this.path;
        }

        public Date getTimestamp() {
            return this.timestamp;
        }

        public LinkedList<Kind> getStableKinds() {
            return Event.getStableKinds(this.kinds);
        }

        public static LinkedList<Kind> getStableKinds(List<Kind> kinds) {
            int count = 0;
            LinkedList<Kind> result = new LinkedList<Kind>(kinds);
            ListIterator it = result.listIterator();
            while (it.hasNext()) {
                Kind kind = (Kind)((Object)it.next());
                if (count == 0) {
                    if (kind != Kind.CREATE) continue;
                    ++count;
                    continue;
                }
                ++count;
                if (kind != Kind.DELETE) continue;
                for (int i = 0; i < count; ++i) {
                    it.remove();
                    it.previous();
                }
                count = 0;
            }
            return result;
        }

        public boolean isDeletedAtLast() {
            return Event.isDeletedAtLast(this.kinds);
        }

        public static boolean isDeletedAtLast(List<Kind> kinds) {
            LinkedList<Kind> list = Event.getStableKinds(kinds);
            return !list.isEmpty() && list.getLast() == Kind.DELETE;
        }

        public String toString() {
            return "Event{path=" + this.path + ", kinds=" + this.kinds + ", timestamp=" + this.timestamp + '}';
        }
    }

    public static enum Kind {
        INIT,
        CREATE,
        MODIFY,
        DELETE;


        static Kind get(String name) {
            return Kind.valueOf(name.toUpperCase(Locale.getDefault()));
        }
    }

    private class Target
    implements FileVisitor<Path> {
        private boolean recursive;
        private Path path;
        private String glob;
        private Set<Kind> kinds;
        private PathMatcher matcher;
        private Kind walkEventKind = Kind.INIT;
        private boolean temporary = false;
        private Target isotope;

        public Target(boolean recursive, Path path, String glob, Set<Kind> kinds) {
            kinds.forEach(Objects::requireNonNull);
            this.recursive = recursive;
            this.path = path;
            this.glob = glob;
            this.kinds = kinds;
            this.matcher = FileSystems.getDefault().getPathMatcher("glob:" + Optional.ofNullable(glob).orElse("**"));
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            if (this.path.equals(dir)) {
                return FileVisitResult.CONTINUE;
            }
            this.init(dir);
            if (!this.recursive) {
                return FileVisitResult.SKIP_SUBTREE;
            }
            Watcher.this.watch(true, true, dir, this.glob, this.kinds);
            logger.debug((Object)"Add child directory to watcher service.");
            return FileVisitResult.CONTINUE;
        }

        public void init(Path item) {
            if (!this.kinds.contains((Object)this.walkEventKind)) {
                return;
            }
            Path relative = this.path.relativize(item);
            if (this.matcher.matches(relative) && !Watcher.this.offer(new Event(item, this.walkEventKind.name()))) {
                logger.error((Object)"fail to add init event for %s to queue", new Object[]{item});
            }
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            this.init(file);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        public Target walk() {
            if (this.kinds.contains((Object)this.walkEventKind) || this.recursive) {
                try {
                    Files.walkFileTree(this.path, this);
                }
                catch (IOException e) {
                    logger.error((Throwable)e, (Object)"Fail to walk for matched files.", new Object[0]);
                }
            }
            if (this.isotope != null) {
                this.isotope.walk();
            }
            return this;
        }

        public Target resolve(Path other, Kind kind) {
            Target target = new Target(this.recursive, this.path.resolve(other), this.glob, this.kinds);
            target.temporary = true;
            target.walkEventKind = kind;
            return target;
        }

        public String toString() {
            return "Target{path=" + this.path + ", glob='" + this.glob + '\'' + ", kinds=" + this.kinds + '}';
        }

        public boolean matches(Path item) {
            if (this.matcher == null || this.matcher.matches(item)) {
                return true;
            }
            return this.isotope != null && this.isotope.matches(item);
        }
    }
}

