/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.domain.service;

import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.cbb.resource.sdk.service.IResourceService;
import com.huawei.lego.core.domain.context.ModelServiceMapping;
import com.huawei.lego.core.domain.context.ProductContext;
import com.huawei.lego.core.domain.context.ServiceContext;
import com.huawei.lego.core.domain.service.IDaoService;
import com.huawei.lego.core.sdk.base.structure.IService;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbsDaoService
implements IDaoService {
    private static final Log LOGGER = LogFactory.getInstance(AbsDaoService.class);
    private IService service;
    private ProductContext context;

    @Override
    public void delete(long moId) {
    }

    @Override
    public void delete(ManagedObject mo) {
    }

    @Override
    public void deleteAll(int moType) {
    }

    @Override
    public List<ManagedObject> get(int moType) {
        return null;
    }

    @Override
    public ManagedObject get(long moId) {
        IResourceService resSrv = (IResourceService)com.huawei.lego.core.sdk.base.ServiceContext.getInstance().lookup("resource/".concat(IResourceService.class.getName()));
        return resSrv.getDeviceDetailInfo(Long.valueOf(moId));
    }

    @Override
    public void save(ManagedObject mo) {
        IResourceService resSrv = (IResourceService)com.huawei.lego.core.sdk.base.ServiceContext.getInstance().lookup("resource/".concat(IResourceService.class.getName()));
        resSrv.addMo(mo);
        Map<String, ModelServiceMapping> mapping = this.context.getpModelMappings();
        Set children = mo.getChildMos();
        try {
            this.invokeEverySave(mapping, children);
        }
        catch (InstantiationException e1) {
            LOGGER.error((Object)e1, 1L);
        }
        catch (IllegalAccessException e1) {
            LOGGER.error((Object)e1, 1L);
        }
    }

    private void invokeEverySave(Map<String, ModelServiceMapping> mapping, Set<ManagedObject> children) throws InstantiationException, IllegalAccessException {
        for (ManagedObject child : children) {
            ServiceContext[] srvs;
            for (ServiceContext serviceContext : srvs = mapping.get(child.getType()).getServiceCtxs()) {
                if (serviceContext.getServiceType() != 0) continue;
                IDaoService daoSrv = (IDaoService)serviceContext.getServiceClass().newInstance();
                daoSrv.setProductContext(this.context);
                daoSrv.save(child);
            }
        }
    }

    @Override
    public boolean update(ManagedObject mo) {
        IResourceService resSrv = (IResourceService)com.huawei.lego.core.sdk.base.ServiceContext.getInstance().lookup("resource/".concat(IResourceService.class.getName()));
        resSrv.addMoAndSubMo(mo);
        Map<String, ModelServiceMapping> mapping = this.context.getpModelMappings();
        Set children = mo.getChildMos();
        try {
            this.invokeEveryUpdate(mapping, children);
        }
        catch (InstantiationException e1) {
            LOGGER.error((Object)e1, 1L);
        }
        catch (IllegalAccessException e1) {
            LOGGER.error((Object)e1, 1L);
        }
        return false;
    }

    private void invokeEveryUpdate(Map<String, ModelServiceMapping> mapping, Set<ManagedObject> children) throws InstantiationException, IllegalAccessException {
        for (ManagedObject child : children) {
            ServiceContext[] srvs;
            for (ServiceContext serviceContext : srvs = mapping.get(child.getType()).getServiceCtxs()) {
                if (serviceContext.getServiceType() != 0) continue;
                IDaoService daoSrv = (IDaoService)serviceContext.getServiceClass().newInstance();
                daoSrv.setProductContext(this.context);
                daoSrv.update(child);
            }
        }
    }

    public IService getService() {
        return this.service;
    }

    public void setService(IService service) {
        this.service = service;
    }

    public ProductContext getContext() {
        return this.context;
    }

    public void setContext(ProductContext context) {
        this.context = context;
    }
}

