/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.system.sysmonitor.service.hostserver;

import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.MathUtil;
import com.huawei.lego.core.sdk.util.NumberUtil;
import com.huawei.lego.core.sdk.util.PathUtil;
import com.huawei.lego.core.sdk.util.SafeBufferedReader;
import com.huawei.lego.core.system.sysmonitor.sdk.model.DiskResouceUse;
import com.huawei.lego.core.system.sysmonitor.service.hostserver.ISystemTool;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;

public class LinuxSystemTool
implements ISystemTool {
    private static final String MEM_INFO_PATH = "/proc/meminfo";
    private static final String CPU_INFO_PATH = "/proc/stat";
    private static final long MB2GB = 1000L;
    private static final int ONE_HUNDRED = 100;
    private static final int A_THOUSAND = 1000;
    private static final int LINE_KEY_NUM = 7;
    private static final int ZERO = 0;
    private static final int ONE = 1;
    private static final int LINE_TOTAL = 2;
    private static final int LINE_USED = 3;
    private static final int LINE_AVLID = 4;
    private static final int LINE_PERCENT = 5;
    private static final int LINE_NAME = 6;
    private static final int EIGHT = 8;
    private static final int THIRTEEN = 13;
    private static final int SIXTEEN = 16;
    private static final int SEVENTEEN = 17;
    private static final int TIME_OUT = 5000;
    private static final int SLEEP_TIME = 30000;
    private static final String ISO = "iso9660";
    private static final String UDF = "udf";
    private static final int VALUE_2 = 2;
    private static final Log LOGGER = LogFactory.getInstance(LinuxSystemTool.class);

    @Override
    public long getAvailMemInfo() {
        int[] result = this.getMemInfo();
        return result[1];
    }

    @Override
    public long getPercentMemInfo() {
        int[] result = this.getMemInfo();
        long total = result[0] + result[1];
        return total > 0L ? (long)result[0] * 100L / total : 100L;
    }

    @Override
    public long getTotalMemInfo() {
        long total = -1L;
        int[] result = this.getMemInfo();
        if (result.length >= 2) {
            total = result[0] + result[1];
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private int[] getMemInfo() {
        LOGGER.debug((Object)"start", 1L);
        int[] result = new int[3];
        Runtime rt = Runtime.getRuntime();
        BufferedReader bufRead = null;
        Process process = null;
        try {
            int tempChar;
            process = rt.exec("free");
            bufRead = new BufferedReader(new InputStreamReader(process.getInputStream(), "UTF-8"));
            StringBuffer strBuf = new StringBuffer();
            while ((tempChar = bufRead.read()) != -1) {
                strBuf.append((char)tempChar);
            }
            if (strBuf.toString().contains("-/+ buffers/cache:")) {
                StringTokenizer token = new StringTokenizer(strBuf.toString());
                this.setResultByToken(result, token);
            } else {
                Integer total = null;
                Integer available = null;
                StringTokenizer token = new StringTokenizer(strBuf.toString());
                int i = 1;
                while (token.hasMoreTokens()) {
                    String temp = token.nextToken();
                    if (i == 8) {
                        total = NumberUtil.convertToInteger((Object)temp);
                    }
                    if (i == 13) {
                        available = NumberUtil.convertToInteger((Object)temp);
                    }
                    ++i;
                }
                if (null != total && null != available) {
                    result[0] = total - available;
                    result[1] = available;
                }
            }
            this.closeResource(bufRead, process);
        }
        catch (IOException e) {
            LOGGER.error((Object)("IOException" + e), 1L);
            this.closeResource(bufRead, process);
        }
        catch (Exception e2) {
            LOGGER.error((Object)("Exception" + ExceptionUtil.getErrorMessage((Throwable)e2)), 1L);
            this.closeResource(bufRead, process);
            {
                catch (Throwable throwable) {
                    this.closeResource(bufRead, process);
                    throw throwable;
                }
            }
        }
        return result;
    }

    private void setResultByToken(int[] result, StringTokenizer token) {
        int i = 1;
        while (token.hasMoreTokens()) {
            String temp = token.nextToken();
            if (i == 16) {
                result[0] = NumberUtil.convertToInteger((Object)temp);
            }
            if (i == 17) {
                result[1] = NumberUtil.convertToInteger((Object)temp);
            }
            ++i;
        }
    }

    private void closeResource(BufferedReader bufRead, Process process) {
        try {
            if (null != bufRead) {
                bufRead.close();
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)"buf close failure:", (Throwable)e, 1L);
        }
        if (null != process) {
            try {
                process.destroy();
            }
            catch (Exception e2) {
                LOGGER.error((Object)("buf close failure:" + ExceptionUtil.getErrorMessage((Throwable)e2)), 1L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CpuInfo getSomeTimeCpuInfo() {
        LOGGER.debug((Object)"getCpuInfo() | start", 1L);
        CpuInfo cpuInfo = new CpuInfo();
        BufferedReader bufReader = null;
        FileInputStream fin = null;
        try {
            StringTokenizer token;
            File file = new File(LinuxSystemTool.getCpuInfoPath());
            fin = new FileInputStream(file);
            bufReader = new BufferedReader(new InputStreamReader((InputStream)fin, "UTF-8"));
            String str = this.getLineFromFile(bufReader);
            if (!str.equals("") && (token = new StringTokenizer(str)).hasMoreTokens()) {
                token.nextToken();
                cpuInfo.setUser(Float.parseFloat(token.nextToken()));
                cpuInfo.setNice(Float.parseFloat(token.nextToken()));
                cpuInfo.setSys(Float.parseFloat(token.nextToken()));
                cpuInfo.setIdle(Float.parseFloat(token.nextToken()));
                cpuInfo.setSyswa(Float.parseFloat(token.nextToken()));
                cpuInfo.setSyswi(Float.parseFloat(token.nextToken()));
                cpuInfo.setSyssi(Float.parseFloat(token.nextToken()));
                cpuInfo.setSysst(Float.parseFloat(token.nextToken()));
            }
        }
        catch (NumberFormatException e) {
            LOGGER.error((Object)"NumberFormatException Exception", (Throwable)e, 1L);
            throw new LegoCheckedException(1073947393L, (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.info((Object)String.format(Locale.ENGLISH, "GetCpuInfo() | IOException:{0}%s", e), 1L);
        }
        finally {
            try {
                if (null != fin) {
                    fin.close();
                }
            }
            catch (IOException e) {
                LOGGER.error((Object)"fail to close buf IOException", (Throwable)e, 1L);
            }
            try {
                if (null != bufReader) {
                    bufReader.close();
                }
            }
            catch (IOException e) {
                LOGGER.error((Object)"fail to close buf IOException", (Throwable)e, 1L);
            }
        }
        return cpuInfo;
    }

    private String getLineFromFile(BufferedReader bufReader) throws IOException {
        StringBuffer strBuf = new StringBuffer();
        try {
            int tempChar;
            while ((tempChar = bufReader.read()) != -1 && (char)tempChar != '\n' && (char)tempChar != '\r') {
                strBuf.append((char)tempChar);
            }
        }
        catch (IOException e) {
            throw new IOException(e);
        }
        return strBuf.toString().trim();
    }

    @Override
    public double getCpuInfo() {
        double cpuUsedPercent = 0.0;
        CpuInfo infoOne = this.getSomeTimeCpuInfo();
        CommonUtil.sleep((long)1000L);
        CpuInfo infoTwo = this.getSomeTimeCpuInfo();
        float total = infoTwo.getUser() + infoTwo.getSys() + infoTwo.getNice() + infoTwo.getIdle() + infoTwo.getSyswa() + infoTwo.getSyswi() + infoTwo.getSyssi() + infoTwo.getSysst() - (infoOne.getUser() + infoOne.getSys() + infoOne.getNice() + infoOne.getIdle() + infoOne.getSyswa() + infoOne.getSyswi() + infoOne.getSyssi() + infoOne.getSysst());
        if (0.0f != total) {
            cpuUsedPercent = 1.0f - (infoTwo.idle - infoOne.idle) / total;
        }
        LOGGER.debug((Object)String.format(Locale.ENGLISH, "GetCpuInfo() | cpuUsedPercent is:{0} %s.", cpuUsedPercent), 1L);
        return 100.0 * cpuUsedPercent;
    }

    public static String getMemInfoPath() {
        return MEM_INFO_PATH;
    }

    public static String getCpuInfoPath() {
        return CPU_INFO_PATH;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DiskResouceUse> getDisk() {
        LOGGER.debug((Object)"getRootPartition() | start to get root partition", 1L);
        ArrayList<DiskResouceUse> diskList = new ArrayList<DiskResouceUse>();
        String osName = System.getProperty("os.name");
        if (null == osName) {
            return diskList;
        }
        String os = osName.toLowerCase(Locale.ENGLISH);
        if (!os.contains("linux")) {
            return diskList;
        }
        String runtimePath = PathUtil.getRuntimePath();
        Process process = null;
        BufferedReader in = null;
        InputStreamReader ir = null;
        int exitVal = -1;
        try {
            if (null == runtimePath || !Paths.get(runtimePath, new String[0]).toFile().exists()) {
                LOGGER.debug((Object)"runtimePath is not exist");
                ArrayList<DiskResouceUse> arrayList = diskList;
                return arrayList;
            }
            String cmd = "df -hT / " + runtimePath;
            process = Runtime.getRuntime().exec(cmd);
            CommonUtil.sleep((long)30000L);
            long startTime = System.currentTimeMillis();
            exitVal = this.processTime(process, exitVal, startTime);
            if (0 == exitVal) {
                ir = new InputStreamReader(process.getInputStream(), "UTF-8");
                in = new BufferedReader(ir);
                this.addResouceUse(diskList, in);
            }
            this.closeStream(process, in, ir);
        }
        catch (IOException e) {
            LOGGER.error((Object)"Fail to get root partition, IOException:", (Throwable)e, 1L);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Fail to get root partition, exception:" + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
        finally {
            this.closeStream(process, in, ir);
        }
        return diskList;
    }

    private void addResouceUse(List<DiskResouceUse> diskList, BufferedReader in) throws IOException {
        DiskResouceUse resourceUse = null;
        String str = "";
        while (null != (str = this.getLineFromFile(in)) && !"".equals(str)) {
            StringTokenizer tokens = new StringTokenizer(str, " \t\n\r\f%");
            String fileSystem = "";
            String fileNameLong = tokens.nextToken();
            if (!tokens.hasMoreTokens()) {
                str = this.getLineFromFile(in);
                if (null == str) {
                    throw new IOException("Expected a line before filesystem name.");
                }
                fileSystem = fileNameLong;
            }
            if (null == (resourceUse = this.getResouceUse(str, fileSystem))) continue;
            diskList.add(resourceUse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int processTime(Process process, int exitVal, long startTime) {
        boolean processFinished = false;
        while (System.currentTimeMillis() - startTime < 5000L && !processFinished) {
            try {
                StreamConsumer errConsumer = new StreamConsumer(process.getErrorStream(), "std_ERROR");
                errConsumer.start();
                exitVal = process.exitValue();
                errConsumer.join();
                if (0 != exitVal) continue;
                processFinished = Boolean.TRUE;
            }
            catch (IllegalThreadStateException e) {
                LOGGER.error((Object)"IllegalThreadStateException", (Throwable)e, 1L);
            }
            catch (Exception e) {
                LOGGER.error((Object)("Exception" + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
            }
            finally {
                CommonUtil.sleep((long)30000L);
            }
        }
        return exitVal;
    }

    private void closeStream(Process process, BufferedReader in, InputStreamReader ir) {
        try {
            if (null != in) {
                in.close();
            }
        }
        catch (IOException ioex) {
            LOGGER.error((Object)"fail to close input", (Throwable)ioex, 1L);
        }
        try {
            if (null != ir) {
                ir.close();
            }
        }
        catch (IOException ioex) {
            LOGGER.error((Object)"fail to close input", (Throwable)ioex, 1L);
        }
        if (null != process) {
            try {
                process.destroy();
            }
            catch (Exception ex) {
                LOGGER.error((Object)("buf close failure:" + ExceptionUtil.getErrorMessage((Throwable)ex)), 1L);
            }
        }
    }

    private DiskResouceUse getResouceUse(String str, String filesystem) {
        DiskResouceUse resourceUse = null;
        String keyword = "/dev";
        String ukeyword = "udev";
        if ((filesystem.contains(keyword) && !filesystem.contains(ukeyword) || str.contains(keyword)) && !str.contains(ukeyword)) {
            String temp = str.replaceAll("\\s", " ");
            String[] result = new String[7];
            StringTokenizer tokenizer = new StringTokenizer(temp, " \t\n\r\f%");
            this.buildResult(filesystem, result, tokenizer);
            if (ISO.equalsIgnoreCase(result[1])) {
                return null;
            }
            if (UDF.equalsIgnoreCase(result[1])) {
                return null;
            }
            resourceUse = new DiskResouceUse();
            resourceUse.setDiskName(result[6]);
            resourceUse.setTotal(result[2]);
            resourceUse.setUsed(result[3]);
            resourceUse.setAvail(result[4]);
            resourceUse.setPercent(result[5]);
            resourceUse = this.unit(resourceUse);
            resourceUse.setUnit("GB");
        }
        return resourceUse;
    }

    private void buildResult(String filesystem, String[] result, StringTokenizer tokenizer) {
        for (int i = 0; tokenizer.hasMoreTokens() && i < 7; ++i) {
            result[i] = !"".equals(filesystem) && i == 0 ? filesystem : tokenizer.nextToken();
        }
    }

    private DiskResouceUse unit(DiskResouceUse diskResouceUse) {
        String avail = diskResouceUse.getAvail();
        String used = diskResouceUse.getUsed();
        String total = diskResouceUse.getTotal();
        if (avail.contains("M") || avail.contains("K") || avail.contains("T") || avail.contains("P")) {
            diskResouceUse.setAvail(this.getGb(avail));
        }
        this.setDiskResouceParams(diskResouceUse, used, total);
        return diskResouceUse;
    }

    private void setDiskResouceParams(DiskResouceUse diskResouceUse, String used, String total) {
        if (used.contains("M") || used.contains("K") || used.contains("T") || used.contains("P")) {
            diskResouceUse.setUsed(this.getGb(used));
        }
        if (total.contains("M") || total.contains("K") || total.contains("T") || total.contains("P")) {
            diskResouceUse.setTotal(this.getGb(total));
        }
    }

    private String getGb(String value) {
        Double gbValue;
        String gb = "";
        String gbUnit = "G";
        if (value.contains("M")) {
            gbValue = MathUtil.getDoubleValue((double)(NumberUtil.convertToDouble((Object)value.replaceAll("M", "")) / 1000.0), (int)2);
            gb = gbValue + gbUnit;
        }
        if (value.contains("K")) {
            gbValue = MathUtil.getDoubleValue((double)(NumberUtil.convertToDouble((Object)value.replaceAll("K", "")) / 1000000.0), (int)2);
            gb = gbValue + gbUnit;
        }
        if (value.contains("T")) {
            gbValue = MathUtil.getDoubleValue((double)(NumberUtil.convertToDouble((Object)value.replaceAll("T", "")) * 1000.0), (int)2);
            gb = gbValue + gbUnit;
        }
        if (value.contains("P")) {
            gbValue = MathUtil.getDoubleValue((double)(NumberUtil.convertToDouble((Object)value.replaceAll("P", "")) * 1000.0 * 1000.0), (int)2);
            gb = gbValue + gbUnit;
        }
        return gb;
    }

    @Override
    public String[] getAllInfo(String para) {
        return new String[0];
    }

    static class StreamConsumer
    extends Thread {
        private InputStream inputStream;
        private String name;
        private List<String> evader = new ArrayList<String>();

        StreamConsumer(InputStream inputStream, String name) {
            this.inputStream = inputStream;
            this.name = name;
            super.setName(name);
        }

        @Override
        public void run() {
            try (InputStreamReader isr = new InputStreamReader(this.inputStream, StandardCharsets.UTF_8);
                 BufferedReader br = new BufferedReader(isr);
                 SafeBufferedReader safeBufReader = new SafeBufferedReader((Reader)br);){
                String line;
                while ((line = safeBufReader.readLine()) != null) {
                    this.evader.add(this.name + " " + line);
                }
                this.evader.clear();
            }
            catch (IOException exception) {
                LOGGER.error((Object)String.format(Locale.ROOT, "STD StreamGobbler %s", ExceptionUtil.getErrorMessage((Throwable)exception)));
            }
        }
    }

    private static class CpuInfo {
        private float user;
        private float nice;
        private float sys;
        private float idle;
        private float syswa;
        private float syswi;
        private float syssi;
        private float sysst;

        private CpuInfo() {
        }

        public float getUser() {
            return this.user;
        }

        public void setUser(float user) {
            this.user = user;
        }

        public float getNice() {
            return this.nice;
        }

        public void setNice(float nice) {
            this.nice = nice;
        }

        public float getSys() {
            return this.sys;
        }

        public void setSys(float sys) {
            this.sys = sys;
        }

        public float getIdle() {
            return this.idle;
        }

        public void setIdle(float idle) {
            this.idle = idle;
        }

        public float getSyswa() {
            return this.syswa;
        }

        public void setSyswa(float syswa) {
            this.syswa = syswa;
        }

        public float getSyswi() {
            return this.syswi;
        }

        public void setSyswi(float syswi) {
            this.syswi = syswi;
        }

        public float getSyssi() {
            return this.syssi;
        }

        public void setSyssi(float syssi) {
            this.syssi = syssi;
        }

        public float getSysst() {
            return this.sysst;
        }

        public void setSysst(float sysst) {
            this.sysst = sysst;
        }
    }
}

