/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.discover.service;

import com.huawei.lego.core.sdk.common.ServiceProvider;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.nem.discover.sdk.model.DiscoveryPolicy;
import com.huawei.lego.nem.discover.util.DiscoveryUtil;
import java.sql.Timestamp;

public abstract class AbstractDiscoveryThread
implements Runnable {
    private static final int VALUE_100 = 100;
    private static final int VALUE_3 = 3;
    private static final int VALUE_500 = 500;
    private static final Log LOGGER = LogFactory.getInstance(AbstractDiscoveryThread.class);
    private DiscoveryPolicy policy;
    private boolean cancel = false;

    public AbstractDiscoveryThread(DiscoveryPolicy policy) {
        this.policy = policy;
    }

    public DiscoveryPolicy getPolicy() {
        return this.policy;
    }

    public void setPolicy(DiscoveryPolicy policy) {
        this.policy = policy;
    }

    public boolean isCancel() {
        return this.cancel;
    }

    public void setCancel(boolean cancel) {
        this.cancel = cancel;
    }

    public void stop() {
        this.cancel = true;
        this.policy.setFinished(Boolean.valueOf(true));
        this.policy.setEndDiscoveryTime(new Timestamp(System.currentTimeMillis()));
        this.policy.setDiscoveryPercentStr("100%");
        this.policy.setDiscoveryPercentInt(100);
        this.policy.setManualStopped(Boolean.valueOf(true));
    }

    public boolean isSocketReachable(String host) {
        LOGGER.info((Object)"Begin test SocketReachable.");
        return DiscoveryUtil.isSocketreachable(this.policy, host);
    }

    public boolean isIpReachable(String ipAddress) {
        boolean reachable = false;
        int count = 0;
        while (!reachable && count < 3) {
            ++count;
            try {
                reachable = ServiceProvider.getPingService().ping(ipAddress);
            }
            catch (Exception e) {
                LOGGER.error((Object)("pinging ip : " + ipAddress + "...... failed" + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
            }
            if (reachable) {
                LOGGER.info((Object)(ipAddress + " is reachable"), 1L);
                continue;
            }
            LOGGER.info((Object)(ipAddress + " is not reachable, try times is : " + count), 1L);
            CommonUtil.sleep((long)500L);
        }
        return reachable;
    }

    @Override
    public abstract void run();
}

