/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.discover.util;

import com.huawei.lego.cbb.resource.service.CommonServiceImpl;
import com.huawei.lego.cbb.resource.util.DaoParamUtil;
import com.huawei.lego.comm.security.BcmSSLSocketFactory;
import com.huawei.lego.core.sdk.common.ServiceProvider;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.LegoProperties;
import com.huawei.lego.nem.discover.sdk.model.DiscoveryPolicy;
import com.huawei.lego.nem.discover.util.DaoFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.springframework.util.StringUtils;

public class DiscoveryUtil {
    private static final int VALUE_65535 = 65535;
    private static final Log LOGGER = LogFactory.getInstance(DiscoveryUtil.class);
    private static final int CONNECT_TIMOUT = 3000;
    private static final int CONNECT_TIMOUT_THRESHOLD = 30000;
    private static final String KEY_CONNECT_TIMOUT = "disc.socket.connect.timeout";

    public static String getSysOidByDeviceType(String deviceMainType, String deviceSubType) {
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("select dt.sysOid from DevTypeRegister dt, DeviceTypeRelation dtr where ").append(" dt.devTypeRegId = dtr.id and dtr.parentType = ?");
        Map<Integer, String> params = DaoParamUtil.hqlParams(deviceMainType);
        if (StringUtils.hasText((String)deviceSubType)) {
            sqlBuilder.append(" and dtr.childType = ?");
            params.put(1, deviceSubType);
        }
        List<?> sysoidList = DaoFactory.getInstance().getResourceDao().findByHql(sqlBuilder.toString(), params);
        String sysoid = "";
        if (sysoidList != null && !sysoidList.isEmpty()) {
            LOGGER.info((Object)String.format(Locale.ENGLISH, "Query result sysoidList is : %s.", sysoidList), 1L);
            sysoid = (String)sysoidList.get(0);
        } else {
            LOGGER.info((Object)"query result sysoidList is : null or empty", 1L);
        }
        return sysoid;
    }

    public static boolean checkIpDuplicate(String ip) {
        StringBuffer hql = new StringBuffer();
        hql.append("select count(node.moId) from Node node where node.ipAddress = ?");
        hql.append(" and (node.description is null or node.description <> 'manual')");
        CommonServiceImpl serviceImpl = (CommonServiceImpl)ServiceProvider.getCommonService();
        long count = (Long)serviceImpl.getCommonDao().getBaseHibernateTemplate().find(hql.toString(), new Object[]{new String[]{ip}}).listIterator().next();
        LOGGER.info((Object)String.format(Locale.ENGLISH, "The ip is : %s, count is : %s.", ip, count), 1L);
        return count != 0L;
    }

    public static boolean isSocketreachable(DiscoveryPolicy policy, String host) {
        String[] splits;
        String deviceType = policy.getDeviceType();
        String port = (String)policy.getParamMap().get("port");
        Boolean disablePing = Boolean.valueOf((String)policy.getParamMap().get("disablePing"));
        if (disablePing.booleanValue()) {
            LOGGER.info((Object)"Disable ping, deviceType=%s, host=%s, port=%s.", new Object[]{deviceType, host, port});
            return true;
        }
        if (port != null && !port.trim().isEmpty()) {
            return DiscoveryUtil.isSocketreachable(host, port);
        }
        String types = LegoProperties.getProperty((String)"disc.socket.test.deviceType", (String)"");
        if (!types.contains(deviceType)) {
            LOGGER.error((Object)"Device type is not configured for auto ping, deviceType=%s.", new Object[]{deviceType});
            return false;
        }
        String portStr = LegoProperties.getProperty((String)"disc.socket.test.ports", (String)"");
        if (portStr.trim().isEmpty()) {
            LOGGER.error((Object)"The auto ping ports config is empty.");
            return false;
        }
        for (String split : splits = portStr.split(",")) {
            if (!DiscoveryUtil.isSocketreachable(host, split)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isSocketreachable(String host, String portStr) {
        int port = DiscoveryUtil.getPort(portStr);
        int timeout = 3000;
        if (port < 0) {
            LOGGER.error((Object)"Error port:%s. ", new Object[]{portStr});
            return false;
        }
        timeout = DiscoveryUtil.getTimeout(timeout);
        Socket st = null;
        BcmSSLSocketFactory factory = new BcmSSLSocketFactory(host, new String[0]);
        InetSocketAddress sa = new InetSocketAddress(host, port);
        st = factory.createSocket();
        st.connect(sa, timeout);
        if (st == null) return true;
        try {
            st.close();
            return true;
        }
        catch (IOException e) {
            LOGGER.error((Object)"Socket ping failed, ip=%s,port=%s,errMsg=%s.", new Object[]{host, port, ExceptionUtil.getErrorMessage((Throwable)e)});
        }
        return true;
        catch (Exception ex) {
            boolean bl;
            try {
                LOGGER.error((Object)"Socket ping failed, ip=%s,port=%s,errMsg=%s.", new Object[]{host, port, ExceptionUtil.getErrorMessage((Throwable)ex)});
                bl = false;
                if (st == null) return bl;
            }
            catch (Throwable throwable) {
                if (st == null) throw throwable;
                try {
                    st.close();
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.error((Object)"Socket ping failed, ip=%s,port=%s,errMsg=%s.", new Object[]{host, port, ExceptionUtil.getErrorMessage((Throwable)e)});
                }
                throw throwable;
            }
            try {
                st.close();
                return bl;
            }
            catch (IOException e) {
                LOGGER.error((Object)"Socket ping failed, ip=%s,port=%s,errMsg=%s.", new Object[]{host, port, ExceptionUtil.getErrorMessage((Throwable)e)});
            }
            return bl;
        }
    }

    private static int getPort(String portStr) {
        try {
            int port = Integer.parseInt(portStr);
            if (port > 65535 || port < 0) {
                return -1;
            }
            return port;
        }
        catch (NumberFormatException nex) {
            LOGGER.error((Object)"The port format error: %s.", new Object[]{portStr});
            return -1;
        }
    }

    private static int getTimeout(int timeout) {
        String timeoutStr = LegoProperties.getProperty((String)KEY_CONNECT_TIMOUT, (String)String.valueOf(3000));
        try {
            int tout = Integer.parseInt(timeoutStr);
            if (tout > 30000) {
                tout = 30000;
            }
            return tout;
        }
        catch (NumberFormatException nex) {
            LOGGER.error((Object)"The timeout format error:%s,error:%s.", new Object[]{timeoutStr, ExceptionUtil.getErrorMessage((Throwable)nex)});
            return timeout;
        }
    }

    public static boolean isIpReachable(String ipAddress) {
        boolean reachable = false;
        int count = 0;
        while (!reachable && count < 3) {
            ++count;
            try {
                reachable = ServiceProvider.getPingService().ping(ipAddress);
            }
            catch (Exception e) {
                LOGGER.error((Object)("pinging ip : " + ipAddress + "...... failed" + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
            }
            if (reachable) {
                LOGGER.info((Object)"%s is reachable", new Object[]{ipAddress});
                continue;
            }
            LOGGER.info((Object)"%s is not reachable, try times is : %s", new Object[]{ipAddress, count});
            CommonUtil.sleep((long)500L);
        }
        return reachable;
    }
}

