/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.fault.define;

import com.huawei.lego.core.sdk.base.ICacheService;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.nem.fault.sdk.model.FaultConf;
import com.huawei.lego.nem.fault.sdk.model.FaultDefine;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class FaultDefineCacher {
    private static final String CACHE_KEY = "faultdefine_";
    private static final Log LOGGER = LogFactory.getInstance(FaultDefineCacher.class);
    private static ICacheService<String, FaultConf> cacheService;
    private static List<String> cacheKeys;

    private static void setCacheServiceVar(ICacheService<String, FaultConf> cacheServiceParam) {
        cacheService = cacheServiceParam;
    }

    public static void cacheFaultDefine(FaultConf faultConf) {
        String trapoid = faultConf.getTrapoid();
        List defineList = faultConf.getDefineList();
        String cacheKey = CACHE_KEY + trapoid;
        if (cacheService.containsKey((Object)cacheKey)) {
            FaultConf existFaultConf = (FaultConf)cacheService.get((Object)cacheKey);
            existFaultConf.addFaultDefine(defineList);
            cacheService.put((Object)cacheKey, (Object)existFaultConf);
        } else {
            cacheKeys.add(cacheKey);
            cacheService.put((Object)cacheKey, (Object)faultConf);
        }
        String bundleName = faultConf.getBundleName();
        StringBuffer buf = new StringBuffer();
        for (FaultDefine faultDefine : defineList) {
            buf.append(faultDefine.getFaultId());
            buf.append(", ");
        }
        LOGGER.debug((Object)String.format(Locale.ENGLISH, "Save FaultConf to MemCache success, productName: %s, trapoid: %s, faultIds: %s.", bundleName, trapoid, buf), 1L);
    }

    public static void clearCacheFaultDefine() {
        for (String cacheKey : cacheKeys) {
            cacheService.remove((Object)cacheKey);
        }
    }

    public static FaultDefine getFaultDefine(String productName, String trapoid, String faultId, String moMainType, String moSubType) {
        FaultConf faultConf = (FaultConf)cacheService.get((Object)(CACHE_KEY + trapoid));
        if (faultConf != null) {
            return faultConf.getFaultDefine(faultId, moMainType, moSubType);
        }
        LOGGER.error((Object)new StringBuilder().append("no faultdefine for LegoAlarm, productName: ").append(productName).append(", trapoid: ").append(trapoid).append(", alarmId: ").append(faultId));
        return null;
    }

    public static List<FaultDefine> getFaultDefines(String trapoid, String moMainType, String moSubType) {
        FaultConf faultConf = (FaultConf)cacheService.get((Object)(CACHE_KEY + trapoid));
        if (faultConf != null) {
            return faultConf.getFaultDefine(moMainType, moSubType);
        }
        LOGGER.error((Object)new StringBuilder().append("no faultdefine for LegoAlarm, trapoid: ").append(trapoid));
        return null;
    }

    public static FaultDefine getFaultDefineByFaultId(String faultId, String moMainType, String moSubType) {
        FaultDefine faultDefine = null;
        Set cacheSet = cacheService.keySet();
        Iterator iterator = null;
        if (cacheSet != null) {
            iterator = cacheSet.iterator();
        }
        if (iterator == null) {
            return null;
        }
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            if (!key.startsWith(CACHE_KEY)) continue;
            FaultConf faultConf = (FaultConf)cacheService.get((Object)key);
            if (null != faultConf) {
                faultDefine = faultConf.getFaultDefine(faultId, moMainType, moSubType);
            }
            if (null == faultDefine) continue;
            return faultDefine;
        }
        return null;
    }

    public void setCacheService(ICacheService<String, FaultConf> cacheService) {
        FaultDefineCacher.setCacheServiceVar(cacheService);
    }

    static {
        cacheKeys = new ArrayList<String>();
    }
}

