/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.fault.jms.handler;

import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.cbb.resource.sdk.model.TopoObject;
import com.huawei.lego.comm.internal.jms.MessageUnit;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.nem.detect.sdk.IDetectResourceMsgService;
import com.huawei.lego.nem.fault.jms.IFaultMsgHandler;
import com.huawei.lego.nem.fault.launcher.impl.AlarmSyncLauncher;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import java.util.Collection;
import java.util.Map;

public class ResAddMsgHandler
implements IFaultMsgHandler {
    private static final Log LOGGER = LogFactory.getInstance(ResAddMsgHandler.class);
    private IDetectResourceMsgService detectResourceMsgService;

    @Override
    public long getMsgType() {
        return 103L;
    }

    @Override
    public void handleMsg(MessageUnit mu) {
        Map msgObj = (Map)mu.getObj();
        LOGGER.info((Object)"Recv a COMMAND_RES_ADD message, moIds: %s.", new Object[]{1L, msgObj.keySet()});
        Collection moList = msgObj.values();
        for (ManagedObject mo : moList) {
            if (!(mo instanceof TopoObject)) {
                LOGGER.info((Object)"MO is not TopoObject.", 1L);
                continue;
            }
            try {
                TopoObject topoObj = (TopoObject)mo;
                String ipAddress = topoObj.getIpAddress();
                if (null == ipAddress) {
                    LOGGER.info((Object)"ipAddress is null.", 1L);
                    continue;
                }
                AlarmSyncLauncher.getSynchronizer().createSyncTask(topoObj.getMoId(), topoObj.getName(), ipAddress, FaultEnum.AlarmSyncType.MANU_SYNC);
                this.detectResourceMsgService.unlockDetectResource(topoObj);
            }
            catch (LegoCheckedException e) {
                LOGGER.error((Object)("start alarmsync task failed after adding a topoobject: " + mo), (Throwable)e, 1L);
            }
            catch (Exception e) {
                LOGGER.error((Object)("proccess COMMAND_RES_ADD exception." + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
            }
        }
    }

    public void setDetectResourceMsgService(IDetectResourceMsgService detectResourceMsgService) {
        this.detectResourceMsgService = detectResourceMsgService;
    }
}

