/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.fault.product;

import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.nem.fault.sdk.service.IProductEventBackUpService;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class EventBackUpServiceContainer {
    private static final Log logger = LogFactory.getInstance(EventBackUpServiceContainer.class);
    private static List<IProductEventBackUpService> eventBackUpSrvList = new ArrayList<IProductEventBackUpService>();

    public static boolean isEventBackUp() {
        if (null == eventBackUpSrvList || eventBackUpSrvList.isEmpty()) {
            return true;
        }
        boolean isShowResult = true;
        try {
            for (IProductEventBackUpService service : eventBackUpSrvList) {
                isShowResult = service.checkEventBackUp();
            }
            return isShowResult;
        }
        catch (Exception t) {
            logger.error((Object)("EventBackUpServiceContainer exception." + ExceptionUtil.getErrorMessage((Throwable)t)), 1L);
            return isShowResult;
        }
    }

    public void onBind(IProductEventBackUpService service, Map<String, String> properties) {
        if (null != service) {
            eventBackUpSrvList.add(service);
            logger.info((Object)String.format(Locale.ENGLISH, "OnBind:%s.", service), 1L);
        } else {
            logger.info((Object)"onBind,service is null.", 1L);
        }
    }

    public void onUnbind(IProductEventBackUpService service, Map<String, String> properties) {
        if (null != service) {
            eventBackUpSrvList.remove(service);
            logger.info((Object)String.format(Locale.ENGLISH, "OnUnbind:%s.", service), 1L);
        } else {
            logger.info((Object)"onUnbind,service is null.", 1L);
        }
    }

    public static List<IProductEventBackUpService> getEventBackUpSrvList() {
        return eventBackUpSrvList;
    }

    public static void setEventBackUpSrvList(List<IProductEventBackUpService> eventBackUpSrvList) {
        EventBackUpServiceContainer.eventBackUpSrvList = eventBackUpSrvList;
    }
}

