/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.fault.service;

import com.huawei.lego.core.base.persistance.dao.ICommonDao;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.comm.BatchOperation;
import com.huawei.lego.core.sdk.comm.BatchOperationResult;
import com.huawei.lego.core.sdk.comm.Paging;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoUncheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.nem.fault.dao.IAlarmDAO;
import com.huawei.lego.nem.fault.launcher.impl.AlarmSyncLauncher;
import com.huawei.lego.nem.fault.sdk.model.AlarmSyncTask;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import com.huawei.lego.nem.fault.sdk.service.IAlarmSyncService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@Service(name="alarmSyncService", desc="", interfaceClass=IAlarmSyncService.class)
public class AlarmSyncServiceImpl
extends BaseService
implements IAlarmSyncService {
    private static final Log LOGGER = LogFactory.getInstance(AlarmSyncServiceImpl.class);
    private static final int MAX_PAGE_SIZE = 65535;
    private IAlarmDAO alarmDAO = null;
    private transient ICommonDao commonDao;

    public List<AlarmSyncTask> readSyncTasks(FaultEnum.AlarmSyncType syncType) {
        if (null == syncType) {
            LOGGER.error((Object)"readSyncTasks error:syncType is null.", 1L);
            return new ArrayList<AlarmSyncTask>();
        }
        StringBuffer queryString = new StringBuffer();
        queryString.append("from " + AlarmSyncTask.class.getName() + " as task where task.taskType = ");
        queryString.append(syncType.getValue());
        List<AlarmSyncTask> taskList = this.commonDao.findByHql(queryString.toString());
        return taskList;
    }

    public String readSyncTaksMOName(long syncTaskID) {
        StringBuffer queryString = new StringBuffer();
        queryString.append("from " + AlarmSyncTask.class.getName() + " as task where task.id = ");
        queryString.append(syncTaskID);
        List<?> taskList = this.commonDao.findByHql(queryString.toString());
        if (taskList.isEmpty()) {
            throw new LegoCheckedException(201L);
        }
        return ((AlarmSyncTask)taskList.get(0)).getMoName();
    }

    public void updateTaskMoName(long moId, String moName, String moIp) {
        StringBuffer queryString = new StringBuffer();
        queryString.append("update AlarmSyncTask set moName = ? ,moIP = ?");
        queryString.append(" where moId = ");
        queryString.append(moId);
        Object[] param = new String[]{moName, moIp};
        this.commonDao.updateByHql(queryString.toString(), param);
    }

    public void updateAlarmLocation(long moId, String newLoc) {
        StringBuffer queryString = new StringBuffer();
        String sql = "select location from t_alarm where mo_id = '" + moId + "'";
        List<?> list = this.commonDao.findBySql(sql, new Object[0]);
        if (list.isEmpty() || null == list.get(0)) {
            return;
        }
        String oldLoc = list.get(0).toString();
        if (oldLoc.equals(newLoc)) {
            return;
        }
        queryString.append("update t_alarm set location=? where mo_id =?");
        Object[] param = new Object[]{newLoc, moId};
        this.commonDao.updateBySql(queryString.toString(), param);
    }

    public void deleteTaskByMoId(long moId) {
        StringBuffer queryString = new StringBuffer();
        queryString.append("delete from AlarmSyncTask");
        queryString.append(" where moId = ");
        queryString.append(moId);
        this.commonDao.updateByHql(queryString.toString());
    }

    public Paging querySyncTasks(int startIndex, int pageSize) {
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        StringBuilder queryString = new StringBuilder("from ").append(AlarmSyncTask.class.getName()).append(" as task");
        Paging roPaging = new Paging();
        roPaging.setiCount((int)this.commonDao.getTotalCount("select count(*) " + queryString, param));
        queryString.append(" order by task.timeStamp desc,task.moIP desc");
        List<?> taskList = this.commonDao.findPage("select task " + queryString, startIndex, pageSize, param);
        roPaging.setData(taskList);
        return roPaging;
    }

    public BatchOperationResult deleteSyncTasks(List<BatchOperation> deleteOpList) {
        BatchOperationResult result = new BatchOperationResult();
        ArrayList<BatchOperation> resultList = new ArrayList<BatchOperation>();
        int fail = 0;
        int operCount = 0;
        if (null != deleteOpList && !deleteOpList.isEmpty()) {
            LOGGER.debug((Object)"deleteSyncTasks:deleteOpList is not null");
            operCount = deleteOpList.size();
            for (BatchOperation batchOperation : deleteOpList) {
                fail = this.deleteSynTask(fail, batchOperation);
                resultList.add(batchOperation);
            }
            result.setResult(resultList);
            result.setFailCount(fail);
            result.setTotalCount(operCount);
            result.setSucceedCount(operCount - fail);
        }
        return result;
    }

    private synchronized int deleteSynTask(int fail, BatchOperation batchOperation) {
        try {
            this.alarmDAO.deleteAlarmSyncTask(batchOperation.getTargetId());
        }
        catch (LegoCheckedException ce) {
            ++fail;
            batchOperation.setErrorCode(ce.getErrorCode());
        }
        catch (LegoUncheckedException ue) {
            ++fail;
            batchOperation.setErrorCode(ue.getErrorCode());
        }
        catch (Exception e) {
            ++fail;
            batchOperation.setErrorCode(102L);
        }
        return fail;
    }

    public BatchOperationResult createSyncTasks(List<BatchOperation> syncOperations) {
        BatchOperationResult result = new BatchOperationResult();
        ArrayList<BatchOperation> resultList = new ArrayList<BatchOperation>();
        int fail = 0;
        int operCount = 0;
        if (null != syncOperations) {
            LOGGER.debug((Object)"createSyncTasks:syncOperations is not null");
            operCount = syncOperations.size();
            for (BatchOperation batchOperation : syncOperations) {
                fail = this.createSynTask(fail, batchOperation);
                resultList.add(batchOperation);
            }
        }
        result.setResult(resultList);
        result.setFailCount(fail);
        result.setTotalCount(operCount);
        result.setSucceedCount(operCount - fail);
        return result;
    }

    private int createSynTask(int fail, BatchOperation batchOperation) {
        try {
            AlarmSyncLauncher.getSynchronizer().createSyncTask(batchOperation.getTargetId(), batchOperation.getTargetName(), batchOperation.getOptDetail(), FaultEnum.AlarmSyncType.MANU_SYNC);
        }
        catch (LegoCheckedException e) {
            ++fail;
            batchOperation.setErrorCode(e.getErrorCode());
        }
        catch (LegoUncheckedException e) {
            ++fail;
            batchOperation.setErrorCode(e.getErrorCode());
        }
        LOGGER.debug((Object)"createSynTask:completed");
        return fail;
    }

    public BatchOperationResult startAlarmSyncTask(List<BatchOperation> syncOperations) {
        BatchOperationResult result = new BatchOperationResult();
        ArrayList<BatchOperation> resultList = new ArrayList<BatchOperation>();
        int fail = 0;
        int operCount = 0;
        if (null != syncOperations) {
            LOGGER.debug((Object)"startAlarmSyncTask:syncOperations is not null");
            operCount = syncOperations.size();
            for (BatchOperation batchOperation : syncOperations) {
                fail = this.startAlarmSyncTask(fail, batchOperation);
                resultList.add(batchOperation);
            }
        }
        result.setResult(resultList);
        result.setFailCount(fail);
        result.setTotalCount(operCount);
        result.setSucceedCount(operCount - fail);
        return result;
    }

    private synchronized int startAlarmSyncTask(int fail, BatchOperation batchOperation) {
        try {
            AlarmSyncLauncher.getSynchronizer().launchSyncTask(this.alarmDAO.getAlarmSyncTask(batchOperation.getTargetId()));
        }
        catch (LegoCheckedException e) {
            ++fail;
            batchOperation.setErrorCode(e.getErrorCode());
        }
        catch (LegoUncheckedException e) {
            ++fail;
            batchOperation.setErrorCode(e.getErrorCode());
        }
        return fail;
    }

    public void resetSynStatus() {
        Paging paging = this.querySyncTasks(0, 65535);
        List allTaskList = paging.getData();
        for (AlarmSyncTask alarmSyncTask : allTaskList) {
            if (alarmSyncTask.getTaskStatus() != 1) continue;
            alarmSyncTask.setTaskStatus(2);
            alarmSyncTask.setEndTime(System.currentTimeMillis());
            alarmSyncTask.setErrorCode(0L);
            this.alarmDAO.updateAlarmSyncTask(alarmSyncTask);
            StringBuffer buffer = new StringBuffer();
            buffer.append("resetSynStatus,moName=");
            buffer.append(alarmSyncTask.getMoName());
            buffer.append(",moIP=");
            buffer.append(alarmSyncTask.getMoIP());
            buffer.append(",id=");
            buffer.append(alarmSyncTask.getId());
            buffer.append(",taskType=");
            buffer.append(alarmSyncTask.getTaskType());
            LOGGER.info((Object)buffer.toString(), 1L);
        }
    }

    public AlarmSyncTask querySyncTask(long taskid) {
        StringBuffer queryString = new StringBuffer();
        queryString.append("from " + AlarmSyncTask.class.getName() + " as task where task.id = ?");
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(0, String.valueOf(taskid));
        List<?> taskList = this.commonDao.findByHql(queryString.toString(), map);
        if (taskList.isEmpty()) {
            throw new LegoCheckedException(201L);
        }
        return (AlarmSyncTask)taskList.get(0);
    }

    public IAlarmDAO getAlarmDAO() {
        return this.alarmDAO;
    }

    public void setAlarmDAO(IAlarmDAO alarmDAO) {
        this.alarmDAO = alarmDAO;
    }

    public ICommonDao getCommonDao() {
        return this.commonDao;
    }

    public void setCommonDao(ICommonDao commonDao) {
        this.commonDao = commonDao;
    }
}

