/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.fault.trap.filter;

import com.huawei.lego.comm.internal.jms.MessageTopic;
import com.huawei.lego.comm.internal.jms.MessageUnit;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.nem.fault.launcher.impl.MsgSubscribeLauncher;
import com.huawei.lego.nem.fault.launcher.impl.TrapReceiverLauncher;
import com.huawei.lego.nem.fault.sdk.model.AlarmPDU;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import com.huawei.lego.nem.fault.sdk.model.SnmpTrapPDU;
import com.huawei.lego.nem.fault.sdk.service.IPDUFilter;
import com.huawei.lego.nem.fault.util.FaultUtil;
import org.snmp4j.CommandResponderEvent;

public class SnmpForwardFilter
implements IPDUFilter {
    private static final long serialVersionUID = 5418388463253206665L;
    private Log logger = LogFactory.getInstance(SnmpForwardFilter.class);

    public void doFilter(AlarmPDU alarmPdu) {
        CommandResponderEvent snmpEvent = (CommandResponderEvent)alarmPdu.getPduObj();
        SnmpTrapPDU snmpPdu = FaultUtil.convertSnmpPDU(snmpEvent);
        String trapoid = snmpPdu.getTrapoid();
        boolean isFaultTrap = TrapReceiverLauncher.isFaultTrap(trapoid);
        if (isFaultTrap) {
            return;
        }
        this.sendTrap(snmpPdu);
    }

    private void sendTrap(SnmpTrapPDU trappdu) {
        this.logger.debug((Object)new StringBuilder().append("send COMMAND_SNMP_OTHER_TRAP message received from ").append(trappdu.getRemoteHost() + ", version: ").append(trappdu.getVersion() + ", trapoid: ").append(trappdu.getTrapoid()), 1L);
        MessageUnit mu = new MessageUnit();
        mu.setCmdcode(5005L);
        mu.setObj(trappdu);
        mu.setMt(MessageTopic.DATA);
        mu.setSourceAppName(this.getClass().getName());
        MsgSubscribeLauncher.getMc().sendMessage(mu);
    }

    public FaultEnum.PDUType getPduType() {
        return FaultEnum.PDUType.SNMP;
    }
}

