/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.fault.trap.listener;

import com.huawei.lego.cbb.resource.util.DaoFactory;
import com.huawei.lego.cbb.resource.util.DaoParamUtil;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import com.huawei.lego.nem.fault.sdk.model.LegoAlarm;
import com.huawei.lego.nem.fault.sdk.service.IFaultGenerateService;
import com.huawei.lego.nem.fault.trap.listener.ForceDecodeDefender;
import com.huawei.lego.nem.fault.trap.listener.IForceDecodeAlarmListener;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ForceDecodeAlarmListener
implements IForceDecodeAlarmListener {
    private static final Log LOGGER = LogFactory.getInstance(ForceDecodeAlarmListener.class);
    private static final int VALUE_2 = 2;
    private IFaultGenerateService alarmService;

    @Override
    public void onMessage(String unit) {
        LOGGER.info((Object)String.format(Locale.ENGLISH, "##### onMessage: %s.", unit), 1L);
        this.generateAlarm(unit);
    }

    private String getUuid(String linkIp) {
        try {
            String sql = "select obj.uuid from ManagedObject obj where obj.moId in (select entity.moId from NetworkEntity entity where entity.linkIp = ?)";
            Map<Integer, String> params = DaoParamUtil.hqlParams(linkIp);
            List<?> list = DaoFactory.getInstance().getResourceDao().findByHql(sql, params);
            if (!VerifyUtil.isEmpty(list)) {
                return (String)list.get(0);
            }
            LOGGER.debug((Object)String.format(Locale.ENGLISH, "Get uuid failue, linkIp = %s.", linkIp));
        }
        catch (Exception e) {
            LOGGER.error((Object)"get uuid failue, linkIp = %s,error = %s.", new Object[]{linkIp, ExceptionUtil.getErrorMessage((Throwable)e)});
        }
        return null;
    }

    private void generateAlarm(String unit) {
        if (unit == null) {
            LOGGER.warn((Object)"Generate alarm failed, unit is null.");
            return;
        }
        boolean isV2c = false;
        String resouceIp = unit;
        String[] param = unit.split(",");
        if (param.length == 2) {
            resouceIp = param[0];
            isV2c = true;
        }
        String[] alarmParam = new String[]{String.valueOf(resouceIp), String.valueOf("v3")};
        if (isV2c) {
            alarmParam[1] = "v2c";
        }
        String alarmId = "0x000803220101";
        if (this.alarmService == null) {
            LOGGER.error((Object)"Generate alarm failed, alarmService is null.");
            return;
        }
        String uuid = this.getUuid(resouceIp);
        if (uuid == null) {
            return;
        }
        LegoAlarm alarm = new LegoAlarm();
        alarm.setAlarmId(alarmId);
        alarm.setAlarmTime(System.currentTimeMillis());
        alarm.setAlarmParam(alarmParam);
        alarm.setEntity(alarmId + resouceIp);
        alarm.setSourceId(uuid);
        alarm.setSourceType(FaultEnum.AlarmResourceType.NETWORKENTITY.getValue());
        try {
            this.alarmService.generateLegoAlarm(alarm);
        }
        catch (Exception e) {
            LOGGER.error((Object)"alarmService generate LegoRestoreAlarm error,error is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        }
    }

    public IFaultGenerateService getAlarmService() {
        return this.alarmService;
    }

    public void setAlarmService(IFaultGenerateService alarmService) {
        this.alarmService = alarmService;
    }

    public void register() {
        ForceDecodeDefender.getInstance().registAlarmListener(this);
    }
}

