/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.base.service;

import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.service.ITaskManager;
import com.huawei.ism.drm.protection.framework.engine.job.ProtectionQuartzTriggerListener;
import com.huawei.ism.drm.protection.framework.engine.util.ProtectionJobUtil;
import com.huawei.ism.drm.task.sdk.model.BaseTask;
import com.huawei.ism.drm.task.sdk.model.ISchedule;
import com.huawei.ism.drm.task.sdk.model.ITask;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.file.util.AdapterUtils;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.io.InputStream;
import java.net.URL;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.TriggerListener;
import org.quartz.impl.JobDetailImpl;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.impl.triggers.AbstractTrigger;
import org.quartz.impl.triggers.CronTriggerImpl;
import org.quartz.impl.triggers.SimpleTriggerImpl;

public class TaskManagerImpl
implements ITaskManager {
    private static final Log logger = LogFactory.getInstance(TaskManagerImpl.class);
    private static final String PROTECTGROUPNAME = "ProtectGroupQuartzScheduler";
    private static final String DEFAULT_PROPERTIES = "protectgroup_quartz.properties";
    private Properties props = new Properties();
    private Scheduler quartzScheduler;
    private Map<String, Class<? extends Job>> jobClassMap = new HashMap<String, Class<? extends Job>>();

    public void start() {
        this.startQuartz();
    }

    private void startQuartz() {
        try {
            StdSchedulerFactory sf = new StdSchedulerFactory();
            if (sf.getScheduler(PROTECTGROUPNAME) != null) {
                this.quartzScheduler = sf.getScheduler(PROTECTGROUPNAME);
            } else {
                this.readProperties();
                sf.initialize(this.props);
                this.quartzScheduler = sf.getScheduler();
            }
            this.quartzScheduler.getListenerManager().addTriggerListener((TriggerListener)new ProtectionQuartzTriggerListener());
            this.quartzScheduler.start();
        }
        catch (SchedulerException e) {
            logger.error((Object)"Start quartz failed, error:%s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"load quartz file failed", (long)-1L, (String[])new String[0], (Log)logger);
        }
    }

    @Override
    public <T extends ITask> void recoveryExistTasks(List<T> tasks) {
        logger.debug((Object)"RecoveryExistTasks");
        for (ITask task : tasks) {
            if (1 != task.getStatus()) continue;
            this.schedule(task);
        }
    }

    private boolean isTriggerRunning(String triggerName) {
        boolean isRunning = false;
        List currentJobs = null;
        try {
            currentJobs = this.quartzScheduler.getCurrentlyExecutingJobs();
        }
        catch (SchedulerException e) {
            logger.error((Object)"Get currently executing jobs failed, error: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
        if (currentJobs != null) {
            for (JobExecutionContext jobCtx : currentJobs) {
                Trigger trigger = jobCtx.getTrigger();
                if (!triggerName.equals(trigger.getKey().getName())) continue;
                isRunning = true;
                break;
            }
        }
        return isRunning;
    }

    private boolean isGroupRunning(String groupName) {
        boolean isRunning = false;
        List currentJobs = null;
        try {
            currentJobs = this.quartzScheduler.getCurrentlyExecutingJobs();
        }
        catch (SchedulerException e) {
            logger.error((Object)"Get currently executing jobs failed, error: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
        if (null != currentJobs) {
            for (JobExecutionContext jobCtx : currentJobs) {
                String tmpGroupName = jobCtx.getJobDetail().getKey().getGroup();
                if (!tmpGroupName.equals(groupName)) continue;
                isRunning = true;
                break;
            }
        }
        return isRunning;
    }

    private String getJobName(ITask task) {
        logger.debug((Object)"GetJobName");
        return "JOB_" + task.getTaskId() + task.getJobClassName();
    }

    private String getJobGroupName(ITask task) {
        logger.debug((Object)"GetJobGroupName");
        return "JOB_GROUP_" + task.getTaskGroup();
    }

    private String getTriggerName(ITask task) {
        logger.debug((Object)"GetTriggerName");
        return "TRIGGER_" + task.getTaskId();
    }

    private String getTriggerGroupName(ITask task) {
        logger.debug((Object)"GetTriggerGroupName");
        return "TRIGGER_GROUP_" + task.getTaskGroup();
    }

    private String getManualJobName(ITask task) {
        logger.debug((Object)"GetManualJobName");
        return "MANUAL_JOB_" + task.getJobClassName();
    }

    private Class<? extends Job> getJobClass(String jobClassName) {
        if (jobClassName == null || jobClassName.trim().isEmpty()) {
            return null;
        }
        Class<Object> jobClass = this.jobClassMap.get(jobClassName);
        if (jobClass == null) {
            try {
                ClassLoader clsLoader = this.getClass().getClassLoader();
                if (clsLoader == null) {
                    logger.error((Object)"Get job class failed");
                    throw new LegoCheckedException(-1L);
                }
                jobClass = clsLoader.loadClass(jobClassName);
            }
            catch (ClassNotFoundException e) {
                logger.error((Object)"Get job class failed, error: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e), 90160758784001L});
                throw new LegoCheckedException(-1L, (Throwable)e);
            }
        }
        return jobClass;
    }

    private long calculateInterval(ISchedule schedule) {
        long interval;
        logger.debug((Object)"Schedule.getPeriodType: %s", new Object[]{String.valueOf(schedule.getPeriodType())});
        switch (schedule.getPeriodType()) {
            case 0: {
                interval = (long)schedule.getPeriodInterval() * 1000L * 60L;
                break;
            }
            case 1: {
                interval = (long)schedule.getPeriodInterval() * 1000L * 60L * 60L;
                break;
            }
            case 2: {
                interval = (long)schedule.getPeriodInterval() * 1000L * 24L * 60L * 60L;
                break;
            }
            case 6: {
                interval = 0L;
                break;
            }
            default: {
                logger.error((Object)"Invalid schedule period type, period type: %s", new Object[]{String.valueOf(schedule.getPeriodType())});
                throw new LegoCheckedException(-1L);
            }
        }
        return interval;
    }

    private AbstractTrigger createSimpleTrigger(ITask task) {
        String triggerName = this.getTriggerName(task);
        String triggerGroupName = this.getTriggerGroupName(task);
        logger.info((Object)"TriggerName:%s, triggerGroupName: %s", new Object[]{triggerName, triggerGroupName});
        String jobName = this.getJobName(task);
        String jobGroupName = this.getJobGroupName(task);
        ISchedule schedule = task.getSchedule();
        Calendar validateDateStartCalendar = this.getValidateDateStartTime(schedule);
        Date startTime = validateDateStartCalendar.getTime();
        String endTimeStr = schedule.getEndTime();
        SimpleTriggerImpl quartzSimpleTrigger = new SimpleTriggerImpl(triggerName, triggerGroupName, jobName, jobGroupName, startTime, endTimeStr == null ? null : new Date(NumberUtil.convertToLong((Object)endTimeStr)), schedule.getRepeatTimes(), this.calculateInterval(schedule));
        return quartzSimpleTrigger;
    }

    private Calendar getValidateDateStartTime(ISchedule schedule) {
        String startTime = schedule.getStartTime();
        if (VerifyUtil.isEmpty((String)startTime)) {
            logger.error((Object)"StartTime is empty! schedule Id: %s ", new Object[]{schedule.getScheduleId()});
            throw new LegoCheckedException(-1L);
        }
        int periodType = schedule.getPeriodType();
        if (periodType == 6) {
            Calendar validateStartCalendar = Calendar.getInstance();
            validateStartCalendar.setTime(new Date(NumberUtil.convertToLong((Object)startTime)));
            return validateStartCalendar;
        }
        if (periodType == 2) {
            Calendar validateStartCalendar = Calendar.getInstance();
            validateStartCalendar.setTime(new Date(NumberUtil.convertToLong((Object)startTime)));
            validateStartCalendar.set(11, NumberUtil.convertToInteger((Object)schedule.getHours(), (int)0));
            validateStartCalendar.set(12, NumberUtil.convertToInteger((Object)schedule.getMinutes(), (int)0));
            validateStartCalendar.set(13, 0);
            return validateStartCalendar;
        }
        Calendar validateStartCalendar = Calendar.getInstance();
        Date now = new Date();
        if (!ProtectionJobUtil.getInstance().isTimeInRange(schedule, now)) {
            Date validateStartTime = ProtectionJobUtil.getInstance().getNextExeTimeWhenOutOfTimeRange(schedule, now);
            validateStartCalendar.setTime(validateStartTime);
            return validateStartCalendar;
        }
        Date startDate = new Date(NumberUtil.convertToLong((Object)startTime));
        if (!VerifyUtil.isEmpty((Collection)schedule.getScheduleRanges()) && startDate.before(now)) {
            Date validateStartTime = ProtectionJobUtil.getInstance().getStartTimeInRangeTime(schedule, now);
            validateStartCalendar.setTime(validateStartTime);
            return validateStartCalendar;
        }
        validateStartCalendar.setTime(startDate);
        return validateStartCalendar;
    }

    private String getCronExpression(ISchedule schedule) {
        StringBuffer strBuf = new StringBuffer();
        this.constructCronHourMinSeconds(strBuf, schedule);
        switch (schedule.getPeriodType()) {
            case 3: {
                strBuf.append("? * ");
                strBuf.append(schedule.getDaysOfWeek());
                break;
            }
            case 4: {
                strBuf.append(schedule.getDaysOfMonth());
                strBuf.append(" * ?");
                break;
            }
            case 2: {
                strBuf.append("* * ?");
                break;
            }
            default: {
                logger.error((Object)"Invalid schedule period type, period type: %s", new Object[]{String.valueOf(schedule.getPeriodType())});
                throw new LegoCheckedException(-1L);
            }
        }
        return strBuf.toString();
    }

    private void constructCronHourMinSeconds(StringBuffer strBuf, ISchedule schedule) {
        String hours = schedule.getHours();
        String minutes = schedule.getMinutes();
        String seconds = schedule.getSeconds();
        logger.debug((Object)"ConstructCronHourMinSeconds, hours:%s, minutes:%s, seconds:%s", new Object[]{hours, minutes, seconds});
        this.linkTimeStr(strBuf, seconds);
        this.linkTimeStr(strBuf, minutes);
        this.linkTimeStr(strBuf, hours);
    }

    private void linkTimeStr(StringBuffer strBuf, String time) {
        logger.debug((Object)"LinkTimeStr");
        if (VerifyUtil.isEmpty((String)time)) {
            strBuf.append('0');
        } else {
            strBuf.append(time);
        }
        strBuf.append(' ');
    }

    private AbstractTrigger createCronTrigger(ITask task) {
        String triggerName = this.getTriggerName(task);
        String triggerGroupName = this.getTriggerGroupName(task);
        String jobName = this.getJobName(task);
        String jobGroupName = this.getJobGroupName(task);
        ISchedule schedule = task.getSchedule();
        Date validateDateStartTime = this.getValidateDateStartTimeForCronTrigger(schedule);
        String endTimeStr = schedule.getEndTime();
        CronTriggerImpl quartzCronTrigger = null;
        try {
            quartzCronTrigger = new CronTriggerImpl(triggerName, triggerGroupName, jobName, jobGroupName, validateDateStartTime, endTimeStr == null ? null : new Date(NumberUtil.convertToLong((Object)endTimeStr)), this.getCronExpression(schedule));
        }
        catch (ParseException e) {
            logger.error((Object)"Parse crontab expression failed, error: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
        return quartzCronTrigger;
    }

    private Date getValidateDateStartTimeForCronTrigger(ISchedule schedule) {
        String startTimeStr = schedule.getStartTime();
        if (VerifyUtil.isEmpty((String)startTimeStr)) {
            logger.error((Object)"StartTimeStr is empty!schedule Id: %s ", new Object[]{schedule.getScheduleId()});
            throw new LegoCheckedException(-1L);
        }
        Date startDate = new Date(NumberUtil.convertToLong((Object)startTimeStr));
        return startDate;
    }

    private AbstractTrigger createTrigger(ITask task) {
        AbstractTrigger quartzTrigger;
        ISchedule schedule = task.getSchedule();
        if (0 == schedule.getPeriodType() || 1 == schedule.getPeriodType() || 6 == schedule.getPeriodType()) {
            quartzTrigger = this.createSimpleTrigger(task);
        } else if (2 == schedule.getPeriodType()) {
            quartzTrigger = this.createDayTrigger(task);
        } else if (3 == schedule.getPeriodType() || 4 == schedule.getPeriodType()) {
            quartzTrigger = this.createCronTrigger(task);
        } else {
            logger.error((Object)"Invalid schedule period type, period type: %s", new Object[]{String.valueOf(task.getSchedule().getPeriodType())});
            throw new LegoCheckedException(-1L);
        }
        try {
            this.quartzScheduler.getListenerManager().addTriggerListener((TriggerListener)new ProtectionQuartzTriggerListener());
        }
        catch (SchedulerException e) {
            logger.error((Object)"QuartzScheduler get listener manager got error!", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        }
        return quartzTrigger;
    }

    private AbstractTrigger createDayTrigger(ITask task) {
        ISchedule schedule = task.getSchedule();
        int periodInterval = schedule.getPeriodInterval();
        if (periodInterval == 1) {
            return this.createCronTrigger(task);
        }
        if (periodInterval > 1) {
            return this.createSimpleTrigger(task);
        }
        logger.error((Object)"CreateDayTrigger failed! schedule ID: %s", new Object[]{task.getSchedule().getScheduleId()});
        throw new LegoCheckedException(-1L);
    }

    @Override
    public synchronized void schedule(ITask task) {
        this.checkParam(task);
        String jobName = this.getJobName(task);
        String jobGroupName = this.getJobGroupName(task);
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.put("TASK", (Object)task);
        JobKey jobKey = new JobKey(jobName, jobGroupName);
        try {
            String triggerGroupName;
            String triggerName;
            TriggerKey triggerKey;
            AbstractTrigger trigger;
            JobDetail quartzJobDetail = this.quartzScheduler.getJobDetail(jobKey);
            if (quartzJobDetail == null) {
                Class<? extends Job> jobClass = this.getJobClass(task.getJobClassName());
                quartzJobDetail = new JobDetailImpl(jobName, jobGroupName, jobClass);
                ((JobDetailImpl)quartzJobDetail).setDurability(true);
                logger.debug((Object)"Create new jobdetail, job class name=%s", new Object[]{jobName});
                this.quartzScheduler.addJob(quartzJobDetail, true);
            }
            if (!(trigger = this.createTrigger(task)).equals((Object)this.quartzScheduler.getTrigger(triggerKey = new TriggerKey(triggerName = this.getTriggerName(task), triggerGroupName = this.getTriggerGroupName(task))))) {
                trigger.setJobDataMap(jobDataMap);
                this.quartzScheduler.scheduleJob((Trigger)trigger);
                logger.debug((Object)"Add new cron trigger, trigger name=%s", new Object[]{trigger.getKey().getName()});
            }
        }
        catch (SchedulerException e) {
            logger.error((Object)"Schedule job failed, error: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
    }

    @Override
    public void unschedule(ITask task) {
        this.checkParam(task);
        String triggerName = this.getTriggerName(task);
        String triggerGroupName = this.getTriggerGroupName(task);
        TriggerKey triggerKey = new TriggerKey(triggerName, triggerGroupName);
        logger.debug((Object)"Unschedule task, trigger name=%s ,trigger group name=%s", new Object[]{triggerName, triggerGroupName});
        try {
            this.quartzScheduler.unscheduleJob(triggerKey);
        }
        catch (SchedulerException e) {
            logger.error((Object)"Unschedule job failed, error: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
    }

    @Override
    public void pause(ITask task) {
        this.checkParam(task);
        String triggerName = this.getTriggerName(task);
        String triggerGroupName = this.getTriggerGroupName(task);
        TriggerKey triggerKey = new TriggerKey(triggerName, triggerGroupName);
        try {
            this.quartzScheduler.pauseTrigger(triggerKey);
            if (this.isTriggerRunning(triggerName)) {
                logger.error((Object)"Trigger is running, can't pause it. trigger name= %s, trigger group name= %s", new Object[]{triggerName, triggerGroupName});
                this.quartzScheduler.resumeTrigger(triggerKey);
                throw new LegoCheckedException(-1L);
            }
        }
        catch (SchedulerException e) {
            logger.error((Object)"Pause trigger failed", (Throwable)e, 90160758784001L);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
    }

    @Override
    public void pauseGroup(String groupName) {
        this.checkParam(groupName);
        try {
            this.quartzScheduler.pauseJobs(GroupMatcher.jobGroupEquals((String)groupName));
            if (this.isGroupRunning(groupName)) {
                logger.error((Object)"Some jobs are running, can't pause the job group. job group name= %s", new Object[]{groupName});
                this.quartzScheduler.resumeJobs(GroupMatcher.jobGroupEquals((String)groupName));
                throw new LegoCheckedException(-1L);
            }
        }
        catch (SchedulerException e) {
            logger.error((Object)"Pause job group failed", (Throwable)e, 90160758784001L);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
    }

    @Override
    public void resume(ITask task) {
        this.checkParam(task);
        String triggerName = this.getTriggerName(task);
        String triggerGroupName = this.getTriggerGroupName(task);
        TriggerKey triggerKey = new TriggerKey(triggerName, triggerGroupName);
        try {
            Trigger trigger = this.quartzScheduler.getTrigger(triggerKey);
            JobDataMap quartzJobDataMap = trigger.getJobDataMap();
            BaseTask bufferedTask = (BaseTask)quartzJobDataMap.get((Object)"TASK");
            bufferedTask.setNextExecTime(task.getNextExecTime());
            this.quartzScheduler.resumeTrigger(triggerKey);
        }
        catch (SchedulerException e) {
            logger.error((Object)"Resume trigger failed, error: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
    }

    @Override
    public void resumeGroup(String groupName) {
        this.checkParam(groupName);
        try {
            this.quartzScheduler.resumeJobs(GroupMatcher.jobGroupEquals((String)groupName));
        }
        catch (SchedulerException e) {
            logger.error((Object)"Resume job group failed, error: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
    }

    @Override
    public void runAtOnce(ITask task) {
        block5: {
            this.checkParam(task);
            String triggerName = this.getTriggerName(task);
            String triggerGroupName = this.getTriggerGroupName(task);
            TriggerKey triggerKey = new TriggerKey(triggerName, triggerGroupName);
            String jobName = this.getManualJobName(task);
            String jobGroupName = this.getJobGroupName(task);
            JobKey jobKey = new JobKey(jobName, jobGroupName);
            Class<? extends Job> jobClass = this.getJobClass(task.getJobClassName());
            JobDetailImpl quartzJobDetail = new JobDetailImpl(jobName, jobGroupName, jobClass);
            quartzJobDetail.setDurability(true);
            JobDataMap jobDataMap = new JobDataMap();
            jobDataMap.put("TASK", (Object)task);
            try {
                SimpleTriggerImpl simpleTrigger = new SimpleTriggerImpl(triggerName, triggerGroupName);
                simpleTrigger.setJobDataMap(jobDataMap);
                JobDetail job = this.quartzScheduler.getJobDetail(jobKey);
                if (job == null) {
                    logger.info((Object)"First schedule job:%s", new Object[]{jobGroupName});
                    this.quartzScheduler.scheduleJob((JobDetail)quartzJobDetail, (Trigger)simpleTrigger);
                    break block5;
                }
                Trigger.TriggerState state = this.quartzScheduler.getTriggerState(triggerKey);
                if (state == null) {
                    logger.error((Object)"Schedule get trigger state is null.");
                    throw new LegoCheckedException(1073947393L);
                }
                String stateName = state.name();
                if (Trigger.TriggerState.PAUSED.name().equals(stateName) || Trigger.TriggerState.COMPLETE.name().equals(stateName) || Trigger.TriggerState.ERROR.name().equals(stateName) || Trigger.TriggerState.BLOCKED.name().equals(stateName) || Trigger.TriggerState.NONE.name().equals(stateName)) {
                    logger.info((Object)"Reschedule job is:%s QuartzScheduler state is:%s", new Object[]{jobGroupName, state.name()});
                    this.quartzScheduler.deleteJob(jobKey);
                    this.quartzScheduler.scheduleJob((JobDetail)quartzJobDetail, (Trigger)simpleTrigger);
                    state = this.quartzScheduler.getTriggerState(triggerKey);
                    logger.info((Object)"Rescheduled job is:%s QuartzScheduler state is: %s", new Object[]{jobGroupName, state.name()});
                    break block5;
                }
                logger.error((Object)"QuartzScheduler state is: %s", new Object[]{state});
                throw new LegoCheckedException(1073948200L);
            }
            catch (SchedulerException e) {
                logger.error((Object)"Schedule volatile trigger failed, error: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
                throw new LegoCheckedException(-1L, (Throwable)e);
            }
        }
    }

    @Override
    public boolean isExistTrigger(ITask task) {
        this.checkParam(task);
        String triggerName = this.getTriggerName(task);
        String triggerGroupName = this.getTriggerGroupName(task);
        TriggerKey triggerKey = new TriggerKey(triggerName, triggerGroupName);
        try {
            Trigger trigger = this.quartzScheduler.getTrigger(triggerKey);
            return !VerifyUtil.isEmpty((Object)trigger);
        }
        catch (SchedulerException e) {
            logger.error((Object)"Get trigger failed, error: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
    }

    @Override
    public void updateTrigger(ITask task) {
        this.checkParam(task);
        String triggerName = this.getTriggerName(task);
        String triggerGroupName = this.getTriggerGroupName(task);
        TriggerKey triggerKey = new TriggerKey(triggerName, triggerGroupName);
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.put("TASK", (Object)task);
        AbstractTrigger newTrigger = this.createTrigger(task);
        newTrigger.setJobDataMap(jobDataMap);
        try {
            Trigger trigger = this.quartzScheduler.getTrigger(triggerKey);
            if (trigger == null) {
                logger.debug((Object)"UpdateTrigger the Trigger is null, recreate.");
                String jobName = this.getJobName(task);
                String jobGroupName = this.getJobGroupName(task);
                JobKey jobKey = new JobKey(jobName, jobGroupName);
                JobDetail quartzJobDetail = this.quartzScheduler.getJobDetail(jobKey);
                if (quartzJobDetail == null) {
                    Class<? extends Job> jobClass = this.getJobClass(task.getJobClassName());
                    quartzJobDetail = new JobDetailImpl(jobName, jobGroupName, jobClass);
                    ((JobDetailImpl)quartzJobDetail).setDurability(true);
                    logger.debug((Object)"UpdateTrigger create new jobdetail, job class name=%s", new Object[]{jobName});
                    this.quartzScheduler.addJob(quartzJobDetail, true);
                }
                this.quartzScheduler.scheduleJob((Trigger)newTrigger);
            } else {
                this.quartzScheduler.rescheduleJob(triggerKey, (Trigger)newTrigger);
            }
        }
        catch (SchedulerException e) {
            logger.error((Object)"Update trigger failed", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
    }

    @Override
    public String getGroupName(String protectPolicyId) {
        if (protectPolicyId == null) {
            logger.error((Object)"Invalid parameter");
            throw new LegoCheckedException(1073947393L);
        }
        return "JOB_GROUP_" + protectPolicyId;
    }

    @Override
    public Date getNextExecTime(ITask task, boolean isNewTrigger) {
        this.checkParam(task);
        Date nextExecTime = null;
        String triggerName = this.getTriggerName(task);
        String triggerGroupName = this.getTriggerGroupName(task);
        TriggerKey triggerKey = new TriggerKey(triggerName, triggerGroupName);
        Date curr = new Date();
        if (!ProtectionJobUtil.getInstance().isTimeInRange(task.getSchedule(), curr)) {
            return ProtectionJobUtil.getInstance().getNextExeTimeWhenOutOfTimeRange(task.getSchedule(), curr);
        }
        if (isNewTrigger) {
            AbstractTrigger trigger = this.createTrigger(task);
            nextExecTime = trigger.getFireTimeAfter(curr);
        } else {
            Trigger trigger;
            try {
                trigger = this.quartzScheduler.getTrigger(triggerKey);
            }
            catch (SchedulerException e) {
                logger.error((Object)"Get trigger failed, error: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
                throw new LegoCheckedException(-1L, (Throwable)e);
            }
            if (trigger != null) {
                nextExecTime = trigger.getFireTimeAfter(curr);
            }
        }
        return nextExecTime;
    }

    private void checkParam(Object param) {
        if (param == null) {
            logger.error((Object)"Invalid parameter.");
            throw new LegoCheckedException(1073947393L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readProperties() {
        InputStream inputStream = null;
        try {
            ClassLoader classLoader = AdapterUtils.getClassLoader(this.getClass());
            if (classLoader == null) {
                logger.error((Object)"Read default.properties fail.");
                return;
            }
            Enumeration<URL> enums = classLoader.getResources(DEFAULT_PROPERTIES);
            while (enums != null && enums.hasMoreElements()) {
                URL url = enums.nextElement();
                inputStream = url.openStream();
            }
            if (inputStream != null) {
                this.props.load(inputStream);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Read default.properties fail.");
        }
        finally {
            this.closeInputStream(inputStream);
        }
    }

    private void closeInputStream(InputStream inputStream) {
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (Exception e) {
            logger.error((Object)"Closing input stream failed. error: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        }
    }

    @Override
    public Scheduler getquartzScheduler() {
        logger.debug((Object)"GetquartzScheduler");
        return this.quartzScheduler;
    }

    @Override
    public void deleteJob(ITask task) {
        this.checkParam(task);
        String jobName = this.getJobName(task);
        String jobGroupName = this.getJobGroupName(task);
        JobKey jobKey = new JobKey(jobName, jobGroupName);
        logger.debug((Object)"Delete job, trigger name=%s ,trigger group name=%s", new Object[]{jobName, jobGroupName});
        try {
            this.quartzScheduler.deleteJob(jobKey);
        }
        catch (SchedulerException e) {
            logger.error((Object)"Delete job failed, error: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
    }

    @Override
    public void resetNextExecuteTime(ITask task, Date startTime) {
        ISchedule schedule = task.getSchedule();
        String triggerName = this.getTriggerName(task);
        String triggerGroupName = this.getTriggerGroupName(task);
        TriggerKey triggerKey = new TriggerKey(triggerName, triggerGroupName);
        try {
            Trigger trigger = this.quartzScheduler.getTrigger(triggerKey);
            ProtectionJobUtil.getInstance().resetNextExecuteTime(schedule, startTime, this.quartzScheduler, trigger);
        }
        catch (SchedulerException e) {
            logger.error((Object)"ResetNextExecuteTime trigger failed, error: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
    }
}

