/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.cert;

import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.cert.SystemCertificateService;
import com.huawei.ism.drm.cert.sdk.service.ICertificateService;
import com.huawei.ism.drm.cert.sdk.service.ISystemCertificateService;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.LegoBaseConfig;
import com.huawei.lego.core.sdk.util.PathUtil;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.nio.file.Path;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class ServerCertificateValidateJob
implements Job {
    public static final String CERTIFICATE = "certificate";
    private static final Log logger = LogFactory.getInstance(ServerCertificateValidateJob.class);

    public void execute(JobExecutionContext context) throws JobExecutionException {
        logger.info((Object)"ServerCertificateValidateJob execute.");
        JobDataMap data = context.getMergedJobDataMap();
        SystemCertificateService service = (SystemCertificateService)data.get((Object)SystemCertificateService.class.getName());
        Object certificate = data.get((Object)CERTIFICATE);
        this.validate((ISystemCertificateService)service, certificate);
    }

    public void validate(ISystemCertificateService service, Object certificate) {
        if (certificate == null) {
            logger.info((Object)"validate all component.");
            this.validate(service);
        } else {
            logger.info((Object)"validate component: %s", new Object[]{certificate});
            this.validate(service, certificate.toString());
        }
    }

    private void validate(ISystemCertificateService service) {
        logger.info((Object)"validate all certificates of components.");
        Path path = SystemCertificateService.getComponentCertificatePath();
        if (path == null) {
            logger.error((Object)"cert path of component is null.");
            return;
        }
        CertificateFactory factory = this.createCertificateFactory();
        if (factory == null) {
            logger.error((Object)"create certificate factory failed");
            return;
        }
        service.getAllRegisterableCertificates().stream().filter(summary -> "server".equals(summary.getType())).forEach(summary -> this.validate(service, summary.getCertName(), factory, path.resolve(summary.getComponentName() + ".cert").toFile()));
    }

    private void validate(ISystemCertificateService service, String certName) {
        String base = PathUtil.getLegoRuntimePath();
        if (base == null) {
            logger.info((Object)"not found LegoRuntime path.");
            return;
        }
        CertificateFactory factory = this.createCertificateFactory();
        Path path = SystemCertificateService.getComponentCertificatePath();
        service.getAllRegisterableCertificates().stream().filter(item -> certName.equals(item.getCertName())).findFirst().ifPresent(summary -> this.validate(service, summary.getCertName(), factory, path.resolve(summary.getComponentName() + ".cert").toFile()));
    }

    private CertificateFactory createCertificateFactory() {
        try {
            return CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            logger.info((Object)"initialize certificate factory failed.");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private X509Certificate generateCertificate(CertificateFactory certificatefactory, File file) {
        X509Certificate cert;
        FileInputStream input;
        try {
            input = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            logger.error((Object)"not found cert file:%s.", new Object[]{file.getName()});
            return null;
        }
        try {
            cert = (X509Certificate)certificatefactory.generateCertificate(input);
        }
        catch (CertificateException e) {
            logger.error((Object)"not valid cert file: %s.", new Object[]{file.getName()});
            X509Certificate x509Certificate = null;
            return x509Certificate;
        }
        finally {
            CommonUtil.close((Closeable)input);
        }
        return cert;
    }

    private void validate(ISystemCertificateService service, String certName, CertificateFactory certificatefactory, File file) {
        logger.info((Object)"validate certificate: %s.", new Object[]{certName});
        ICertificateService componentCertificateService = service.getCertificateServiceByCertName(certName);
        if (componentCertificateService == null || !file.exists()) {
            logger.info((Object)"not supported certificate: %s.", new Object[]{certName});
            return;
        }
        X509Certificate cert = this.generateCertificate(certificatefactory, file);
        if (cert == null) {
            logger.error((Object)"generate certificate failed for %s.", new Object[]{certName});
            return;
        }
        String[] alarmParams = new String[2];
        alarmParams[1] = certName;
        if (this.hasBeExpired(cert, alarmParams)) {
            return;
        }
        logger.info((Object)"clean COMPONENT_CERTIFICATE_HAS_EXPIRED alarm.");
        AlarmReporter.restoreAlarm(52625501L, certName);
        if (this.isWillExpire(cert, alarmParams)) {
            return;
        }
        logger.info((Object)"clean COMPONENT_CERTIFICATE_WILL_BE_EXPIRED alarm.");
        AlarmReporter.restoreAlarm(52625500L, certName);
    }

    private boolean isWillExpire(X509Certificate cert, String[] alarmParams) {
        LegoBaseConfig config = LegoBaseConfig.getInstance();
        long fwt = config.getNumber("alarm.cert.fwt", 30L);
        long swt = config.getNumber("alarm.cert.swt", 7L);
        long beforeDay = this.getNumberOfDays(new Date(), cert.getNotAfter());
        alarmParams[0] = String.valueOf(beforeDay);
        if (beforeDay <= swt) {
            AlarmReporter.sendAlarmForNoRepeat(52625500L, alarmParams[1], FaultEnum.AlarmResourceType.NETWORKENTITY.getValue(), FaultEnum.AlarmSeverity.CRITICAL, alarmParams);
            logger.error((Object)"send certificate validity alarm.");
            return true;
        }
        if (beforeDay <= fwt) {
            AlarmReporter.sendAlarmForNoRepeat(52625500L, alarmParams[1], FaultEnum.AlarmResourceType.NETWORKENTITY.getValue(), FaultEnum.AlarmSeverity.MAJOR, alarmParams);
            logger.error((Object)"send certificate validity alarm.");
            return true;
        }
        return false;
    }

    private boolean hasBeExpired(X509Certificate cert, String[] alarmParams) {
        try {
            cert.checkValidity();
        }
        catch (CertificateException e) {
            logger.error((Object)"send certificate validity alarm.");
            long afterDay = this.getNumberOfDays(cert.getNotAfter(), new Date());
            alarmParams[0] = String.valueOf(afterDay);
            AlarmReporter.sendAlarmForNoRepeat(52625501L, alarmParams[1], FaultEnum.AlarmResourceType.NETWORKENTITY.getValue(), FaultEnum.AlarmSeverity.CRITICAL, alarmParams);
            return true;
        }
        return false;
    }

    private long getNumberOfDays(Date start, Date end) {
        long diff = end.getTime() - start.getTime();
        long days = diff / 86400000L;
        return diff % 86400000L > 0L ? days + 1L : days;
    }
}

