/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.checker.task;

import com.huawei.ism.drm.protection.checker.sdk.service.IProtectionChecker;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;

public class ProtectionCheckerCallable
implements Callable<Map<String, Object>> {
    private static final Log logger = LogFactory.getInstance(ProtectionCheckerCallable.class);
    private ProtectGroup protectGroup;
    private List<IProtectionChecker> protectionCheckers;
    private CountDownLatch doneSignal;

    public ProtectionCheckerCallable(ProtectGroup protectGroup, List<IProtectionChecker> protectionCheckers, CountDownLatch doneSignal) {
        this.protectGroup = protectGroup;
        this.protectionCheckers = protectionCheckers;
        this.doneSignal = doneSignal;
    }

    @Override
    public Map<String, Object> call() {
        try {
            Map<String, Object> allCheckResults = this.executeProtectionChecker();
            ProtectGroupUtil.saveRPOAndRTOResult(this.protectGroup, allCheckResults);
        }
        catch (Exception e) {
            logger.error((Object)"Executing failed. error: %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        }
        finally {
            this.doneSignal.countDown();
        }
        return new HashMap<String, Object>();
    }

    private Map<String, Object> executeProtectionChecker() {
        HashMap<String, Object> allCheckResults = new HashMap<String, Object>();
        for (IProtectionChecker protectionChecker : this.protectionCheckers) {
            try {
                Map results = protectionChecker.check(this.protectGroup);
                allCheckResults.putAll(results);
            }
            catch (Exception e) {
                logger.error((Object)"Execute checking failed. Checker: pgNama: %s, error: %s.", new Object[]{protectionChecker.getName(), ExceptionUtil.getErrorMessage((Throwable)e)});
            }
        }
        return allCheckResults;
    }
}

