/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.engine.util;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.AirGapLinkPortUtil;
import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.action.model.ActionContext;
import com.huawei.ism.drm.protection.framework.engine.bean.AlarmParameter;
import com.huawei.ism.drm.protection.framework.service.group.IProtectionRemoteService;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroupLogDetail;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupBaseService;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.service.IReplicaBaseService;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.schedule.sdk.model.ScheduleRangeTime;
import com.huawei.ism.drm.protection.task.sdk.model.ProtectionTask;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.protection.template.sdk.model.SiteInfo;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteBaseService;
import com.huawei.ism.drm.storage.sdk.model.ResourceTimeWindowRange;
import com.huawei.ism.drm.storage.sdk.model.StorageLinkPort;
import com.huawei.ism.drm.task.sdk.model.ISchedule;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.base.ServiceContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.LegoBaseConfig;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.impl.triggers.AbstractTrigger;

public final class ProtectionJobUtil {
    public static final String PROTECTION_QUARTZ_TRIGGER_LISTENER = "ProtectionQuartzTriggerListener";
    public static final String PROTECTION_HYPERVAULT_JOBID = "HyperVaultJobId";
    private static final Log logger = LogFactory.getInstance(ProtectionJobUtil.class);
    private static final List<Integer> ASYN_REPLICATION_TEMPLATE_TYPES = Arrays.asList(1, 3, 4, 5, 6, 17, 18, 20, 22, 28, 30, 31, 32, 33, 39, 35, 36, 58, 59, 40, 41, 42, 43, 44, 48, 45, 46, 47);
    private static final List<Integer> CHECK_HYPERMETRO_MASTER_LUN = Arrays.asList(19, 18, 28, 31, 26);
    private static final long MAX_TIME_OUT = LegoBaseConfig.getInstance().getNumber("array.sync.monitor.timeout", 43200L) * 1000L;
    private static Set<String> moKeySet = new HashSet<String>();
    private static ProtectionJobUtil jobUtil = new ProtectionJobUtil();

    private ProtectionJobUtil() {
    }

    public static ProtectionJobUtil getInstance() {
        return jobUtil;
    }

    public synchronized boolean getLockPg(String pgId) {
        if (moKeySet.contains(pgId)) {
            logger.debug((Object)"get lock failed!,pgId:%s", new Object[]{pgId});
            return false;
        }
        logger.info((Object)"get lock success!,pgId:%s", new Object[]{pgId});
        moKeySet.add(pgId);
        return true;
    }

    public boolean isPgLocked(String pgId) {
        return moKeySet.contains(pgId);
    }

    public boolean getLockPg(String pgId, long time, String flagName) {
        boolean lockFlag = false;
        long startTime = System.currentTimeMillis();
        logger.info((Object)"begin to try get lock.  flagName %s", new Object[]{flagName});
        while (!lockFlag) {
            long curTime = System.currentTimeMillis();
            if (time <= curTime - startTime) {
                logger.error((Object)"get lock with protectgroup time out. pgId: %s, flagName: %s.", new Object[]{pgId, flagName});
                return lockFlag;
            }
            CommUtil.pauseThread((long)1000L);
            lockFlag = this.getLockPg(pgId);
        }
        return lockFlag;
    }

    public boolean getLockPg(String pgId, long time) {
        return this.getLockPg(pgId, time, "");
    }

    public synchronized void releaseLockPg(String pgId) {
        if (moKeySet.contains(pgId)) {
            logger.info((Object)"release lock success!,pgId:%s", new Object[]{pgId});
            moKeySet.remove(pgId);
        }
    }

    public void genetateAlarm(AlarmParameter param) {
        logger.debug((Object)"genetateAlarm %s", new Object[]{param.getGroupName()});
        AlarmReporter.generatePolicyUnknowErrorAlarm(param.getPgId(), param.getGroupName());
    }

    public String getSiteName(String siteId) {
        String result = "";
        if (VerifyUtil.isEmpty((String)siteId)) {
            return result;
        }
        try {
            Site site = ((ISiteBaseService)ServiceLocator.getInstance().getService(ISiteBaseService.class)).getSiteById(siteId);
            if (null != site) {
                result = site.getName();
            }
        }
        catch (Exception e) {
            logger.error((Object)"get Sitename error, siteId: %s, error: %s.", new Object[]{siteId, ExceptionUtil.getErrorMessage((Throwable)e)});
        }
        return result;
    }

    public String getResourceName(String arraySN) {
        String result = "";
        if (VerifyUtil.isEmpty((String)arraySN)) {
            return result;
        }
        try {
            DrResource resource = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(arraySN);
            if (resource != null) {
                result = resource.getName();
            }
        }
        catch (Exception e) {
            logger.error((Object)"get arrayname error: %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        }
        return result;
    }

    public IProtectGroupBaseService getProtectGroupService() {
        IProtectGroupBaseService protectGroupService = null;
        for (int i = 0; i < 100; ++i) {
            try {
                IProtectGroupBaseService pgService;
                protectGroupService = pgService = (IProtectGroupBaseService)ServiceContext.getInstance().lookup("DRM_Base/com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService");
                break;
            }
            catch (Exception e) {
                logger.error((Object)"get protection group service failed, error: %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
                continue;
            }
        }
        return protectGroupService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void updateProtectGroupStartStatus(ProtectGroup pg) {
        Session session;
        block7: {
            if (VerifyUtil.isEmpty((String)pg.getUuid())) {
                logger.debug((Object)"pd ID is empty,not update ProtectGroup startStatus");
                return;
            }
            session = null;
            try {
                session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
                String sql = "UPDATE ti_protectgroup SET STATUS=:status, LASTEXECTIME=:lastExecTime WHERE PGID=:pgid";
                session.beginTransaction();
                long lastExecTime = pg.getLastExecTime() == null ? new Date().getTime() : pg.getLastExecTime().longValue();
                NativeQuery query = session.createSQLQuery(sql);
                query.setInteger("status", pg.getStatus());
                query.setLong("lastExecTime", lastExecTime);
                query.setString("pgid", pg.getUuid());
                int updateResult = query.executeUpdate();
                session.getTransaction().commit();
                if (1 == updateResult) break block7;
                logger.error((Object)"updatePrtectGroupStartStatus failed!");
                throw new LegoCheckedException(-1L);
            }
            catch (LegoCheckedException e) {
                DBOperationUtil.rollbackSession(session);
                ExceptionUtil.rethrowException((Throwable)e, (String)"Update protectGroup basic info failed!", (long)e.getErrorCode(), (String[])e.getParameters(), (Log)logger);
                DBOperationUtil.closeSession(session);
            }
            catch (Exception ex) {
                DBOperationUtil.rollbackSession(session);
                ExceptionUtil.rethrowException((Throwable)ex, (String)"updateProtectGroupEndStatus failed!", (long)-1L, (String[])new String[0], (Log)logger);
                {
                    catch (Throwable throwable) {
                        DBOperationUtil.closeSession(session);
                        throw throwable;
                    }
                }
                DBOperationUtil.closeSession(session);
            }
        }
        DBOperationUtil.closeSession(session);
        IProtectionRemoteService protectionRemoteService = (IProtectionRemoteService)ServiceLocator.getInstance().getService(IProtectionRemoteService.class);
        protectionRemoteService.syncProtectGroup(pg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void updateProtectGroupEndStatus(ProtectGroup pg) {
        Session session;
        block7: {
            if (VerifyUtil.isEmpty((String)pg.getUuid())) {
                logger.debug((Object)"pd ID is empty,not update ProtectGroup EndStatus");
                return;
            }
            session = null;
            try {
                session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
                String sql = "UPDATE ti_protectgroup SET STATUS=:status, PG_REPLICA_INDEX=:index, LASTEXECTIME=:lastExecTime, LAST_EXEC_RESULT=:lastExecResult, LAST_EXEC_ERROR_RESULT=:lastExecErrorDetail, LAST_EXEC_PARAM=:lastExecParam where PGID=:pgid";
                session.beginTransaction();
                NativeQuery query = session.createSQLQuery(sql);
                query.setInteger("status", pg.getStatus());
                query.setInteger("index", pg.getPgReplicaIndex());
                query.setBigDecimal("lastExecTime", (BigDecimal)Optional.ofNullable(pg.getLastExecTime()).map(BigDecimal::new).orElse(null));
                query.setBigDecimal("lastExecResult", (BigDecimal)Optional.ofNullable(pg.getLastExecResult()).map(BigDecimal::new).orElse(null));
                query.setParameter("lastExecErrorDetail", (Object)pg.getLastExecErrorDetail());
                query.setParameter("lastExecParam", (Object)pg.getLastExecParam());
                query.setString("pgid", pg.getUuid());
                int updateResult = query.executeUpdate();
                session.getTransaction().commit();
                if (1 == updateResult) break block7;
                logger.error((Object)"updateProtectGroupEndStatus failed.");
                throw new LegoCheckedException(-1L);
            }
            catch (LegoCheckedException e) {
                DBOperationUtil.rollbackSession(session);
                ExceptionUtil.rethrowException((Throwable)e, (String)"Update protectGroup basic info failed!", (long)e.getErrorCode(), (String[])e.getParameters(), (Log)logger);
                DBOperationUtil.closeSession(session);
            }
            catch (Exception ex) {
                DBOperationUtil.rollbackSession(session);
                ExceptionUtil.rethrowException((Throwable)ex, (String)"updateProtectGroupEndStatus failed!", (long)-1L, (String[])new String[0], (Log)logger);
                {
                    catch (Throwable throwable) {
                        DBOperationUtil.closeSession(session);
                        throw throwable;
                    }
                }
                DBOperationUtil.closeSession(session);
            }
        }
        DBOperationUtil.closeSession(session);
        IProtectionRemoteService protectionRemoteService = (IProtectionRemoteService)ServiceLocator.getInstance().getService(IProtectionRemoteService.class);
        protectionRemoteService.syncProtectGroup(pg);
    }

    public void updatePrtectGroupReplicaStatus(ProtectGroupReplica pgReplica) {
        if (VerifyUtil.isEmpty((Object)pgReplica)) {
            return;
        }
        ProtectGroupReplica replica = (ProtectGroupReplica)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(ProtectGroupReplica.class, (Serializable)((Object)pgReplica.getId()));
        if (null != replica) {
            replica.setStatus(pgReplica.getStatus());
            replica.setTimeStamp(pgReplica.getTimeStamp());
            ((IReplicaBaseService)ServiceLocator.getInstance().getService(IReplicaBaseService.class)).updateProtectGroupReplica(replica);
            return;
        }
        logger.error((Object)"replica is not existed! pgReplicaId: %s.", new Object[]{pgReplica.getId()});
    }

    public boolean isTimeAvailable(ProtectionTask task) {
        if (VerifyUtil.isEmpty((Object)task)) {
            return false;
        }
        if (null != task.getNextExecTime() && new Date(NumberUtil.convertToLong((Object)task.getNextExecTime())).after(new Date())) {
            logger.debug((Object)"no need to execute, next exec time=%s", new Object[]{task.getNextExecTime()});
            return false;
        }
        return true;
    }

    public boolean isTimeInRange(ISchedule schedule, Date execStartTime) {
        Set scheduleRanges = schedule.getScheduleRanges();
        if (VerifyUtil.isEmpty((Collection)scheduleRanges)) {
            logger.debug((Object)"schedule Ranges not set.");
            return true;
        }
        for (ScheduleRangeTime us : scheduleRanges) {
            logger.debug((Object)"Schedule Range check: now time:%s undoStartTime:%s undoEndTime: undoEndTime:", new Object[]{Calendar.getInstance().getTime(), us.getStartTime(), us.getEndTime()});
            if (!this.isInRangeTime(us, execStartTime)) continue;
            logger.debug((Object)"Schedule Range check is in range.");
            return true;
        }
        logger.warn((Object)"Schedule Range check has not in range. scheduleId: %s.", new Object[]{schedule.getScheduleId()});
        return false;
    }

    public boolean checkAirGapTimeRange(ProtectGroup protectGroup, Date execStartTime) {
        List<ResourceTimeWindowRange> rangeList = ProtectionJobUtil.getTimeRangesByPg(protectGroup);
        if (CollectionUtils.isEmpty(rangeList)) {
            logger.info((Object)"No time window can exec. pgName: %s", new Object[]{protectGroup.getName()});
            return true;
        }
        long execTime = execStartTime.getTime();
        Optional<ResourceTimeWindowRange> rangeOpt = ProtectionJobUtil.findSpecificTimeWindow(rangeList, execTime);
        logger.info((Object)"ExecTime: %s check time range result: %s", new Object[]{execTime, rangeOpt.isPresent()});
        return rangeOpt.isPresent();
    }

    public static List<ResourceTimeWindowRange> getTimeRangesByPg(ProtectGroup protectGroup) {
        if (!protectGroup.isAirGapType()) {
            logger.info((Object)"The site of the protectGroup{name:%s} is not a Air Gap resource.", new Object[]{protectGroup.getName()});
            return Collections.emptyList();
        }
        List<StorageLinkPort> linkPorts = AirGapLinkPortUtil.getAirGapPortList(protectGroup);
        Optional opt = linkPorts.stream().findAny();
        if (!opt.isPresent()) {
            logger.error((Object)"Not find StorageLinkPort by pgName: %s", new Object[]{protectGroup.getName()});
            throw new LegoCheckedException(1073947394L);
        }
        List<String> portIds = linkPorts.stream().map(StorageLinkPort::getPortId).collect(Collectors.toList());
        AirGapLinkPortUtil linkPortUtil = AirGapLinkPortUtil.getInstance();
        List<ResourceTimeWindowRange> rangeList = linkPortUtil.getTimeRangesByPgPortIds(portIds, ((StorageLinkPort)opt.get()).getDevSn());
        logger.info((Object)"Get Air Gap time window: %s", new Object[]{rangeList.toString()});
        return rangeList;
    }

    public static Optional<ResourceTimeWindowRange> findSpecificTimeWindow(List<ResourceTimeWindowRange> timeWindowRanges, long timeMills) {
        return timeWindowRanges.stream().filter(range -> timeMills >= range.getStartTime().getTime() && timeMills <= range.getEndTime().getTime()).findAny();
    }

    private boolean isInRangeTime(ScheduleRangeTime us, Date execStartTime) {
        logger.debug((Object)"isInRangeTime");
        Calendar calendar = Calendar.getInstance();
        Calendar tempNow = Calendar.getInstance();
        Calendar tempDatebase = Calendar.getInstance();
        tempNow.setTime(execStartTime);
        calendar.set(6, tempNow.get(6));
        calendar.set(11, tempNow.get(11));
        calendar.set(12, tempNow.get(12));
        calendar.set(13, 0);
        Date now = calendar.getTime();
        tempDatebase.setTime(us.getStartTime());
        calendar.set(6, tempNow.get(6));
        calendar.set(11, tempDatebase.get(11));
        calendar.set(12, tempDatebase.get(12));
        calendar.set(13, 0);
        Date start = calendar.getTime();
        tempDatebase.setTime(us.getEndTime());
        if (tempDatebase.get(12) == 59) {
            calendar.set(6, tempNow.get(6) + 1);
            calendar.set(11, 0);
            calendar.set(12, 0);
        } else {
            calendar.set(6, tempNow.get(6));
            calendar.set(11, tempDatebase.get(11));
            calendar.set(12, tempDatebase.get(12));
        }
        calendar.set(13, 0);
        Date end = calendar.getTime();
        return now.after(start) && now.before(end) || now.equals(start) || now.equals(end);
    }

    public boolean isStatusAvailable(ProtectGroup pg) {
        logger.debug((Object)"isStatusAvailable");
        int status = pg.getStatus();
        boolean isStatusAvailable = DrmEnumDefine.ProtectGroupStatus.NORMAL.getStatus() == status || DrmEnumDefine.ProtectGroupStatus.RUNNING.getStatus() == status;
        return isStatusAvailable;
    }

    public ProtectGroupLogDetail createActionLog(String detailId, String stepTitle, Date startTime) {
        logger.debug((Object)"createActionLog");
        ProtectGroupLogDetail historyDetailLog = new ProtectGroupLogDetail();
        if (VerifyUtil.isEmpty((String)detailId)) {
            historyDetailLog.setDetailId(UUIDGenerator.getUUID());
        } else {
            historyDetailLog.setDetailId(detailId);
        }
        historyDetailLog.setTitle(stepTitle);
        historyDetailLog.setStartTime(String.valueOf(startTime.getTime()));
        historyDetailLog.setInfo("--");
        historyDetailLog.setProtectionLogDetails(new HashSet());
        return historyDetailLog;
    }

    public void checkIsNeedLock(String pgId) {
        boolean lockFlag = false;
        long startTime = System.currentTimeMillis();
        logger.info((Object)"begin to try get lock. ", 90160758784001L);
        while (!lockFlag) {
            long curTime = System.currentTimeMillis();
            if (MAX_TIME_OUT <= curTime - startTime) {
                logger.error((Object)"get lock with protectgroup time out.");
                throw new LegoCheckedException(1073947433L);
            }
            CommUtil.pauseThread((long)1000L);
            lockFlag = this.getLockPg(pgId);
        }
    }

    public AlarmParameter createAlarm(ActionContext actionContext, ProtectGroup pg) {
        AlarmParameter alarmParam = new AlarmParameter();
        alarmParam.setPgId(pg.getUuid());
        alarmParam.setProtectSiteId(pg.getProductSiteId());
        alarmParam.setGroupName(pg.getName());
        logger.debug((Object)"createAlarm%s", new Object[]{pg.getName()});
        return alarmParam;
    }

    public boolean getFreezeFlag(String freezeFlag) {
        int flag = 1;
        if (VerifyUtil.isEmpty((String)freezeFlag)) {
            logger.error((Object)"freezeFlag for  protectGroup is null.");
        } else {
            try {
                flag = Integer.parseInt(freezeFlag);
            }
            catch (Exception e) {
                logger.error((Object)"freezeFlag for  protectGroup is null.");
            }
        }
        return flag != 0;
    }

    public static boolean checkWhetherTerminateTask(ActionContext context) {
        Object pgObj = context.getObject("PG_ENTITY");
        Object pgReplicaObj = context.getObject("PG_REPLICA_ENTITY");
        if (!(pgObj instanceof ProtectGroup)) {
            logger.error((Object)"protect group from context is null!");
            return false;
        }
        if (!(pgReplicaObj instanceof ProtectGroupReplica)) {
            logger.error((Object)"ProtectGroupReplica from context is null!");
            return false;
        }
        ProtectGroup protectGroup = (ProtectGroup)pgObj;
        ProtectGroupReplica pgReplica = (ProtectGroupReplica)pgReplicaObj;
        PolicyTemplate template = protectGroup.getTemplate();
        if (!ASYN_REPLICATION_TEMPLATE_TYPES.contains(template.getType())) {
            logger.debug((Object)"the template type [%s] is not allowed to teminate task.", new Object[]{String.valueOf(template.getType())});
            return false;
        }
        Schedule autoSchedule = ProtectionJobUtil.getAutoScheduleByProtectlocation(pgReplica, template);
        if (autoSchedule == null) {
            logger.debug((Object)"The autoSchedule is null, so will not to teminate task.");
            return false;
        }
        String abortTaskTime = autoSchedule.getAbortTaskTime();
        if (VerifyUtil.isEmpty((String)abortTaskTime) || autoSchedule.getPeriodType() != 2) {
            logger.debug((Object)"The abortTaskTime[%s] is null, or periodType[%s] is not the day type!, so will not to teminate task.", new Object[]{abortTaskTime, autoSchedule.getPeriodType()});
            return false;
        }
        if (ProtectionJobUtil.checkStartTime(autoSchedule)) {
            return false;
        }
        return ProtectionJobUtil.checkIsBeyongTheAbortTime(autoSchedule, abortTaskTime);
    }

    private static boolean checkStartTime(Schedule autoSchedule) {
        String hours = autoSchedule.getHours();
        if (VerifyUtil.isEmpty((String)hours)) {
            logger.debug((Object)"hours is null, so will not to teminate task!", 90160758784000L);
            return true;
        }
        String[] hourArray = hours.split(",");
        if (hourArray.length != 1) {
            logger.debug((Object)"hours[%s] size is not one, so will not to teminate task!", new Object[]{hours});
            return true;
        }
        return false;
    }

    private static boolean checkIsBeyongTheAbortTime(Schedule autoSchedule, String abortTaskTime) {
        String[] hourMinute = abortTaskTime.split(":");
        if (hourMinute.length != 2) {
            logger.error((Object)"abortTaskTime is not legal! abortTaskTime: %s.", new Object[]{abortTaskTime});
            return false;
        }
        Calendar nowCalendar = Calendar.getInstance();
        Calendar startTimeCalendar = Calendar.getInstance();
        Date now = new Date();
        nowCalendar.setTime(now);
        String hours = autoSchedule.getHours();
        String minutes = autoSchedule.getMinutes();
        startTimeCalendar.set(6, nowCalendar.get(6));
        startTimeCalendar.set(11, CommUtil.convertToInteger((Object)hours));
        startTimeCalendar.set(12, CommUtil.convertToInteger((Object)minutes));
        startTimeCalendar.set(13, 0);
        Calendar abortTaskTimeCalendar = Calendar.getInstance();
        String abortMinute = hourMinute[1];
        String abortHour = hourMinute[0];
        abortTaskTimeCalendar.set(6, nowCalendar.get(6));
        abortTaskTimeCalendar.set(11, CommUtil.convertToInteger((Object)abortHour));
        abortTaskTimeCalendar.set(12, CommUtil.convertToInteger((Object)abortMinute));
        abortTaskTimeCalendar.set(13, 0);
        Date startDate = startTimeCalendar.getTime();
        Date abortDate = abortTaskTimeCalendar.getTime();
        return startDate.before(abortDate) ? abortDate.before(now) || now.before(startDate) : abortDate.before(now) && now.before(startDate);
    }

    private static Schedule getAutoScheduleByProtectlocation(ProtectGroupReplica pgReplica, PolicyTemplate template) {
        logger.debug((Object)"getAutoScheduleByProtectlocation");
        Schedule autoSchedule = null;
        Set schedules = template.getSchedules();
        for (Schedule sch : schedules) {
            if (sch.getScheduleMode() != 0 || pgReplica.getProtectLocation() != sch.getProtectLocation()) continue;
            autoSchedule = sch;
            break;
        }
        return autoSchedule;
    }

    public void resetNextExecuteTime(ISchedule schedule, Date startTime, Scheduler quartzScheduler, Trigger quartzTrigger) {
        Date nextStartDate = this.getNextExeTimeWhenOutOfTimeRange(schedule, startTime);
        try {
            ((AbstractTrigger)quartzTrigger).setStartTime(nextStartDate);
            logger.info((Object)"reset next execution time successfully! Next execution time is %s", new Object[]{nextStartDate});
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"setStartTime error!", (long)1073948179L, null, (Log)logger);
        }
        try {
            quartzScheduler.rescheduleJob(new TriggerKey(quartzTrigger.getKey().getName(), quartzTrigger.getKey().getGroup()), quartzTrigger);
        }
        catch (SchedulerException e) {
            logger.error((Object)"rescheduleJob error!", (Throwable)e, 90160758784001L);
            throw new LegoCheckedException(1073948179L, (Throwable)e);
        }
        throw new LegoCheckedException(1073948179L);
    }

    public Date getNextExeTimeWhenOutOfTimeRange(ISchedule schedule, Date startTime) {
        logger.debug((Object)"getNextExeTimeWhenOutOfTimeRange");
        Set scheduleRanges = schedule.getScheduleRanges();
        Iterator iterator = scheduleRanges.iterator();
        ScheduleRangeTime scheduleRangeTime = (ScheduleRangeTime)iterator.next();
        Calendar nowCalendar = Calendar.getInstance();
        nowCalendar.setTime(startTime);
        nowCalendar.set(13, 0);
        Calendar startTimeCalendar = Calendar.getInstance();
        startTimeCalendar.setTime(scheduleRangeTime.getStartTime());
        Calendar startCalendar = Calendar.getInstance();
        startCalendar.setTime(startTime);
        startCalendar.set(11, startTimeCalendar.get(11));
        startCalendar.set(12, startTimeCalendar.get(12));
        startCalendar.set(13, 0);
        int size = scheduleRanges.size();
        Date nextStartDate = this.getTimeRangeStartDate(schedule, startTime);
        if (size == 1 && startCalendar.getTime().before(nowCalendar.getTime())) {
            Calendar newNextStartCalendar = Calendar.getInstance();
            newNextStartCalendar.setTime(nextStartDate);
            newNextStartCalendar.add(5, 1);
            nextStartDate = newNextStartCalendar.getTime();
        }
        return nextStartDate;
    }

    public Date getStartTimeInRangeTime(ISchedule schedule, Date startTime) {
        logger.debug((Object)"getStartTimeInRangeTime");
        Date timeRangeStartDate = this.getTimeRangeStartDate(schedule, startTime);
        Set scheduleRanges = schedule.getScheduleRanges();
        if (scheduleRanges.size() == 2 && startTime.before(timeRangeStartDate)) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(timeRangeStartDate);
            calendar.add(5, -1);
            return calendar.getTime();
        }
        return timeRangeStartDate;
    }

    private Date getTimeRangeStartDate(ISchedule schedule, Date startTime) {
        Date timeRangeStartDate = null;
        Set scheduleRanges = schedule.getScheduleRanges();
        int size = scheduleRanges.size();
        for (ScheduleRangeTime us : scheduleRanges) {
            Calendar nowCalendar = Calendar.getInstance();
            nowCalendar.setTime(startTime);
            Calendar endTimeCalendar = Calendar.getInstance();
            Calendar startTimeCalendar = Calendar.getInstance();
            Date endTime = us.getEndTime();
            Date stTime = us.getStartTime();
            endTimeCalendar.setTime(endTime);
            int min = endTimeCalendar.get(12);
            if ((min != 59 || size != 2) && size != 1) continue;
            startTimeCalendar.setTime(stTime);
            nowCalendar.set(11, startTimeCalendar.get(11));
            nowCalendar.set(12, startTimeCalendar.get(12));
            nowCalendar.set(13, 0);
            timeRangeStartDate = nowCalendar.getTime();
        }
        if (timeRangeStartDate == null) {
            logger.error((Object)"startDate is null.");
            throw new LegoCheckedException(1073948179L);
        }
        return timeRangeStartDate;
    }

    public void checkHyperMetro(ProtectGroup protectGroup, ActionContext context) {
        this.checkHyperMetro(protectGroup, context, (ProtectGroupReplica)context.getObject("PG_REPLICA_ENTITY"));
    }

    public void checkHyperMetro(ProtectGroup protectGroup, ActionContext context, ProtectGroupReplica pgReplica) {
        IProtectionRemoteService protectionRemoteService = (IProtectionRemoteService)ServiceLocator.getInstance().getService(IProtectionRemoteService.class);
        protectionRemoteService.checkHyperMetro(protectGroup, context, pgReplica);
    }

    public int getSyncTypeExecuteSync(Map<String, Object> parameter) {
        if (parameter == null) {
            return -1;
        }
        return (Integer)parameter.get("syncTypeAfterSync");
    }

    public static boolean isHyperMetroInFirstSite(ProtectGroup protectGroup) {
        List siteInfoList;
        if (protectGroup == null) {
            logger.error((Object)"Pg is null!", 90160758784001L);
            throw new LegoCheckedException(1073947394L);
        }
        String siteInfoListStr = (String)protectGroup.getProps().get("PROP_KEY_SITE_INFO");
        return siteInfoListStr != null && (siteInfoList = JSONArray.toCollection((JSONArray)JSONArray.fromObject((Object)siteInfoListStr), SiteInfo.class)).size() > 0 && ((SiteInfo)siteInfoList.get(0)).getSiteIdSet().size() >= 2;
    }
}

