/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.group;

import com.huawei.ism.drm.protection.framework.service.group.IProtectionRemoteService;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupHelper;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupBaseService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;

public class DeleteProtectObjectTransaction
implements TransactionCallback {
    private static final Log logger = LogFactory.getInstance(DeleteProtectObjectTransaction.class);
    private IProtectGroupBaseService service;
    private ProtectGroup protectGroup;

    public DeleteProtectObjectTransaction(IProtectGroupBaseService service, ProtectGroup protectGroup) {
        this.service = service;
        this.protectGroup = protectGroup;
    }

    public Object doInTransaction(TransactionStatus tstatus) {
        try {
            ProtectGroupHelper.getInstance().buildReplica(this.protectGroup);
            ((IProtectionRemoteService)ServiceLocator.getInstance().getService(IProtectionRemoteService.class)).syncProtectGroupToRemoteSite(this.protectGroup, "/ws/protectgroups/action/syncProtectGroupInfo");
            this.service.getBaseDao().update((Object)this.protectGroup);
        }
        catch (LegoCheckedException le) {
            tstatus.setRollbackOnly();
            ExceptionUtil.rethrowException((Throwable)le, (String)("Failed to delete protect object. " + this.protectGroup.getName()), (long)le.getErrorCode(), (String[])le.getParameters(), (Log)logger);
        }
        catch (Exception e) {
            tstatus.setRollbackOnly();
            ExceptionUtil.rethrowException((Throwable)e, (String)("Failed to delete protect object. " + this.protectGroup.getName()), (long)-1L, (String[])new String[0], (Log)logger);
        }
        return null;
    }
}

