/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.process;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.recovery.process.IRecoveryPreProcessor;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.HashMap;
import java.util.Map;

public class RecoveryPreProcessorManager {
    private static final Log logger = LogFactory.getInstance(RecoveryPreProcessorManager.class);
    private static RecoveryPreProcessorManager instance = new RecoveryPreProcessorManager();
    private Map<String, IRecoveryPreProcessor> preProcessors = new HashMap<String, IRecoveryPreProcessor>();

    private RecoveryPreProcessorManager() {
    }

    public static RecoveryPreProcessorManager getInstance() {
        return instance;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, Object> process(RecoveryPlan plan, DrmEnumDefine.RecoveryPlanExecuteTypeE execType) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        try {
            for (IRecoveryPreProcessor next : this.preProcessors.values()) {
                Map rst = next.process(plan, execType);
                logger.info((Object)"%s, %s", new Object[]{next, rst});
                if (rst == null) continue;
                results.putAll(rst);
            }
        }
        catch (LegoCheckedException ex) {
            try {
                logger.error((Object)"PreProcess failed, PreProcess results=%s,error=%s.", new Object[]{results, ExceptionUtil.getErrorMessage((Throwable)ex)});
                this.clean(plan, execType, results);
                throw ex;
                catch (Exception ex2) {
                    logger.error((Object)"PreProcess failed, PreProcess results=%s,error=%s.", new Object[]{results, ExceptionUtil.getErrorMessage((Throwable)ex2)});
                    this.clean(plan, execType, results);
                    throw new LegoCheckedException(1053L, (Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                logger.info((Object)"PreProcess results=%s", new Object[]{results});
                throw throwable;
            }
        }
        logger.info((Object)"PreProcess results=%s", new Object[]{results});
        return results;
    }

    private void clean(RecoveryPlan plan, DrmEnumDefine.RecoveryPlanExecuteTypeE execType, Map<String, Object> preProcessResults) {
        logger.info((Object)"start clean, planId=%s, execType=%s, results=%s", new Object[]{plan.getUuid(), execType, preProcessResults});
        for (IRecoveryPreProcessor next : this.preProcessors.values()) {
            try {
                logger.info((Object)"call processor=%s", new Object[]{next});
                next.clean(plan, execType, preProcessResults);
            }
            catch (Exception ex) {
                logger.error((Object)"clean failed,error=%s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
            }
            logger.info((Object)"step results=%s", new Object[]{preProcessResults});
        }
        logger.info((Object)"finish clean, results=%s", new Object[]{preProcessResults});
    }

    public void onBind(IRecoveryPreProcessor preProcessor, Map<?, ?> properties) {
        this.preProcessors.put(preProcessor.getClass().getName(), preProcessor);
    }

    public void onUnbind(IRecoveryPreProcessor preProcessor, Map<?, ?> properties) {
        this.preProcessors.remove(preProcessor.getClass().getName());
    }
}

