/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.provider;

import com.huawei.ism.cbb.base.util.BusinessUtil;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.service.ITaskManager;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.common.sdk.model.DRMObject;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanBaseService;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupUtil;
import com.huawei.ism.drm.protection.framework.template.manager.TemplateFilterManager;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.schedule.sdk.model.ScheduleProtectedType;
import com.huawei.ism.drm.protection.task.sdk.model.ProtectionTask;
import com.huawei.ism.drm.protection.task.sdk.service.IProtectionTaskService;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.protection.template.sdk.model.ProtectLocationPath;
import com.huawei.ism.drm.protection.template.sdk.service.IPolicyTemplateFilter;
import com.huawei.ism.drm.protection.template.sdk.service.IPolicyTemplateManager;
import com.huawei.ism.drm.recovery.process.IRefactorConfigurationBaseProvider;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public abstract class AbstractBaseRefactorConfigurationProvider
implements IRefactorConfigurationBaseProvider {
    private static final Log logger = LogFactory.getInstance(AbstractBaseRefactorConfigurationProvider.class);
    private static final Set<Integer> TEMPLATE3DC = new HashSet<Integer>();
    private static final Set<Integer> TEMPLATE3DC_EXCLUDE_RING = new HashSet<Integer>();
    private static final Set<Integer> TEMPLATE4DC = new HashSet<Integer>();
    protected static Map<Integer, Integer> mapTemplate = new HashMap<Integer, Integer>();
    private ThreadLocal<String> isReversed = new ThreadLocal();

    protected Boolean getIsReversed() {
        logger.debug((Object)"getIsReversed");
        if (this.isReversed != null && "true".equalsIgnoreCase(this.isReversed.get())) {
            return true;
        }
        return false;
    }

    protected void setIsReversed(String reversedValue) {
        if (this.isReversed == null) {
            logger.error((Object)"isReversed is null");
            return;
        }
        this.isReversed.set(reversedValue);
    }

    protected void updateDrRingScheduleProtectLocationPath(Map<Integer, ProtectLocationPath> locationMap, int policyTemplateType, Schedule schedule) {
        boolean flag = false;
        if (!VerifyUtil.isEmpty(locationMap) && locationMap.keySet().contains(DrmEnumDefine.ProtectLocation.C_C.getValue())) {
            flag = true;
        }
        if (flag && (schedule.getProtectLocation() == DrmEnumDefine.ProtectLocation.A_C.getValue() || schedule.getProtectLocation() == DrmEnumDefine.ProtectLocation.B_C.getValue())) {
            schedule.setProtectLocation(DrmEnumDefine.ProtectLocation.C_C.getValue());
        } else if (!(flag || policyTemplateType != 3 || schedule.getProtectLocation() != DrmEnumDefine.ProtectLocation.C_C.getValue() && schedule.getProtectLocation() != DrmEnumDefine.ProtectLocation.A_C.getValue())) {
            schedule.setProtectLocation(DrmEnumDefine.ProtectLocation.B_C.getValue());
        } else if (!(flag || policyTemplateType != 5 || schedule.getProtectLocation() != DrmEnumDefine.ProtectLocation.C_C.getValue() && schedule.getProtectLocation() != DrmEnumDefine.ProtectLocation.B_C.getValue())) {
            schedule.setProtectLocation(DrmEnumDefine.ProtectLocation.A_C.getValue());
        }
    }

    public void saveConfiguration(RecoveryPlan recoveryPlan) {
        IRecoveryPlanBaseService planService = (IRecoveryPlanBaseService)ServiceLocator.getInstance().getService(IRecoveryPlanBaseService.class);
        RecoveryPlan oldRecoveryPlan = planService.getRecoveryPlan(recoveryPlan.getPlanId());
        if (oldRecoveryPlan == null) {
            logger.error((Object)"The recovery plan does not exist. PlanName:%s.", new Object[]{recoveryPlan.getPlanId()});
            throw new LegoCheckedException(1073947394L);
        }
        String isReversedInGlobalSetting = (String)recoveryPlan.getGlobalSettings().get("isReserved");
        this.setIsReversed(isReversedInGlobalSetting);
        this.updateRecoveryPlan(oldRecoveryPlan, recoveryPlan);
        IProtectionTaskService protectionTaskService = (IProtectionTaskService)ServiceLocator.getInstance().getService(IProtectionTaskService.class);
        for (ProtectGroup oldProtectGroup : oldRecoveryPlan.getProtectGroups()) {
            CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)oldProtectGroup.getTemplate());
            CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)oldProtectGroup);
            protectionTaskService.createTask(oldProtectGroup);
            this.deleteProtectActions(oldProtectGroup.getUuid());
        }
        this.deleteRemovedRecoverySettings(oldRecoveryPlan.getRecoverySettings(), recoveryPlan.getRecoverySettings());
        this.updateRecoveryProcessDef(recoveryPlan);
        oldRecoveryPlan.getRecoverySettings().clear();
        oldRecoveryPlan.getRecoverySettings().addAll(recoveryPlan.getRecoverySettings());
        CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)oldRecoveryPlan);
    }

    protected abstract void updateRecoveryProcessDef(RecoveryPlan var1);

    protected void updateRecoveryPlan(RecoveryPlan recoveryPlanInDb, RecoveryPlan newRecoveryPlan) {
        recoveryPlanInDb.getGlobalSettings().clear();
        recoveryPlanInDb.getGlobalSettings().putAll(newRecoveryPlan.getGlobalSettings());
        Set oldProtectGroups = recoveryPlanInDb.getProtectGroups();
        Set newProtectGroups = newRecoveryPlan.getProtectGroups();
        for (ProtectGroup oldProtectGroup : oldProtectGroups) {
            DRMObject drmObject = this.getMatchedDrmObject(newProtectGroups, (DRMObject)oldProtectGroup);
            if (drmObject == null) {
                logger.debug((Object)"drmObject is null!");
                continue;
            }
            ProtectGroup newProtectGroup = (ProtectGroup)drmObject;
            this.updateProtectGroup(oldProtectGroup, newProtectGroup);
        }
    }

    protected void updateProtectGroup(ProtectGroup oldProtectGroup, ProtectGroup newProtectGroup) {
        oldProtectGroup.setProductSiteId(newProtectGroup.getProductSiteId());
        oldProtectGroup.setProductSiteName(newProtectGroup.getProductSiteName());
        oldProtectGroup.setStatus(newProtectGroup.getStatus());
        oldProtectGroup.setPrimary(newProtectGroup.isPrimary());
        oldProtectGroup.setPoProviderSN(newProtectGroup.getPoProviderSN());
        oldProtectGroup.setProps(this.updateExtendedProps(oldProtectGroup.getProps(), newProtectGroup.getProps()));
        PolicyTemplate oldTemplate = oldProtectGroup.getTemplate();
        PolicyTemplate newTemplate = newProtectGroup.getTemplate();
        oldTemplate.setType(newTemplate.getType());
        oldTemplate.setSketch(newTemplate.getSketch());
        oldTemplate.setEditTemplateUrl(newTemplate.getEditTemplateUrl());
        oldTemplate.setViewTemplateUrl(newTemplate.getViewTemplateUrl());
        oldTemplate.setName(newTemplate.getName());
        oldTemplate.setDescription(newTemplate.getDescription());
        oldTemplate.setProps(this.updateExtendedProps(oldTemplate.getProps(), newTemplate.getProps()));
        this.deleteProtectionTasks(oldProtectGroup.getUuid());
        oldTemplate.getSchedules().clear();
        oldTemplate.getSchedules().addAll(newTemplate.getSchedules());
        ProtectGroupUtil.clearRemoteReplicas(oldProtectGroup.getReplicaList());
        oldProtectGroup.getReplicaList().addAll(newProtectGroup.getReplicaList());
        Set oldProtectObjects = oldProtectGroup.getPolist();
        Set newProtectObjects = newProtectGroup.getPolist();
        for (ProtectObject oldProtectObject : oldProtectObjects) {
            DRMObject drmObject = this.getMatchedDrmObject(newProtectObjects, (DRMObject)oldProtectObject);
            if (drmObject == null) {
                logger.debug((Object)"drmObject is null!");
                continue;
            }
            ProtectObject newProtectObject = (ProtectObject)drmObject;
            this.updateProtectObject(oldProtectObject, newProtectObject);
        }
    }

    protected void refactorProtectGroup(ProtectGroup protectGroup, Map<String, Object> params) {
        protectGroup.setStatus(DrmEnumDefine.ProtectGroupStatus.NORMAL.getStatus());
        protectGroup.setPrimary(true);
        protectGroup.setLastExecResult(null);
        this.reverseProtectGroupAttributes(protectGroup, params);
        logger.debug((Object)"after reverseProtectGroupAttributes:recoveryPlan name%s", new Object[]{protectGroup.getName()});
        for (ProtectObject po : protectGroup.getPolist()) {
            po.setPoRecoveryStatus(DrmEnumDefine.ProtectObjectRecoveryStatusE.NOT_STARTED.getValue());
            this.refactorProtectObject(po, params);
        }
    }

    protected void updateProtectObject(ProtectObject oldProtectObject, ProtectObject newProtectObject) {
        logger.debug((Object)"updateProtectObject");
        oldProtectObject.setMoUuid(newProtectObject.getMoUuid());
        oldProtectObject.setProviderSN(newProtectObject.getProviderSN());
        oldProtectObject.setPoRecoveryStatus(newProtectObject.getPoRecoveryStatus());
        oldProtectObject.setName(newProtectObject.getName());
        oldProtectObject.setProps(this.updateExtendedProps(oldProtectObject.getProps(), newProtectObject.getProps()));
        Set oldPoStorageInfos = oldProtectObject.getUsedStorageResourceSet();
        Set newPoStorageInfos = newProtectObject.getUsedStorageResourceSet();
        Iterator oldIterator = oldPoStorageInfos.iterator();
        while (oldIterator.hasNext()) {
            ProtectObjectStorageInfo oldPoStorageInfo = (ProtectObjectStorageInfo)oldIterator.next();
            boolean isExist = false;
            Iterator newIterator = newPoStorageInfos.iterator();
            while (newIterator.hasNext()) {
                ProtectObjectStorageInfo newPoStorageInfo = (ProtectObjectStorageInfo)newIterator.next();
                if (!oldPoStorageInfo.getId().equals(newPoStorageInfo.getId())) continue;
                this.updateProtectObjectStorageInfo(oldPoStorageInfo, newPoStorageInfo);
                newIterator.remove();
                isExist = true;
                break;
            }
            if (isExist) continue;
            CommonDAOLocator.getBaseDao().getHibernateTemplate().delete((Object)oldPoStorageInfo);
            oldIterator.remove();
            oldIterator = oldPoStorageInfos.iterator();
        }
        for (ProtectObjectStorageInfo newPoStorageInfo : newPoStorageInfos) {
            newPoStorageInfo.setProtectObject(oldProtectObject);
            oldProtectObject.getUsedStorageResourceSet().add(newPoStorageInfo);
        }
    }

    protected void refactorProtectObject(ProtectObject protectObject, Map<String, Object> params) {
        this.refactorProtectObjectStorageInfos(protectObject, params);
        long start = System.currentTimeMillis();
        this.reverseProtectObjectAttributes(protectObject, params);
        logger.debug((Object)"reverseProtectObjectAttributes cost time:%s", new Object[]{String.valueOf(System.currentTimeMillis() - start)});
    }

    protected abstract void refactorProtectObjectStorageInfos(ProtectObject var1, Map<String, Object> var2);

    protected void updateProtectObjectStorageInfo(ProtectObjectStorageInfo oldPoStorageInfo, ProtectObjectStorageInfo newPoStorageInfo) {
        logger.debug((Object)"updateProtectObjectStorageInfo");
        oldPoStorageInfo.setResourceProviderSN(newPoStorageInfo.getResourceProviderSN());
        oldPoStorageInfo.setResourceId(newPoStorageInfo.getResourceId());
        oldPoStorageInfo.setLunWWN(newPoStorageInfo.getLunWWN());
    }

    protected void refactorPolicyTemplate(ProtectGroup pg) {
        IPolicyTemplateManager policyTemplateManager;
        PolicyTemplate newTemplate;
        Integer newTemplateType = mapTemplate.get(pg.getTemplate().getType());
        if (newTemplateType == null) {
            newTemplateType = pg.getTemplate().getType();
        }
        if ((newTemplate = (policyTemplateManager = (IPolicyTemplateManager)ServiceLocator.getInstance().getService(IPolicyTemplateManager.class)).clonePolicyTemlate(newTemplateType.intValue())) == null) {
            logger.error((Object)"There is no matched template in db. Type:%s.", new Object[]{String.valueOf(newTemplateType)});
            throw new LegoCheckedException(1073947394L);
        }
        PolicyTemplate oldTemplate = pg.getTemplate();
        oldTemplate.setType(newTemplate.getType());
        oldTemplate.setSketch(newTemplate.getSketch());
        oldTemplate.setEditTemplateUrl(newTemplate.getEditTemplateUrl());
        oldTemplate.setViewTemplateUrl(newTemplate.getViewTemplateUrl());
        oldTemplate.setName(newTemplate.getName());
        oldTemplate.setDescription(newTemplate.getDescription());
        Set schedules = newTemplate.getSchedules();
        if (!VerifyUtil.isEmpty((Collection)schedules)) {
            for (Schedule schedule : schedules) {
                schedule.setScheduleId(UUIDGenerator.getUUID());
            }
        }
        if (BusinessUtil.isUltraVR()) {
            if (TEMPLATE3DC_EXCLUDE_RING.contains(newTemplate.getType()) || TEMPLATE4DC.contains(newTemplate.getType()) || !this.getIsReversed().booleanValue()) {
                this.setSchedule(oldTemplate, schedules);
            }
        } else if (TEMPLATE3DC.contains(newTemplate.getType()) || this.is4dcWithoutVault(newTemplate) && !this.getIsReversed().booleanValue() || !this.getIsReversed().booleanValue()) {
            this.setSchedule(oldTemplate, schedules);
        }
    }

    private void setSchedule(PolicyTemplate oldTemplate, Set<Schedule> schedules) {
        oldTemplate.setSchedules(schedules);
        if (oldTemplate.getProps().containsKey("syncRateRecords")) {
            oldTemplate.getProps().put("syncRateRecords", "[]");
        }
    }

    protected abstract void reverseProtectObjectAttributes(ProtectObject var1, Map<String, Object> var2);

    protected abstract void reverseProtectGroupAttributes(ProtectGroup var1, Map<String, Object> var2);

    protected ProtectObjectReplica getProtectObjectReplica(ProtectObject protectObject, Map<String, Object> params) {
        String disasterSiteId = String.valueOf(params.get("DISASTER_SITE_ID"));
        ProtectGroupReplica pgReplica = null;
        Set pgReplicas = protectObject.getProtectGroup().getReplicaList();
        for (ProtectGroupReplica replica : pgReplicas) {
            if (ProtectGroupUtil.isLocalStorageReplica(replica) || !replica.getRecoverySite().equals(disasterSiteId)) continue;
            pgReplica = replica;
            if (params.containsKey("oldProductSiteIds")) break;
            Set<String> productSiteIds = this.getProductSiteByPo(protectObject);
            params.put("oldProductSiteIds", productSiteIds);
            break;
        }
        if (pgReplica == null) {
            Object obj = params.get("oldProductSiteIds");
            Set<String> productSiteIds = !(obj instanceof Set) ? this.getProductSiteByPo(protectObject) : (Set<String>)obj;
            String productSiteId = String.valueOf(params.get("PRODUCT_SITE_ID"));
            for (ProtectGroupReplica replica : pgReplicas) {
                if (ProtectGroupUtil.isLocalStorageReplica(replica) || !productSiteIds.contains(replica.getRecoverySite()) && !productSiteId.equals(replica.getRecoverySite())) continue;
                pgReplica = replica;
                break;
            }
        }
        ProtectObjectReplica curPoReplica = null;
        if (pgReplica != null) {
            for (ProtectObjectReplica poReplica : pgReplica.getReplicas()) {
                if (!poReplica.getPoId().equals(protectObject.getUuid())) continue;
                curPoReplica = poReplica;
                break;
            }
        }
        if (curPoReplica == null) {
            logger.error((Object)"curPoReplica is null!");
            throw new LegoCheckedException(-1L);
        }
        return curPoReplica;
    }

    protected abstract Set<String> getProductSiteByPo(ProtectObject var1);

    private Map<String, String> updateExtendedProps(Map<String, String> oldProps, Map<String, String> newProps) {
        if (VerifyUtil.isEmpty(newProps)) {
            logger.debug((Object)"newProps is empty!");
            return oldProps;
        }
        if (oldProps == null) {
            oldProps = new HashMap<String, String>();
        }
        for (Map.Entry<String, String> entry : newProps.entrySet()) {
            oldProps.put(entry.getKey(), entry.getValue());
        }
        ArrayList<String> oldKeys = new ArrayList<String>();
        for (Map.Entry<String, String> entry : oldProps.entrySet()) {
            if (newProps.containsKey(entry.getKey())) continue;
            oldKeys.add(entry.getKey());
        }
        for (String oldKey : oldKeys) {
            oldProps.remove(oldKey);
        }
        return oldProps;
    }

    protected void resumeGroup(ProtectGroup pg) {
        ITaskManager protectionTaskManager = (ITaskManager)ServiceLocator.getInstance().getService(ITaskManager.class);
        String groupName = protectionTaskManager.getGroupName(pg.getUuid());
        protectionTaskManager.resumeGroup(groupName);
        logger.debug((Object)"uuid:%s, groupName:%s", new Object[]{pg.getUuid(), groupName});
    }

    private void deleteRemovedRecoverySettings(Set<RecoverySetting> oldRecoverySettings, Set<RecoverySetting> newRecoverySettings) {
        logger.debug((Object)"deleteRemovedRecoverySettings");
        for (RecoverySetting setting : oldRecoverySettings) {
            if (newRecoverySettings.contains(setting)) continue;
            CommonDAOLocator.getMoDao().getHibernateTemplate().delete((Object)setting);
        }
    }

    private void deleteProtectionTasks(String protectGroupId) {
        logger.info((Object)"protectGroupId:%s", new Object[]{protectGroupId});
        List<ProtectionTask> tasks = this.getProtectionTasks(protectGroupId);
        if (tasks != null) {
            for (ProtectionTask task : tasks) {
                CommonDAOLocator.getMoDao().getHibernateTemplate().delete((Object)task);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ProtectionTask> getProtectionTasks(String protectGroupId) {
        if (VerifyUtil.isEmpty((String)protectGroupId)) {
            logger.error((Object)"invalid parameter");
            throw new LegoCheckedException(1073947393L);
        }
        List tasks = null;
        Session session = null;
        try {
            session = CommonDAOLocator.getMoDao().getHibernateTemplate().getSessionFactory().openSession();
            Criteria criteria = session.createCriteria(ProtectionTask.class);
            criteria.add((Criterion)Restrictions.eq((String)"protectGroup.pgId", (Object)protectGroupId));
            tasks = criteria.list();
        }
        catch (Exception e) {
            try {
                ExceptionUtil.rethrowException((Throwable)e, (String)("get tasks by pgId failed, pgId=" + protectGroupId), (long)-1L, (String[])new String[0], (Log)logger);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession(session);
        }
        DBOperationUtil.closeSession(session);
        return tasks;
    }

    private void deleteProtectActions(String pgId) {
        logger.debug((Object)"pgId:%s", new Object[]{pgId});
        String hql = "from AbstractBaseProtectAction action where action.protectGroupId=?";
        List actions = CommonDAOLocator.getBaseDao().getHibernateTemplate().find(hql, new Object[]{pgId});
        if (!VerifyUtil.isEmpty((Collection)actions)) {
            CommonDAOLocator.getBaseDao().getHibernateTemplate().deleteAll((Collection)actions);
        }
    }

    private DRMObject getMatchedDrmObject(Set<? extends DRMObject> drmObjects, DRMObject drmObject) {
        for (DRMObject dRMObject : drmObjects) {
            if (!dRMObject.getUuid().equals(drmObject.getUuid())) continue;
            return dRMObject;
        }
        logger.warn((Object)"getMatchedDrmObject return null.");
        return null;
    }

    protected boolean refactorLocalReplica(ProtectGroup pg, Map<String, Object> params) {
        boolean changed = false;
        if (VerifyUtil.isEmpty((Object)pg) || VerifyUtil.isEmpty((Collection)pg.getReplicaList())) {
            return changed;
        }
        Optional<ProtectGroupReplica> optional = this.findMatchFromReversedRemoteReplica(pg, params);
        if (!optional.isPresent()) {
            return changed;
        }
        ProtectGroupReplica remotePgReplica = optional.get();
        HashMap<String, ProtectObject> poMap = new HashMap<String, ProtectObject>();
        for (ProtectObject po : pg.getPolist()) {
            poMap.put(po.getUuid(), po);
        }
        for (ProtectGroupReplica pgr : pg.getReplicaList()) {
            if (!pgr.isSanSnapshotReplica() && !pgr.isBackUpReplica()) continue;
            if (remotePgReplica.getProductArray().equals(pgr.getStorageDeviceId()) && pgr.getProtectLocation() != DrmEnumDefine.ProtectLocation.A_A.getValue()) {
                changed = true;
                pgr.setProtectLocation(DrmEnumDefine.ProtectLocation.A_A.getValue());
                pgr.setProductArray(remotePgReplica.getProductArray());
            } else if (remotePgReplica.getRecoveryArray().equals(pgr.getStorageDeviceId()) && pgr.getProtectLocation() != DrmEnumDefine.ProtectLocation.A_B.getValue()) {
                changed = true;
                pgr.setProtectLocation(DrmEnumDefine.ProtectLocation.A_B.getValue());
                pgr.setProductArray(remotePgReplica.getProductArray());
            }
            Set replicas = pgr.getReplicas();
            this.refactorLocalPoReplica(remotePgReplica, replicas, poMap, params);
        }
        if (changed) {
            CommonDAOLocator.getBaseDao().saveOrUpdateAll((Collection)pg.getReplicaList());
        }
        return changed;
    }

    private Optional<ProtectGroupReplica> findMatchFromReversedRemoteReplica(ProtectGroup pg, Map<String, Object> params) {
        if (!TEMPLATE4DC.contains(pg.getTemplate().getType()) || this.is4dcWithoutVault(pg.getTemplate())) {
            return Optional.of(pg.getAnyoneReplicationReplica());
        }
        List protectGroupReplicas = pg.listAllReplicatonRepica();
        if (pg.getPoType() == 10) {
            return protectGroupReplicas.stream().filter(protectGroupReplica -> protectGroupReplica.getProtectLocation() == DrmEnumDefine.ProtectLocation.A_B.getValue()).findFirst();
        }
        List collect = protectGroupReplicas.stream().filter(protectGroupReplica -> pg.getPoProviderSN().equals(protectGroupReplica.getProductArray())).collect(Collectors.toList());
        if (collect.size() == 1) {
            return Optional.of(collect.get(0));
        }
        for (ProtectGroupReplica remoteReplica : collect) {
            if (!Objects.equals(remoteReplica.getProductArray(), pg.getPoProviderSN()) || !Objects.equals(remoteReplica.getRecoveryArray(), params.get(pg.getPoProviderSN()))) continue;
            return Optional.of(remoteReplica);
        }
        Set hyperMetroSiteIdSet = pg.getHyperMetroSiteIdSet();
        for (ProtectGroupReplica remoteReplica : collect) {
            if (!hyperMetroSiteIdSet.contains(remoteReplica.getRecoverySite())) continue;
            return Optional.of(remoteReplica);
        }
        logger.warn((Object)"Can't find remoteReplica by ProductArray: productArray=%s", new Object[]{pg.getPoProviderSN()});
        return Optional.empty();
    }

    protected void refactorLocalPoReplica(ProtectGroupReplica remotePgReplica, Set<ProtectObjectReplica> replicas, Map<String, ProtectObject> poMap, Map<String, Object> params) {
        if (VerifyUtil.isEmpty(replicas) || VerifyUtil.isEmpty((Object)remotePgReplica)) {
            return;
        }
        for (ProtectObjectReplica poReplica : replicas) {
            this.refactorRelicaStorageInfo(remotePgReplica, poReplica, params);
            ProtectObject po = poMap.get(poReplica.getPoId());
            if (!VerifyUtil.isEmpty((Object)po)) {
                poReplica.setProtectObject(po);
                continue;
            }
            logger.error((Object)"po not found:%s.", new Object[]{poReplica.getPoId()});
        }
    }

    protected void refactorRelicaStorageInfo(ProtectGroupReplica remotePgReplica, ProtectObjectReplica poReplica, Map<String, Object> params) {
        Set storageInfos = poReplica.getStorageInfos();
        ProtectObject po = poReplica.getProtectObject();
        if (VerifyUtil.isEmpty((Object)remotePgReplica) || VerifyUtil.isEmpty((Collection)storageInfos)) {
            return;
        }
        this.caculateOtoNewWwnMap(new ArrayList<ProtectObjectStorageInfo>(po.getUsedStorageResourceSet()), (ProtectObject)CommonUtil.getFirstElement((Collection)remotePgReplica.getPg().getPolist()), params);
        HashSet remoteStorageInfos = new HashSet();
        Set remotePoReplicas = remotePgReplica.getReplicas();
        if (!VerifyUtil.isEmpty((Collection)remotePoReplicas)) {
            for (ProtectObjectReplica remotePoReplica : remotePoReplicas) {
                remoteStorageInfos.addAll(remotePoReplica.getStorageInfos());
            }
        }
        Map olToNewWwnMap = (Map)params.get("olToNewWwnMap");
        block1: for (RelicaStorageInfo storageInfo : storageInfos) {
            for (RelicaStorageInfo remoteStorageInfo : remoteStorageInfos) {
                if (!remoteStorageInfo.getSrcStorageId().equals(storageInfo.getSrcStorageId()) && !remoteStorageInfo.getStorageId().equals(storageInfo.getSrcStorageId()) && (olToNewWwnMap == null || !remoteStorageInfo.getProtectObjectStorageWwn().equals(olToNewWwnMap.get(storageInfo.getProtectObjectStorageWwn()))) && !remoteStorageInfo.getProtectObjectStorageWwn().equals(storageInfo.getProtectObjectStorageWwn())) continue;
                storageInfo.setProtectObjectStorageWwn(remoteStorageInfo.getProtectObjectStorageWwn());
                continue block1;
            }
        }
        for (RelicaStorageInfo storageInfo : po.getUsedStorageResourceSet()) {
            if (olToNewWwnMap == null) {
                return;
            }
            String newWwn = (String)olToNewWwnMap.get(storageInfo.getLunWWN());
            if (newWwn == null) continue;
            storageInfo.setLunWWN(newWwn);
        }
    }

    protected abstract void caculateOtoNewWwnMap(List<ProtectObjectStorageInfo> var1, ProtectObject var2, Map<String, Object> var3);

    protected void resetWwnMap(ProtectObject po, ProtectGroupReplica remotePgReplica, Map<String, Object> params) {
    }

    protected void refactorLocalScheduleAndProps(ProtectGroup pg, int oldPolicytemplateType) {
        TemplateFilterManager manager;
        IPolicyTemplateFilter filter;
        List<ProtectLocationPath> paths;
        if (VerifyUtil.isEmpty((Object)pg) || VerifyUtil.isEmpty((Object)pg.getTemplate())) {
            return;
        }
        PolicyTemplate template = pg.getTemplate();
        if (PolicyTemplateType.OPENSTACK_POLICYTEMPLATE.contains(template.getType())) {
            return;
        }
        if (template.getProps().get("AUTOMOUNTCONFIGS") != null) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"enabled", (Object)false);
            template.getProps().put("AUTOMOUNTCONFIGS", jsonObject.toString());
        }
        if ((paths = (filter = (manager = TemplateFilterManager.getInstance()).getTemplateFilterByType(template.getType())).getProtectLocationPaths(new ArrayList(pg.getPolist()))) == null) {
            logger.debug((Object)"paths is null");
            paths = Collections.emptyList();
        }
        pg.getProps().put("PROTECTGROUP_PROTECTLOCATIONPATH", JSONArray.fromObject(paths).toString());
        Set schedules = template.getSchedules();
        if (VerifyUtil.isEmpty((Collection)schedules)) {
            logger.error((Object)"no need reverse schedule.");
            return;
        }
        HashMap<String, ProtectLocationPath> pathMap = new HashMap<String, ProtectLocationPath>();
        for (ProtectLocationPath path : paths) {
            pathMap.put(path.getRecoverySiteId(), path);
        }
        HashMap<Integer, ProtectLocationPath> locationMap = new HashMap<Integer, ProtectLocationPath>();
        for (ProtectLocationPath path : paths) {
            locationMap.put(path.getProtectLocation(), path);
        }
        this.checkAndSwap4dcProtectLocation(pg, oldPolicytemplateType, schedules, paths, locationMap);
        for (Schedule schedule : schedules) {
            this.updateSchedule(pg, pathMap, locationMap, schedule, oldPolicytemplateType, template.getType());
        }
    }

    private void checkAndSwap4dcProtectLocation(ProtectGroup pg, int oldPolicytemplateType, Set<Schedule> schedules, List<ProtectLocationPath> paths, Map<Integer, ProtectLocationPath> locationMap) {
        if (!this.is4dcWithoutVault(pg.getTemplate()) || !this.getIsReversed().booleanValue()) {
            return;
        }
        Schedule first = schedules.stream().filter(e -> e.getProtectLocation() == DrmEnumDefine.ProtectLocation.A_B.getValue()).findFirst().orElseThrow(() -> {
            logger.error((Object)"Current 4dc does not has a protectLocation=1 schedule, pg name=%s.", new Object[]{pg.getName()});
            return new LegoCheckedException(1073947394L);
        });
        Schedule second = schedules.stream().filter(e -> e.getProtectLocation() != DrmEnumDefine.ProtectLocation.A_B.getValue()).findFirst().orElseThrow(() -> {
            logger.error((Object)"Current 4dc does not has a protectLocation!=1 schedule, pg name=%s.", new Object[]{pg.getName()});
            return new LegoCheckedException(1073947394L);
        });
        int protectLocation = first.getProtectLocation();
        if (locationMap.size() == 1 && (oldPolicytemplateType == 59 || oldPolicytemplateType == 36) && paths.get(0).getRecoverySiteId().equalsIgnoreCase(second.getSourceSiteId())) {
            AbstractBaseRefactorConfigurationProvider.doSwapProtectLocation(pg, first, second, protectLocation);
        }
        if (locationMap.size() == 2 && (oldPolicytemplateType == 58 || oldPolicytemplateType == 35) && locationMap.get(DrmEnumDefine.ProtectLocation.A_B.getValue()).getRecoverySiteId().equalsIgnoreCase(second.getTargetSiteId())) {
            AbstractBaseRefactorConfigurationProvider.doSwapProtectLocation(pg, first, second, protectLocation);
        }
    }

    private static void doSwapProtectLocation(ProtectGroup pg, Schedule first, Schedule second, int protectLocation) {
        first.setProtectLocation(second.getProtectLocation());
        second.setProtectLocation(protectLocation);
        logger.info((Object)"Finish swap protectLocation, pg name =%s.", new Object[]{pg.getName()});
    }

    private void updateSchedule(ProtectGroup protectGroup, Map<String, ProtectLocationPath> pathMap, Map<Integer, ProtectLocationPath> locationMap, Schedule schedule, int oldTemplateType, int newTemplateType) {
        if (11 == protectGroup.getPoType()) {
            schedule.setAppConsistent(Boolean.valueOf(false));
        }
        if (!ScheduleProtectedType.getAllProtectedTypes().contains(schedule.getProtectedType())) {
            this.updateDrRingScheduleProtectLocationPath(locationMap, newTemplateType, schedule);
            this.update4dcScheduleProtectLocationPath(protectGroup.getTemplate(), schedule);
            ProtectLocationPath path = locationMap.get(schedule.getProtectLocation());
            if (VerifyUtil.isEmpty((Object)path)) {
                return;
            }
            schedule.setSourceSiteId(path.getProtectedSiteId());
            schedule.setTargetSiteId(path.getRecoverySiteId());
            schedule.setName(path.getProtectedSiteId() + ";" + path.getRecoverySiteId());
            schedule.setSourceSn(path.getProtectedStorageSN());
            schedule.setTargetSn(path.getRecoveryStorageSN());
            schedule.getExtParameters().put("replicationMode", path.getReplicationMode());
            if (schedule.getProtectedType() == -1 || schedule.getProtectedType() == oldTemplateType) {
                schedule.setProtectedType(newTemplateType);
            }
            return;
        }
        if (null == schedule.getSourceSiteId()) {
            this.setScheduleManual(protectGroup, schedule);
            return;
        }
        ProtectLocationPath path = pathMap.get(schedule.getSourceSiteId());
        if (path == null) {
            schedule.setEnable(Boolean.valueOf(false));
        } else {
            Optional.of(newTemplateType).filter(TEMPLATE4DC::contains).ifPresent(type -> schedule.setEnable(Boolean.valueOf(true)));
            int location = path.getProtectLocation();
            schedule.setSourceSiteId(path.getRecoverySiteId());
            schedule.setTargetSiteId(path.getRecoverySiteId());
            schedule.setProtectLocation(location);
        }
        if (schedule.getPeriodType() == 5) {
            this.setScheduleManual(protectGroup, schedule);
        }
        schedule.setScheduleMode(1);
    }

    private void update4dcScheduleProtectLocationPath(PolicyTemplate newTemplateType, Schedule schedule) {
        logger.debug((Object)"protect location: %s", new Object[]{String.valueOf(schedule.getProtectLocation())});
        if (!TEMPLATE4DC.contains(newTemplateType.getType()) || this.is4dcWithoutVault(newTemplateType) && !this.getIsReversed().booleanValue()) {
            return;
        }
        if (schedule.getProtectLocation() == DrmEnumDefine.ProtectLocation.B_C.getValue()) {
            schedule.setProtectLocation(DrmEnumDefine.ProtectLocation.A_C.getValue());
            return;
        }
        if (schedule.getProtectLocation() == DrmEnumDefine.ProtectLocation.A_C.getValue()) {
            schedule.setProtectLocation(DrmEnumDefine.ProtectLocation.B_C.getValue());
        }
    }

    private boolean is4dcWithoutVault(PolicyTemplate newTemplate) {
        int templateType = newTemplate.getType();
        if (!TEMPLATE4DC.contains(templateType)) {
            return false;
        }
        return templateType != 40 && templateType != 41 && templateType != 42 && templateType != 43;
    }

    private void setScheduleManual(ProtectGroup protectGroup, Schedule schedule) {
        IProtectionTaskService service;
        if (schedule == null) {
            return;
        }
        schedule.setScheduleMode(1);
        schedule.setPeriodType(2);
        if (schedule.getRetentionPolicy() != null) {
            schedule.getRetentionPolicy().setLatestCopies(5);
            schedule.getRetentionPolicy().setDailyCopies(0);
            schedule.getRetentionPolicy().setWeeklyCopies(0);
            schedule.getRetentionPolicy().setMonthlyCopyies(0);
        }
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Object)(service = (IProtectionTaskService)ServiceLocator.getInstance().getService(IProtectionTaskService.class)).getTask(protectGroup.getUuid(), schedule.getScheduleId()))) {
            service.addTask(protectGroup, schedule);
        }
    }

    static {
        TEMPLATE3DC.add(4);
        TEMPLATE3DC.add(6);
        TEMPLATE3DC.add(3);
        TEMPLATE3DC.add(5);
        TEMPLATE3DC.add(26);
        TEMPLATE3DC.add(27);
        TEMPLATE3DC_EXCLUDE_RING.add(4);
        TEMPLATE3DC_EXCLUDE_RING.add(6);
        TEMPLATE3DC_EXCLUDE_RING.add(3);
        TEMPLATE3DC_EXCLUDE_RING.add(5);
        TEMPLATE4DC.add(35);
        TEMPLATE4DC.add(36);
        TEMPLATE4DC.add(58);
        TEMPLATE4DC.add(59);
        TEMPLATE4DC.add(40);
        TEMPLATE4DC.add(41);
        TEMPLATE4DC.add(42);
        TEMPLATE4DC.add(43);
        mapTemplate.put(4, 6);
        mapTemplate.put(6, 4);
        mapTemplate.put(3, 5);
        mapTemplate.put(5, 3);
        mapTemplate.put(18, 20);
        mapTemplate.put(20, 18);
        mapTemplate.put(23, 24);
        mapTemplate.put(24, 23);
        mapTemplate.put(31, 32);
        mapTemplate.put(32, 31);
        mapTemplate.put(26, 27);
        mapTemplate.put(27, 26);
        mapTemplate.put(40, 41);
        mapTemplate.put(35, 36);
        mapTemplate.put(36, 35);
        mapTemplate.put(58, 59);
        mapTemplate.put(59, 58);
        mapTemplate.put(41, 40);
        mapTemplate.put(42, 43);
        mapTemplate.put(43, 42);
    }
}

