/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.reprotect.service.impl;

import com.huawei.ism.drm.base.service.DrmBaseService;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.reprotect.sdk.service.IReprotectBaseService;
import com.huawei.ism.drm.system.plugin.DrmBaseApplication;
import com.huawei.lego.comm.internal.jms.IMessageCenter;
import com.huawei.lego.comm.internal.jms.MessageTopic;
import com.huawei.lego.comm.internal.jms.MessageUnit;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.HashSet;

public abstract class AbstractReprotectService
extends DrmBaseService
implements IReprotectBaseService {
    private static final Log logger = LogFactory.getInstance(AbstractReprotectService.class);
    protected IMessageCenter messageCenter;

    public void sendReprotectSuccessMsg(RecoveryPlan recoveryPlan) {
        if (recoveryPlan == null || recoveryPlan.getProtectGroups() == null || recoveryPlan.getProtectGroups().isEmpty()) {
            logger.debug((Object)"Param is null ,not sendReprotectSuccessMsg");
            return;
        }
        HashSet<ProtectGroup> protectGroups = new HashSet<ProtectGroup>();
        for (ProtectGroup protectGroup : recoveryPlan.getProtectGroups()) {
            protectGroups.add(protectGroup);
        }
        MessageUnit mu = new MessageUnit();
        mu.setCmdcode(100001L);
        mu.setObj(protectGroups);
        mu.setMt(MessageTopic.DATA);
        mu.setSourceAppName(DrmBaseApplication.class.getName());
        this.messageCenter.sendMessage(mu);
        logger.info((Object)"Sending reprotect success message. Name:%s", new Object[]{recoveryPlan.getName()});
    }
}

