/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.manager.proxy;

import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.storage.manager.proxy.BaseStorageManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageLicenseManager;
import com.huawei.ism.drm.storage.sdk.model.DrStorage;
import com.huawei.ism.drm.storage.sdk.model.StorageLicense;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.HashMap;
import java.util.Map;

public class StorageLicenseManagerProxy
extends BaseStorageManagerProxy
implements IStorageLicenseManager {
    private static StorageLicenseManagerProxy proxy = new StorageLicenseManagerProxy();
    private Map<String, IStorageLicenseManager> storageLicenseManagers = new HashMap<String, IStorageLicenseManager>();

    public static StorageLicenseManagerProxy getInstance() {
        return proxy;
    }

    public void onBind(IStorageLicenseManager handler, Map<String, Object> properties) {
        this.storageLicenseManagers.put(handler.getStorageType(), handler);
    }

    public void onUnbind(IStorageLicenseManager handler, Map<String, Object> properties) {
        this.storageLicenseManagers.remove(handler.getStorageType());
    }

    public StorageLicense getArrayLicense(String devSn) {
        String storageType = this.getStorageType(devSn);
        IResourceService resourceService = (IResourceService)ServiceLocator.getInstance().getService(IResourceService.class);
        DrResource drResource = resourceService.getDrResourceBySn(devSn);
        if (VerifyUtil.isEmpty((Object)drResource)) {
            logger.error((Object)"StorageResource is not exist. DevSn=[%s]", new Object[]{devSn});
            throw new LegoCheckedException(2117645L);
        }
        Integer status = NumberUtil.convertToInteger((Object)drResource.getStatus(), (int)0);
        if (0 != status || !(drResource instanceof DrStorage)) {
            return new StorageLicense();
        }
        return this.storageLicenseManagers.get(storageType).getArrayLicense(devSn);
    }

    public String getStorageType() {
        return null;
    }
}

