/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.manager.proxy;

import com.huawei.ism.drm.base.util.SiteUtil;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryResourceBaseService;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.rest.client.RestClient;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.storage.manager.proxy.BaseStorageManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageReprotectBaseManager;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class StorageReprotectManagerProxy
extends BaseStorageManagerProxy
implements IStorageReprotectBaseManager {
    private static StorageReprotectManagerProxy reprotectManagerProxy = new StorageReprotectManagerProxy();
    private static final Log logger = LogFactory.getInstance(StorageReprotectManagerProxy.class);
    private Map<String, IStorageReprotectBaseManager> storageReprotectManagers = new HashMap<String, IStorageReprotectBaseManager>();

    private StorageReprotectManagerProxy() {
    }

    public static StorageReprotectManagerProxy getInstance() {
        return reprotectManagerProxy;
    }

    public void onBind(IStorageReprotectBaseManager handler, Map<String, Object> properties) {
        this.storageReprotectManagers.put(handler.getStorageType(), handler);
    }

    public void onUnbind(IStorageReprotectBaseManager handler, Map<String, Object> properties) {
        this.storageReprotectManagers.remove(handler.getStorageType());
    }

    public IStorageReprotectBaseManager getStorageReprotectMgrByDevType(String deviceType) {
        return this.storageReprotectManagers.get(deviceType);
    }

    public IStorageReprotectBaseManager getStorageReprotectMgrByDevId(String deviceId) {
        String deviceType = this.getStorageType(deviceId);
        IStorageReprotectBaseManager mgr = this.storageReprotectManagers.get(deviceType);
        if (null == mgr) {
            logger.error((Object)("mgr is null, sn=" + deviceId + ", type=" + deviceType));
            throw new LegoCheckedException(1073947395L);
        }
        return mgr;
    }

    public OperationResult reverseReplication(String srcDeviceId, String targetDeviceId, String replicationId, boolean isConsistentGroup) {
        IStorageReprotectBaseManager storageReprotectMgr = this.getStorageReprotectMgrByDevId(targetDeviceId);
        return storageReprotectMgr.reverseReplication(srcDeviceId, targetDeviceId, replicationId, isConsistentGroup);
    }

    public void refreshStorage(String deviceId) {
        IRecoveryResourceBaseService recoveryService = (IRecoveryResourceBaseService)ServiceLocator.getInstance().getService(IRecoveryResourceBaseService.class);
        Site site = recoveryService.getStorageRegisteredSite(deviceId);
        if (null != site && 1 == site.getSiteType()) {
            HashMap<String, String> request = new HashMap<String, String>();
            request.put("deviceId", deviceId);
            String url = "/ws/replications/refreshStorage";
            RestClient client = SiteUtil.initClient(site);
            client.postSerializableObj(request, url);
        } else {
            IStorageReprotectBaseManager storageReprotectMgr = this.getStorageReprotectMgrByDevId(deviceId);
            storageReprotectMgr.refreshStorage(deviceId);
        }
    }

    public void checkStorageReplication(String deviceId, List<String> resourceIds) {
        IStorageReprotectBaseManager storageReprotectMgr = this.getStorageReprotectMgrByDevId(deviceId);
        storageReprotectMgr.checkStorageReplication(deviceId, resourceIds);
    }

    public OperationResult setSecondaryLunWriteProtection(String srcDeviceId, String targetDeviceId, String replicationId, boolean isConsistentGroup) {
        IStorageReprotectBaseManager storageReprotectMgr = this.getStorageReprotectMgrByDevId(targetDeviceId);
        return storageReprotectMgr.setSecondaryLunWriteProtection(srcDeviceId, targetDeviceId, replicationId, isConsistentGroup);
    }

    public String getStorageType() {
        return null;
    }

    public void refreshVasaProtectGroupStorage(String deviceId, String consistencyGroupId) {
        IStorageReprotectBaseManager storageReprotectMgr = this.getStorageReprotectMgrByDevId(deviceId);
        storageReprotectMgr.refreshVasaProtectGroupStorage(deviceId, consistencyGroupId);
    }

    public void refreshProtectGroupStorage(String deviceId, Set<String> pairIds) {
        IStorageReprotectBaseManager storageReprotectMgr = this.getStorageReprotectMgrByDevId(deviceId);
        storageReprotectMgr.refreshProtectGroupStorage(deviceId, pairIds);
    }
}

