/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.topo.service.impl;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanBaseService;
import com.huawei.ism.drm.license.sdk.ILicenseBaseControl;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupBaseService;
import com.huawei.ism.drm.protection.replica.sdk.service.IReplicaBaseService;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.template.sdk.service.IPolicyTemplateManager;
import com.huawei.ism.drm.site.sdk.service.ISiteBaseService;
import com.huawei.ism.drm.storage.sdk.service.IStorageBaseService;
import com.huawei.ism.drm.storage.sdk.service.IStorageResourceBaseService;
import com.huawei.ism.drm.topo.builder.TopoLegendBuilder;
import com.huawei.ism.drm.topo.sdk.builder.ITopoBaseBuilder;
import com.huawei.ism.drm.topo.sdk.context.TopoBaseContext;
import com.huawei.ism.drm.topo.sdk.manager.ITopoBuilderManager;
import com.huawei.ism.drm.topo.sdk.manager.ITopoResourceManager;
import com.huawei.ism.drm.topo.sdk.model.TopologyResultVO;
import com.huawei.ism.drm.topo.sdk.utils.TopoUtil;
import com.huawei.ism.drm.topo.utils.TopoBuildUtil;
import com.huawei.ism.drm.topo.utils.TopoServiceUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.topology.Data;
import com.huawei.topology.ElementBox;
import com.huawei.topology.IData;
import com.huawei.topology.Node;
import com.huawei.topology.SerializationSettings;
import com.huawei.topology.SubNetwork;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TopoBuilderManagerImpl
implements ITopoBuilderManager {
    private static final String TYPE_KEY = "type";
    private static final double TOPO_MORE_HIGHT = 15.0;
    private static final List<Integer> ASYNC_POLICY_TEMPLATE_TYPE_LIST = new ArrayList<Integer>(Arrays.asList(1, 3, 4, 5, 6, 16, 35, 36, 33, 39, 58, 59, 40, 41, 42, 43));
    private static final List<Integer> SNAPSHOT_TEMPLATE = new ArrayList<Integer>(Arrays.asList(14, 17, 44, 45, 48, 46));
    private final Log logger = LogFactory.getInstance(this.getClass());
    private ISiteBaseService siteService;
    private IStorageBaseService storageService;
    private IProtectGroupBaseService protectGroupService;
    private IRecoveryPlanBaseService recoveryPlanService;
    private IReplicaBaseService replicaService;
    private IPolicyTemplateManager policyTemplateManager;
    private Map<String, ITopoBaseBuilder> builders = new HashMap<String, ITopoBaseBuilder>();
    private ILicenseBaseControl licenseControl;
    private IStorageResourceBaseService storageResourceService;

    public IStorageResourceBaseService getStorageResourceService() {
        return this.storageResourceService;
    }

    public void setStorageResourceService(IStorageResourceBaseService storageResourceService) {
        this.storageResourceService = storageResourceService;
    }

    public IPolicyTemplateManager getPolicyTemplateManager() {
        return this.policyTemplateManager;
    }

    public void setPolicyTemplateManager(IPolicyTemplateManager policyTemplateManager) {
        this.policyTemplateManager = policyTemplateManager;
    }

    public IReplicaBaseService getReplicaService() {
        return this.replicaService;
    }

    public void setReplicaService(IReplicaBaseService replicaService) {
        this.replicaService = replicaService;
    }

    public ILicenseBaseControl getLicenseControl() {
        return this.licenseControl;
    }

    public void setLicenseControl(ILicenseBaseControl licenseControl) {
        this.licenseControl = licenseControl;
    }

    public ISiteBaseService getSiteService() {
        return this.siteService;
    }

    public void setSiteService(ISiteBaseService siteService) {
        this.siteService = siteService;
    }

    public IRecoveryPlanBaseService getRecoveryPlanService() {
        return this.recoveryPlanService;
    }

    public void setRecoveryPlanService(IRecoveryPlanBaseService recoveryPlanService) {
        this.recoveryPlanService = recoveryPlanService;
    }

    public IStorageBaseService getStorageService() {
        return this.storageService;
    }

    public void setStorageService(IStorageBaseService storageService) {
        this.storageService = storageService;
    }

    public IProtectGroupBaseService getProtectGroupService() {
        return this.protectGroupService;
    }

    public void setProtectGroupService(IProtectGroupBaseService protectGroupService) {
        this.protectGroupService = protectGroupService;
    }

    public ITopoBaseBuilder getTopoBuilder(String type) {
        return this.builders.get(type);
    }

    public void onBind(ITopoBaseBuilder builder, Map<String, Object> props) {
        block3: {
            Object type;
            block4: {
                block2: {
                    type = props.get(TYPE_KEY);
                    if (!(type instanceof String)) break block2;
                    this.builders.put((String)type, builder);
                    break block3;
                }
                if (!(type instanceof String[])) break block4;
                for (String each : (String[])type) {
                    this.builders.put(each, builder);
                }
                break block3;
            }
            if (!(type instanceof Collection)) break block3;
            for (Object each : (Collection)type) {
                this.builders.put(each.toString(), builder);
            }
        }
    }

    public void onUnbind(ITopoBaseBuilder builder, Map<String, Object> props) {
        block3: {
            Object type;
            block4: {
                block2: {
                    type = props.get(TYPE_KEY);
                    if (!(type instanceof String)) break block2;
                    this.unbind((String)type);
                    break block3;
                }
                if (!(type instanceof String[])) break block4;
                for (String each : (String[])type) {
                    this.unbind(each);
                }
                break block3;
            }
            if (!(type instanceof Collection)) break block3;
            for (Object each : (Collection)type) {
                this.unbind(each.toString());
            }
        }
    }

    public TopologyResultVO createProtectGroupTopoData(String pgId) {
        ProtectGroup protectGroup;
        this.logger.error((Object)"Create protectgroup topo data error, now: %s", new Object[]{new Date()});
        if (VerifyUtil.isEmpty((String)pgId)) {
            return TopoBuildUtil.createEmptyResult();
        }
        ITopoResourceManager manager = TopoBaseContext.getTopoResourceManager();
        try {
            protectGroup = this.protectGroupService.getProtectGroupByID(pgId);
        }
        catch (LegoCheckedException legoException) {
            this.logger.error((Object)"Create protectgroup topo data error: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)legoException)});
            return TopoBuildUtil.createInvalidResult(manager.getText("ism.drm.topo.err.group.invalid"));
        }
        catch (Exception legoException) {
            this.logger.error((Object)"Create protectgroup topo data error: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)legoException)});
            return TopoBuildUtil.createInvalidResult("lego.err.-1");
        }
        if (protectGroup == null) {
            return TopoBuildUtil.createInvalidResult(manager.getText("ism.drm.topo.err.group.invalid"));
        }
        try {
            this.licenseControl.checkEnablePgTopo(protectGroup);
        }
        catch (LegoCheckedException e) {
            this.logger.error((Object)"Create protectgroup topo data error", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            return TopoBuildUtil.createInvalidResult("lego.err." + e.getErrorCode());
        }
        catch (Exception legoException) {
            this.logger.error((Object)"Create protectgroup topo data error: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)legoException)});
            return TopoBuildUtil.createInvalidResult("lego.err.-1");
        }
        if (protectGroup.isInvalid()) {
            return TopoBuildUtil.createInvalidResult(manager.getText("ism.drm.topo.err.group.inactive"));
        }
        return this.createProtectGroupTopoDataContent(protectGroup);
    }

    private TopologyResultVO createProtectGroupTopoDataContent(ProtectGroup protectGroup) {
        TopologyResultVO result = new TopologyResultVO();
        try {
            TopoBaseContext context = this.createTopoContext(protectGroup);
            result.setBox(TopoBuildUtil.parseXml2Json(context.serialize()));
            String legendBoxStr = new TopoLegendBuilder().getLegendBoxString(context.getElementBox());
            result.setLegend(TopoBuildUtil.parseXml2Json(legendBoxStr));
            result.setIsSubNetWork(Boolean.valueOf(context.isSubNetWork()));
            this.handleTopoResult(result);
        }
        catch (LegoCheckedException e) {
            result = TopoBuildUtil.createInvalidResult("lego.err." + e.getErrorCode());
            this.logger.error((Object)"Create protectgroup topo data error", (Throwable)e, 90160758786986L);
        }
        catch (Exception legoException) {
            result = TopoBuildUtil.createInvalidResult("lego.err.-1");
            this.logger.error((Object)"Create protectgroup topo data error: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)legoException)});
        }
        return result;
    }

    private void handleTopoResult(TopologyResultVO result) {
        JSONObject box = result.getBox();
        Object boxDataObj = box.get("data");
        if (!(boxDataObj instanceof JSONArray)) {
            return;
        }
        JSONArray boxData = (JSONArray)boxDataObj;
        JSONArray realData = new JSONArray();
        for (Object data : boxData) {
            JSONObject property;
            if (!(data instanceof JSONObject)) continue;
            JSONObject jsonData = (JSONObject)data;
            if (!"Link".equals(jsonData.get(TYPE_KEY))) {
                realData.add(data);
                continue;
            }
            Object propertyObj = jsonData.get("property");
            if (!(propertyObj instanceof JSONObject) || VerifyUtil.isEmpty((Object)(property = (JSONObject)propertyObj).get("fromNode")) || VerifyUtil.isEmpty((Object)property.get("toNode"))) continue;
            realData.add(data);
        }
        box.put((Object)"data", (Object)realData);
    }

    public TopoBaseContext createTopoContext(ProtectGroup protectGroup) {
        TopoBaseContext context = new TopoBaseContext((ITopoBuilderManager)this, protectGroup);
        this.buildContext(context);
        int pgTemplateType = protectGroup.getTemplate().getType();
        if (SNAPSHOT_TEMPLATE.contains(pgTemplateType)) {
            return this.buildSnapshotTopoContext(context, pgTemplateType);
        }
        ProtectGroup protectGroupAllInfo = this.protectGroupService.getProtectGroupByID(protectGroup.getUuid());
        this.createProtectGroupTopoContext(context, protectGroupAllInfo);
        Node root = this.createTemplateTopoContext(context, protectGroupAllInfo);
        context.setRootNode(root);
        TopoServiceUtil.computeNodeWidthAndHight(root);
        this.setVirtualMoreNodeSize(context);
        return context;
    }

    private void createProtectGroupTopoContext(TopoBaseContext context, ProtectGroup protectGroup) {
        context.setProtectGroup(protectGroup);
        String type = "ProtectGroup-" + protectGroup.getPoType();
        ITopoBaseBuilder builder = this.getTopoBuilder(type);
        if (null != builder) {
            context.setType(type);
            builder.buildTopo(context);
        }
    }

    private Node createTemplateTopoContext(TopoBaseContext context, ProtectGroup protectGroup) {
        String type = "PolicyTemplate-" + protectGroup.getTemplate().getType();
        ITopoBaseBuilder builder = this.getTopoBuilder(type);
        Node root = context.getRootNode();
        if (null != builder) {
            if (root == null) {
                root = this.setTopoLayout(context);
            } else {
                this.setTopoLayout(context);
            }
            String verticalStyleNodeIdSecBottom = protectGroup.getUuid() + "SecondaryBottom" + "---" + "Style:unvisible";
            Node verticalStyleNodeSecBottom = (Node)context.getElementBox().getDataByID((Object)verticalStyleNodeIdSecBottom);
            if (!VerifyUtil.isEmpty((Object)verticalStyleNodeSecBottom)) {
                context.setRootNode(verticalStyleNodeSecBottom);
            }
            context.setType(type);
            builder.buildTopo(context);
        }
        Set<Integer> addtionTemplateTypeSet = this.getAddtionalTemplateType(context.getProtectGroup());
        for (int addtionTemplateType : addtionTemplateTypeSet) {
            type = "AddtionalPolicyTemplate-" + addtionTemplateType;
            builder = this.getTopoBuilder(type);
            if (builder == null) continue;
            String verticalStyleNodeIdSecTop = protectGroup.getUuid() + "SecondaryTop" + "---" + "Style:unvisible";
            Node verticalStyleNodeSecTop = (Node)context.getElementBox().getDataByID((Object)verticalStyleNodeIdSecTop);
            if (!VerifyUtil.isEmpty((Object)verticalStyleNodeSecTop)) {
                context.setRootNode(verticalStyleNodeSecTop);
            }
            context.setType(type);
            builder.buildTopo(context);
        }
        return root;
    }

    private void buildContext(TopoBaseContext context) {
        context.setSiteService(this.siteService);
        context.setStorageService(this.storageService);
        context.setProtectGroupService(this.protectGroupService);
        context.setRecoveryPlanService(this.recoveryPlanService);
        context.setReplicaService(this.replicaService);
        context.setPolicyTemplateManager(this.policyTemplateManager);
        context.setStorageResourceService(this.storageResourceService);
    }

    private TopoBaseContext buildSnapshotTopoContext(TopoBaseContext context, int pgTemplateType) {
        String type = "PolicyTemplate-" + pgTemplateType;
        ITopoBaseBuilder builder = this.getTopoBuilder(type);
        if (builder != null) {
            context.setType(type);
            builder.buildTopo(context);
        }
        TopoServiceUtil.computeNodeWidthAndHight(context.getRootNode());
        return context;
    }

    private Set<Integer> getAddtionalTemplateType(ProtectGroup protectGroup) {
        Set schedules = protectGroup.getTemplate().getSchedules();
        int pgTemplateType = protectGroup.getTemplate().getType();
        HashSet<Integer> addtionalType = new HashSet<Integer>();
        for (Schedule schedule : schedules) {
            if (schedule.getProtectedType() == pgTemplateType) continue;
            addtionalType.add(schedule.getProtectedType());
        }
        return addtionalType;
    }

    protected void initialize(TopoBaseContext context) {
        this.logger.debug((Object)"begin to iniitialize");
        ElementBox box = TopoBuildUtil.initializeContext(context);
        box.getLayerBox().getDefaultLayer().setMovable(true);
        box.getLayerBox().getDefaultLayer().setEditable(false);
    }

    private Node setTopoLayout(TopoBaseContext context) {
        Node verticalStyleNodeMajor;
        ProtectGroup protectGroup = context.getProtectGroup();
        if (context.getRootNode() == null) {
            if (context.getRootNode() == null) {
                this.initialize(context);
            }
            verticalStyleNodeMajor = context.getRootNode();
            verticalStyleNodeMajor.setClient("layout", (Object)"topbottom");
        } else {
            String verticalStyleNodeIdMajor = protectGroup.getUuid() + "Major" + "---" + "Style:unvisible";
            verticalStyleNodeMajor = (Node)context.getElementBox().getDataByID((Object)verticalStyleNodeIdMajor);
            if (verticalStyleNodeMajor == null) {
                verticalStyleNodeMajor = TopoServiceUtil.createUnVisibleStorageNode(context, protectGroup.getUuid() + "Major" + "---" + "Style");
                verticalStyleNodeMajor.setClient("layout", (Object)"topbottom");
                context.addChild((IData)context.getRootNode(), (IData)verticalStyleNodeMajor);
            }
        }
        String verticalStyleNodeIdSecTop = protectGroup.getUuid() + "SecondaryTop" + "---" + "Style:unvisible";
        Node verticalStyleNodeSecTop = (Node)context.getElementBox().getDataByID((Object)verticalStyleNodeIdSecTop);
        if (verticalStyleNodeSecTop == null) {
            verticalStyleNodeSecTop = TopoServiceUtil.createUnVisibleStorageNode(context, protectGroup.getUuid() + "SecondaryTop" + "---" + "Style");
            verticalStyleNodeSecTop.setClient("layout", (Object)"leftright");
            context.addChild((IData)verticalStyleNodeMajor, (IData)verticalStyleNodeSecTop);
        }
        String verticalStyleNodeIdSecBottom = protectGroup.getUuid() + "SecondaryBottom" + "---" + "Style:unvisible";
        Node verticalStyleNodeSecBottom = (Node)context.getElementBox().getDataByID((Object)verticalStyleNodeIdSecBottom);
        if (verticalStyleNodeSecBottom == null) {
            verticalStyleNodeSecBottom = TopoServiceUtil.createUnVisibleStorageNode(context, protectGroup.getUuid() + "SecondaryBottom" + "---" + "Style");
            verticalStyleNodeSecBottom.setClient("layout", (Object)"leftright");
            context.addChild((IData)verticalStyleNodeMajor, (IData)verticalStyleNodeSecBottom);
        }
        return verticalStyleNodeMajor;
    }

    private void setVirtualMoreNodeSize(TopoBaseContext context) {
        if (context.getProtectGroup().getPoType() != 10) {
            return;
        }
        try {
            List allDatas = context.getElementBox().getDatas();
            for (Data eachData : allDatas) {
                if (null == eachData.getID() || !String.valueOf(eachData.getID()).contains("subNetwork:more:")) continue;
                ((SubNetwork)eachData).setSize(48.0, 15.0);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("unable to setVirtualMoreNodeSize" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786986L);
        }
    }

    private List<String> getErrorResults(long code) {
        ArrayList<String> results = new ArrayList<String>();
        ITopoResourceManager manager = TopoBaseContext.getTopoResourceManager();
        results.add("error");
        results.add(manager.getText("ism.drm.topo.err.msg.title"));
        results.add(manager.getErrText("lego.err." + code));
        results.add("false");
        results.add("false");
        results.add("--");
        return results;
    }

    private void unbind(String type) {
        this.builders.remove(type);
    }

    static {
        TopoUtil.registerGlobalClientCommonPropties();
        SerializationSettings.registerGlobalClient((String)"protectGroupRelocation", (String)"boolean");
        SerializationSettings.registerGlobalClient((String)"recoveryHostFlag", (String)"boolean");
        SerializationSettings.registerGlobalClient((String)"topoHostName", (String)"string");
        SerializationSettings.registerGlobalClient((String)"siteID", (String)"string");
        SerializationSettings.registerGlobalClient((String)"srcSiteID", (String)"string");
        SerializationSettings.registerGlobalClient((String)"srcSiteName", (String)"string");
        SerializationSettings.registerGlobalClient((String)"topoSiteName", (String)"string");
        SerializationSettings.registerGlobalClient((String)"clusterSn", (String)"string");
        SerializationSettings.registerGlobalClient((String)"isHyperMetro", (String)"boolean");
        SerializationSettings.registerGlobalClient((String)"isHyperMetroSnap", (String)"boolean");
        SerializationSettings.registerGlobalClient((String)"hyperMetroSnapOffset", (String)"number");
        SerializationSettings.registerGlobalClient((String)"transferNode", (String)"true");
    }
}

