/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.topo.utils;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.storage.sdk.model.HyperCloneTargetLun;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.ism.drm.topo.element.PGElement;
import com.huawei.ism.drm.topo.sdk.context.TopoBaseContext;
import com.huawei.ism.drm.topo.sdk.model.Topo;
import com.huawei.ism.drm.topo.sdk.model.TopologyResultVO;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.topology.DataBox;
import com.huawei.topology.ElementBox;
import com.huawei.topology.IData;
import com.huawei.topology.Layer;
import com.huawei.topology.Node;
import com.huawei.topology.XMLSerializer;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.dom4j.Attribute;
import org.dom4j.CDATA;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.dom4j.tree.DefaultCDATA;
import org.dom4j.tree.DefaultElement;
import org.springframework.dao.DataAccessException;
import org.xml.sax.SAXException;

public class TopoBuildUtil {
    public static final Log logger = LogFactory.getInstance(TopoBuildUtil.class);
    public static final String SRC_DEVICE_SN = "srcDeviceSn";
    public static final String TGT_DEVICE_SN = "tgtDeviceSn";
    public static final String TGT_LUN_ID = "tgtLunId";
    public static final String DEV_SN = "devSn";
    public static final String TGT_DEV_SN = "tgtDevSN";

    public static ElementBox initializeContext(TopoBaseContext context) {
        PGElement root = new PGElement(null);
        ElementBox box = context.getElementBox();
        box.setStyle("background.type", (Object)"image");
        box.setStyle("background.image", (Object)"/theme/recoverydirector/images/topo/default.png");
        box.setStyle("background.image.stretch", (Object)"tile");
        context.setRootNode((Node)root);
        context.add((IData)root);
        String linkLayerId = "linkLayer";
        Layer layer = new Layer((Object)linkLayerId);
        box.getLayerBox().add((IData)layer);
        box.getLayerBox().moveTo((IData)layer, 1);
        Layer layer0 = new Layer((Object)"layer0");
        box.getLayerBox().add((IData)layer0);
        box.getLayerBox().moveTo((IData)layer0, 0);
        layer.setEditable(false);
        layer.setMovable(false);
        return box;
    }

    public static List<HyperCloneTargetLun> getTrgLunListFromDB(String srcSN, List<String> trgLunIds) {
        List<Object> listCloneTargetLun = new ArrayList<HyperCloneTargetLun>();
        try {
            HashMap<String, Object> trgProps = new HashMap<String, Object>();
            trgProps.put(DEV_SN, srcSN);
            trgProps.put("id", trgLunIds.toArray());
            listCloneTargetLun = CommonDAOLocator.getMoDao().findMoBy(HyperCloneTargetLun.class, trgProps);
        }
        catch (Exception e) {
            logger.error((Object)("get TargetLuns By devSn And LunID failed" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786962L);
        }
        return listCloneTargetLun;
    }

    public static List<ReplicationTargetLun> getTrgLunListFromDB(String srcSN, String trgSN, List<String> listTrgLunID) {
        List<Object> listReplicationTargetLun = new ArrayList<ReplicationTargetLun>();
        try {
            HashMap<String, Object> trgProps = new HashMap<String, Object>();
            trgProps.put(TGT_DEV_SN, trgSN);
            trgProps.put(DEV_SN, srcSN);
            trgProps.put(TGT_LUN_ID, listTrgLunID.toArray());
            listReplicationTargetLun = CommonDAOLocator.getMoDao().findMoBy(ReplicationTargetLun.class, trgProps);
        }
        catch (Exception e) {
            logger.error((Object)("get TargetLuns By devSn And LunID failed" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786962L);
        }
        return listReplicationTargetLun;
    }

    public static Map<String, Object> buildUriVariables(String srcSN, String trgSN, List<String> lunIDs) {
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put(SRC_DEVICE_SN, srcSN);
        uriVariables.put(TGT_DEVICE_SN, trgSN);
        StringBuilder tgtLunIds = new StringBuilder();
        for (String lunID : lunIDs) {
            tgtLunIds.append(lunID).append(';');
        }
        String tgtLunIdStr = tgtLunIds.toString();
        uriVariables.put(TGT_LUN_ID, tgtLunIdStr.substring(0, tgtLunIdStr.length() - 1));
        return uriVariables;
    }

    public static String getLayoutXml(String topoIndexId) {
        String info = null;
        try {
            Topo topoInfo = (Topo)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(Topo.class, (Serializable)((Object)topoIndexId));
            if (topoInfo != null) {
                info = topoInfo.getTopoDetail();
            }
        }
        catch (DataAccessException ex) {
            logger.error((Object)"unable to get sites", (Throwable)ex, 90160758786873L);
        }
        return info;
    }

    public static TopologyResultVO createInvalidResult(String message) {
        return TopologyResultVO.builder().isValid(Boolean.valueOf(false)).message(message).build();
    }

    public static TopologyResultVO createEmptyResult() {
        return TopologyResultVO.builder().box(TopoBuildUtil.parseXml2Json(new XMLSerializer((DataBox)new ElementBox()).serialize())).legend(TopoBuildUtil.parseXml2Json(new XMLSerializer((DataBox)new ElementBox()).serialize())).build();
    }

    public static JSONObject parseXml2Json(String xml) {
        JSONObject jsonResult = new JSONObject();
        if (VerifyUtil.isEmpty((String)xml)) {
            logger.warn((Object)"Parse xml to json failed, target xml content is empty");
            return jsonResult;
        }
        try {
            SAXReader reader = new SAXReader();
            CommonUtil.setSecurityFeatures((SAXReader)reader);
            Document document = reader.read((InputStream)new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8)));
            Element root = document.getRootElement();
            List elements = root.elements();
            for (Element element : elements) {
                String nodeName = element.getName();
                if ("layer".equals(nodeName)) {
                    TopoBuildUtil.buildLayer(jsonResult, element);
                    continue;
                }
                if ("data".equals(nodeName)) {
                    TopoBuildUtil.buildData(jsonResult, element);
                    continue;
                }
                if ("p".equals(nodeName)) {
                    TopoBuildUtil.buildProperty(jsonResult, element);
                    continue;
                }
                if ("c".equals(nodeName)) {
                    TopoBuildUtil.buildClientOrStyle(jsonResult, element, "client");
                    continue;
                }
                if (!"s".equals(nodeName)) continue;
                TopoBuildUtil.buildClientOrStyle(jsonResult, element, "style");
            }
        }
        catch (DocumentException | SAXException e) {
            logger.error((Object)"Parse xml to json failed, target xml content is invalid", e);
        }
        return jsonResult;
    }

    private static void buildData(JSONObject jsonResult, Element element) {
        List attributes = element.attributes();
        JSONObject data = new JSONObject();
        for (Object attribute : attributes) {
            data.put((Object)attribute.getName(), (Object)attribute.getValue());
        }
        List content = element.content();
        for (org.dom4j.Node node : content) {
            if (!(node instanceof DefaultElement)) continue;
            DefaultElement child = (DefaultElement)node;
            String nodeName = node.getName();
            if ("p".equals(nodeName)) {
                TopoBuildUtil.buildProperty(data, (Element)child);
                continue;
            }
            if ("c".equals(nodeName)) {
                TopoBuildUtil.buildClientOrStyle(data, (Element)child, "client");
                continue;
            }
            if ("s".equals(nodeName)) {
                TopoBuildUtil.buildClientOrStyle(data, (Element)child, "style");
                continue;
            }
            logger.warn((Object)"Build data canceled, node is invalid, node name is: %s", new Object[]{nodeName});
        }
        JSONArray dataList = TopoBuildUtil.getData(jsonResult);
        dataList.add((Object)data);
    }

    private static void buildProperty(JSONObject data, Element child) {
        List dataContentAttrs = child.attributes();
        if (TopoBuildUtil.buildPropertyParentAndRef(dataContentAttrs, data)) {
            return;
        }
        if (TopoBuildUtil.buildPropertyLocation(dataContentAttrs, data)) {
            return;
        }
        JSONObject dataContent = TopoBuildUtil.getDataContent(data, "property");
        if (TopoBuildUtil.buildPropertyLink(dataContentAttrs, dataContent, "fromNode")) {
            return;
        }
        if (TopoBuildUtil.buildPropertyLink(dataContentAttrs, dataContent, "toNode")) {
            return;
        }
        List childContents = child.content();
        if (CollectionUtils.isEmpty((Collection)childContents) || VerifyUtil.isEmpty((Collection)dataContentAttrs)) {
            return;
        }
        org.dom4j.Node childContent = (org.dom4j.Node)childContents.get(0);
        Optional<org.dom4j.Node> cDataOpt = childContents.stream().filter(e -> e instanceof DefaultCDATA).findAny();
        if (cDataOpt.isPresent()) {
            dataContent.put((Object)((Attribute)dataContentAttrs.get(0)).getValue(), (Object)cDataOpt.get().getText());
        } else {
            dataContent.put((Object)((Attribute)dataContentAttrs.get(0)).getValue(), (Object)childContent.getText());
        }
    }

    private static boolean buildPropertyLink(List<Attribute> dataContentAttrs, JSONObject data, String type) {
        Optional<Attribute> linkOpt = dataContentAttrs.stream().filter(e -> type.equals(e.getValue())).findAny();
        if (linkOpt.isPresent()) {
            Optional<Attribute> refOpt = dataContentAttrs.stream().filter(e -> "ref".equals(e.getName())).findAny();
            refOpt.ifPresent(attribute -> data.put((Object)type, (Object)attribute.getValue()));
            return true;
        }
        return false;
    }

    private static boolean buildPropertyLocation(List<Attribute> dataContentAttrs, JSONObject data) {
        Optional<Attribute> locationOpt = dataContentAttrs.stream().filter(e -> "location".equals(e.getValue())).findAny();
        if (locationOpt.isPresent()) {
            JSONObject location = new JSONObject();
            Optional<Attribute> xOpt = dataContentAttrs.stream().filter(e -> "x".equals(e.getName())).findAny();
            xOpt.ifPresent(attribute -> location.put((Object)"x", (Object)attribute.getValue()));
            Optional<Attribute> yOpt = dataContentAttrs.stream().filter(e -> "y".equals(e.getName())).findAny();
            yOpt.ifPresent(attribute -> location.put((Object)"y", (Object)attribute.getValue()));
            data.put((Object)"location", (Object)location);
            return true;
        }
        return false;
    }

    private static boolean buildPropertyParentAndRef(List<Attribute> dataContentAttrs, JSONObject data) {
        Optional<Attribute> parentOpt = dataContentAttrs.stream().filter(e -> "parent".equals(e.getValue())).findAny();
        if (parentOpt.isPresent()) {
            Optional<Attribute> refOpt = dataContentAttrs.stream().filter(e -> "ref".equals(e.getName())).findAny();
            refOpt.ifPresent(attribute -> data.put((Object)"parent", (Object)attribute.getValue()));
            return true;
        }
        return false;
    }

    private static void buildClientOrStyle(JSONObject data, Element child, String type) {
        JSONObject dataContent = TopoBuildUtil.getDataContent(data, type);
        List dataContentAttrs = child.attributes();
        List childContents = child.content();
        if (CollectionUtils.isEmpty((Collection)childContents) || VerifyUtil.isEmpty((Collection)dataContentAttrs)) {
            return;
        }
        String attr = ((Attribute)dataContentAttrs.get(0)).getValue();
        if ("link.color".equals(attr) || "label.color".equals(attr)) {
            dataContent.put((Object)attr, (Object)TopoBuildUtil.transColor(((org.dom4j.Node)childContents.get(0)).getText()));
            return;
        }
        Optional<org.dom4j.Node> defaultElementOpt = childContents.stream().filter(e -> e instanceof DefaultElement).findAny();
        if (defaultElementOpt.isPresent()) {
            dataContent.put((Object)attr, (Object)defaultElementOpt.get().getText());
            return;
        }
        Optional<org.dom4j.Node> cDataOpt = childContents.stream().filter(e -> e instanceof CDATA).findAny();
        if (cDataOpt.isPresent()) {
            dataContent.put((Object)attr, (Object)cDataOpt.get().getText());
            return;
        }
        dataContent.put((Object)attr, (Object)((org.dom4j.Node)childContents.get(0)).getText());
    }

    private static String transColor(String color) {
        if (VerifyUtil.isEmpty((String)color)) {
            return "";
        }
        if (color.startsWith("0x")) {
            return color.replace("0x", "#");
        }
        if (color.startsWith("#ff") && color.length() > 7) {
            return color.replace("#ff", "#");
        }
        return "";
    }

    private static void buildLayer(JSONObject data, Element child) {
        JSONObject dataContent = TopoBuildUtil.getDataContent(data, "layer");
        List dataContentAttrs = child.attributes();
        for (Attribute attr : dataContentAttrs) {
            dataContent.put((Object)attr.getName(), (Object)attr.getValue());
        }
    }

    private static JSONArray getData(JSONObject root) {
        Object data;
        if (root.containsKey((Object)"data") && (data = root.get("data")) instanceof JSONArray) {
            return (JSONArray)data;
        }
        JSONArray dataList = new JSONArray();
        root.put((Object)"data", (Object)dataList);
        return dataList;
    }

    private static JSONObject getDataContent(JSONObject data, String contentKey) {
        Object content;
        if (data.containsKey((Object)contentKey) && (content = data.get(contentKey)) instanceof JSONObject) {
            return (JSONObject)content;
        }
        JSONObject dataContent = new JSONObject();
        data.put((Object)contentKey, (Object)dataContent);
        return dataContent;
    }
}

