#!/bin/bash
SCRIPTDIR=$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)
LOG_FILE_NAME=$SCRIPTDIR/logs/chgHaAlarmAuth.log
JRE=$(dirname "${SCRIPTDIR}")/jre6.0.18/bin/java
source "$SCRIPTDIR/commfunc.sh"
PGUSER=`getInstallInfo | grep DB_MANAGE_USER= | awk -F= '{print $2}'`
PGDATA=`getInstallInfo | grep DB_FILE_PATH= | awk -F= '{print $2}'`
PGCTL=${SCRIPTDIR%/Runtime*}/Runtime/gs/bin/control.sh
PGCTL="sudo -u GaussDB -S ${PGCTL}"
PORT_INI_PATH="${COMM_BCMANAGER_PATH}/Runtime/bin/config/conf/port.ini"
RUNTIME_PATH=${SCRIPTDIR%/bin*}
change_user "$@"

echo -e "\n\033[31;1mWarning: Running this script will change the HA alarm authentication information. \
Ensure that the new authentication password is the same as user SyncAdmin's password of eReplication. \033[0m\n"

function changeAuth() {
    local listen_ip=$(getKeyValueFromFile "${RUNTIME_PATH}/LegoRuntime/conf/lego.properties" "floatIp")
    if [ -z "$listen_ip" ];then
        listen_ip=$(getKeyValueFromFile "${RUNTIME_PATH}/LegoRuntime/conf/lego.properties" "ip")
    fi
    
    local -r port=$(< "$PORT_INI_PATH" grep -v '^#' | grep https.port |awk -F = '{print $2}')
    if [ -z "$listen_ip" ] || [ -z "$port" ];then
        echo -e "\nOperation failed.\n"
        Log "Cannot get ip or port config."
        exit 1
    fi
    read -p "Are you sure you want to continue (y/n): " isSure
    echo "$isSure" | grep -Ew "Y|y|n|N" &>/dev/null
    if [ $? != 0 ];then
        changeAuth
    fi
    echo "$isSure" | grep -Ew "n|N" &>/dev/null
    if [ $? == 0 ];then
        exit 1
    fi

    local -r status=$($PGCTL status "$PGUSER" "$PGDATA" | grep -w "PID")
    if [ -z "$status" ];then
        Log "[INFO] the db is not running, start it."
        $PGCTL start "$PGUSER" "$PGDATA" 1>>"$LOG_FILE_NAME" 2>>"$LOG_FILE_NAME"
        isStarted=true
        sleep 5
    fi

    declare -i iRet=0
    while [ $iRet -lt 3  ]
    do
        iRet=$((iRet+1))
        stty -echo
        read -s -p "Please enter user SyncAdmin's old password: " oldPwd
        echo
        read -s -p "Please enter user SyncAdmin's new password: " newPwd
        echo
        read -s -p "Please confirm user SyncAdmin's new password: " confirmPwd
        stty echo
        echo -e "${oldPwd}\n${newPwd}\n${confirmPwd}" | "$JRE" -cp "$ALL_CLASS_PATH" com.huawei.alarm.auth.ChangeAuth change "$listen_ip" "$port" 1>>"$LOG_FILE_NAME" 2>&1;iReturn=$?
        if [ $iReturn = 0 ];then
            echo -e "\nOperation succeeded.\n"
            Log "Operation succeeded."
            if [ -n "$isStarted" ] && [ "$isStarted" = "true" ];then
                $PGCTL stop "$PGUSER" "$PGDATA" 1>>"$LOG_FILE_NAME" 2>>"$LOG_FILE_NAME"
            fi
            exit 0
        elif [ $iReturn = 2 ];then
            echo -e "\nIncorrect password. Please retry.\n"
            Log "Incorrect password. Please retry."
        elif [ $iReturn = 4 ];then
            echo -e "\nFailed to change password. Please retry.\n"
            Log "Failed to change password. Please retry."
        elif [ $iReturn = 5 ];then
            echo -e "\nThe two passwords do not match. Please retry.\n"
            Log "The two passwords do not match. Please retry."
        else
            echo -e "\nOperation failed.\n"
            Log "Operation failed."
        fi
    done
    echo -e "\nThree consecutive invalid password attempts! Please obtain the correct password and retry.\n"
    if [ -n "$isStarted" ] && [ "$isStarted" = "true" ];then
        $PGCTL stop "$PGUSER" "$PGDATA" 1>>"$LOG_FILE_NAME" 2>>"$LOG_FILE_NAME"
    fi
    exit 1
}

changeAuth
