/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.array.transition;

import com.huawei.ism.array.sdk.model.ArrayUnit;
import com.huawei.ism.base.sdk.model.HSObject;
import com.huawei.ism.cbb.proxy.service.ITransition;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.cbb.util.unit.CapabilityUnitType;
import com.huawei.ism.common.bean.HealthState;
import com.huawei.ism.common.bean.ProductModelType;
import com.huawei.ism.common.entity.State;
import com.huawei.ism.common.entity.TypeEnum;
import com.huawei.ism.common.entity.components.Array;
import com.huawei.ism.common.entity.components.Controller;
import com.huawei.ism.common.entity.components.ControllerChassis;
import com.huawei.ism.common.entity.components.Drive;
import com.huawei.ism.common.entity.components.ExpandedLun;
import com.huawei.ism.common.entity.components.Lun;
import java.util.Collection;

public class ArrayTransition
implements ITransition {
    @Override
    public String getSmisType() {
        return "ISM_ComputerSystem";
    }

    @Override
    public Class<?> getV1Type() {
        return Array.class;
    }

    @Override
    public Class<?> getV2Type() {
        return ArrayUnit.class;
    }

    @Override
    public Object convertToV1(HSObject ismObj) {
        Array array = null;
        if (ismObj instanceof ArrayUnit) {
            ArrayUnit device = (ArrayUnit)ismObj;
            String deviceType = "";
            String deviceName = device.getName();
            String arrayId = device.getDevSn();
            array = new Array(deviceType, arrayId);
            array.setComponentName(deviceName);
        }
        return array;
    }

    @Override
    public HSObject convertToV2(Object v1Obj) {
        ArrayUnit storageArray = null;
        if (v1Obj instanceof Array) {
            Array array = (Array)v1Obj;
            String linkIp = array.getConnectionIP();
            String devSn = array.getDeviceID();
            String devLocation = array.getAddress();
            String devName = array.getName();
            String version = array.getProductVersion();
            storageArray = new ArrayUnit();
            storageArray.setLinkIp(linkIp);
            storageArray.setIpAddress(linkIp);
            storageArray.setDevSn(devSn);
            storageArray.setPosition(devLocation);
            storageArray.setName(devName);
            storageArray.setUuid(array.getUUID());
            storageArray.setMainType("ism.deviceType.storage.mainType");
            ProductModelType modelType = array.getProductModelType();
            if (modelType == null) {
                modelType = ProductModelType.UNKNOW;
            }
            storageArray.setProductModel(modelType.name());
            storageArray.setSubType(modelType.toString());
            storageArray.setProductVersion(version);
            int totalCapacity = this.getArrayCapacity(array);
            storageArray.setTotalCapacity(Double.valueOf(totalCapacity));
            storageArray.setUsedCapacity(Double.valueOf(totalCapacity - array.getRemainCapacity()));
            storageArray.setTotalCapacityUnit(CapabilityUnitType.GB.name());
            storageArray.setUsedCapacityUnit(CapabilityUnitType.GB.name());
            this.calculateLunCap(storageArray, array);
            int status = 0;
            State.SystemMode mode = array.getSystemMode();
            if (mode != null && (mode.equals((Object)State.SystemMode.SM_SYSTEM_DOUBLE_CONTROL_WITH_FAULT) || mode.equals((Object)State.SystemMode.SM_SYSTEM_SINGLE_MODE_WITH_FAULT))) {
                status = 2;
            }
            storageArray.setStatus(Integer.valueOf(status));
            this.setArrayWorkModel(storageArray, array);
            ControllerChassis chassis = array.getControllerChassis();
            String devIPs = this.getIpsFromChassis(chassis);
            if (null != devIPs) {
                storageArray.setManageIps(devIPs);
            }
            storageArray.setTopMoUuid(storageArray.getUuid());
            storageArray.setIsTopMo(Boolean.valueOf(false));
            storageArray.setManaged(Boolean.valueOf(true));
            storageArray.setWwn(array.getWWN());
        }
        return storageArray;
    }

    private void setArrayWorkModel(ArrayUnit storageArray, Array array) {
        HealthState arrayHealth = array.getHealthState();
        if (null != arrayHealth) {
            if (HealthState.SYS_STATUS_NORMALMODE.equals((Object)arrayHealth) || HealthState.ILLEGAL.equals((Object)arrayHealth)) {
                storageArray.setModel(Integer.valueOf(0));
            } else {
                storageArray.setModel(Integer.valueOf(1));
            }
        }
    }

    private void calculateLunCap(ArrayUnit storageArray, Array array) {
        double totalCap = 0.0;
        double mappedCap = 0.0;
        Collection luns = array.getAllLun();
        for (Lun lun : luns) {
            if (lun.isMapped()) {
                mappedCap += lun.getTotalSize();
            }
            if (lun instanceof ExpandedLun) continue;
            totalCap += lun.getTotalSize();
        }
        storageArray.setTotalLunCap(Double.valueOf(totalCap));
        storageArray.setTotalLunCapUnit(CapabilityUnitType.MB.name());
        storageArray.setMappedLunCap(Double.valueOf(mappedCap));
        storageArray.setMappedLunCapUnit(CapabilityUnitType.MB.name());
    }

    protected String getIpsFromChassis(ControllerChassis chassis) {
        Collection controllers;
        String devIPs = null;
        if (null != chassis && null != (controllers = chassis.getControllers()) && !controllers.isEmpty()) {
            devIPs = this.buildDevIPsByControllers(controllers);
        }
        return devIPs;
    }

    private String buildDevIPsByControllers(Collection<Controller> controllers) {
        String devIPs = null;
        StringBuilder buffer = new StringBuilder();
        for (Controller controller : controllers) {
            Collection ips = controller.getIps();
            if (null == ips || ips.isEmpty()) continue;
            for (String ip : ips) {
                buffer.append(',').append(ip);
            }
        }
        if (0 < buffer.length()) {
            devIPs = buffer.substring(1);
        }
        return devIPs;
    }

    private int getArrayCapacity(Array array) {
        int totalSize = 0;
        Collection disks = array.getDrives();
        if (VerifyUtil.isEmpty((Collection)disks)) {
            return totalSize;
        }
        for (Drive drive : disks) {
            if ((drive.getHealthState() == HealthState.UNKNOWN || TypeEnum.DiskLogicalType.Free != drive.getDiskType()) && TypeEnum.DiskLogicalType.Free == drive.getDiskType()) continue;
            int oneDiskSize = drive.getSize();
            if (oneDiskSize < 0) {
                oneDiskSize = 0;
            }
            totalSize += oneDiskSize;
        }
        return totalSize;
    }
}

