/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.array.transition;

import com.huawei.ism.base.port.sdk.model.FcHostPort;
import com.huawei.ism.base.port.sdk.model.IscsiHostPort;
import com.huawei.ism.base.port.sdk.model.ManagementPort;
import com.huawei.ism.base.port.sdk.model.Port;
import com.huawei.ism.base.port.sdk.model.SasHostPort;
import com.huawei.ism.base.sdk.model.HSObject;
import com.huawei.ism.cbb.discover.array.V1HealthStateMapper;
import com.huawei.ism.cbb.discover.array.V1RunningStateMapper;
import com.huawei.ism.cbb.proxy.service.ITransition;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.common.entity.TypeEnum;
import com.huawei.ism.common.entity.components.EthernetPort;
import com.huawei.ism.common.entity.components.FcPort;
import com.huawei.ism.common.entity.components.IscsiPort;
import com.huawei.ism.common.entity.components.SasPort;
import com.huawei.ism.common.entity.components.TargetFcPort;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Locale;

public class FrontPortTransition
implements ITransition {
    private final Log logger = LogFactory.getInstance((Object)this);

    @Override
    public Object convertToV1(HSObject ismObj) {
        return null;
    }

    @Override
    public HSObject convertToV2(Object v1Obj) {
        FcHostPort iport = null;
        if (v1Obj instanceof FcPort) {
            FcPort port = (FcPort)v1Obj;
            iport = this.parseFcHostPort(port);
        } else if (v1Obj instanceof SasPort) {
            SasPort port = (SasPort)v1Obj;
            iport = this.parseSasPort(port);
        } else if (v1Obj instanceof IscsiPort) {
            IscsiPort port = (IscsiPort)v1Obj;
            iport = this.parseIscsiPort(port);
        } else if (v1Obj instanceof com.huawei.ism.common.entity.components.ManagementPort) {
            com.huawei.ism.common.entity.components.ManagementPort port = (com.huawei.ism.common.entity.components.ManagementPort)v1Obj;
            iport = this.parseManagementPort(port);
        } else if (v1Obj instanceof EthernetPort) {
            EthernetPort port = (EthernetPort)v1Obj;
            iport = this.parseEthernetPort(port);
        }
        return iport;
    }

    private ManagementPort parseManagementPort(com.huawei.ism.common.entity.components.ManagementPort port) {
        Integer healthStatus;
        ManagementPort ismPort = new ManagementPort();
        ismPort.setName(port.getName());
        Integer portType = NumberUtil.convertToInteger((Object)String.valueOf(port.getPortPhyicalType().getValue()));
        ismPort.setPortType(portType);
        String mac = port.getMac();
        if (mac != null) {
            mac = mac.replaceAll("\\:", "");
            mac = this.formatMac(mac);
            mac = mac.toLowerCase(Locale.ENGLISH);
        }
        ismPort.setMac(mac);
        ismPort.setUuid(port.getUUID());
        ismPort.setNeSN(port.getDeviceID());
        ismPort.setNetmask(port.getMasking());
        ismPort.setSpeed(Long.valueOf(port.getSpeed()));
        ismPort.setIpAddress(port.getIP());
        ismPort.setIpv6Address(port.getIPV6());
        ismPort.setControllerId(String.valueOf(port.getControllerId()));
        ismPort.setBoardId(String.valueOf(port.getBoardID()));
        Object bondName = port.getExtendArg("BondPortName");
        if (bondName != null) {
            ismPort.setBondName(String.valueOf(bondName));
        }
        if (null == (healthStatus = V1HealthStateMapper.V1_PORT_HEALTH_STATE.get(port.getHealthState()))) {
            healthStatus = 4;
        }
        ismPort.setStatus(healthStatus);
        ismPort.setHealthStatus(healthStatus);
        Integer runningStatus = V1RunningStateMapper.V1_PORT_RUNNING_STATE.get(port.getRunningState());
        if (null == runningStatus) {
            runningStatus = 33;
        }
        ismPort.setRunningStatus(runningStatus);
        ismPort.setConnectStatus(runningStatus);
        ismPort.setPortId(Long.valueOf(port.getPortID()));
        return ismPort;
    }

    private IscsiHostPort parseIscsiPort(IscsiPort port) {
        Integer healthStatus;
        IscsiHostPort ismPort = new IscsiHostPort();
        ismPort.setName(null == port.getPortDescID() ? "--" : port.getPortDescID());
        Integer portType = NumberUtil.convertToInteger((Object)String.valueOf(port.getPortPhyicalType().getValue()));
        ismPort.setPortType(portType);
        String mac = port.getPortMac();
        if (mac != null) {
            mac = mac.replaceAll("\\:", "");
            mac = this.formatMac(mac);
            mac = mac.toLowerCase(Locale.ENGLISH);
        }
        ismPort.setMac(mac);
        ismPort.setUuid(port.getUUID());
        ismPort.setIpAddress(port.getIP());
        ismPort.setNeSN(port.getDeviceID());
        ismPort.setBoardId(String.valueOf(port.getBoardID()));
        ismPort.setGateway(port.getGateway());
        ismPort.setMask(port.getMasking());
        ismPort.setSpeed(Long.valueOf(port.getSpeed()));
        ismPort.setIpv6Address(port.getIpv6Address());
        ismPort.setIpv6Profix(port.getIpv6Profix());
        ismPort.setControllerId(String.valueOf(port.getControllerId()));
        ismPort.setIscsiName(port.getIscsiName());
        Object bondName = port.getExtendArg("BondPortName");
        if (bondName != null) {
            ismPort.setBondName(String.valueOf(bondName));
        }
        if (null == (healthStatus = V1HealthStateMapper.V1_PORT_HEALTH_STATE.get(port.getHealthState()))) {
            healthStatus = 4;
        }
        ismPort.setStatus(healthStatus);
        ismPort.setHealthStatus(healthStatus);
        Integer runningStatus = V1RunningStateMapper.V1_PORT_RUNNING_STATE.get(port.getRunningState());
        if (null == runningStatus) {
            runningStatus = 33;
        }
        ismPort.setRunningStatus(runningStatus);
        ismPort.setConnectStatus(runningStatus);
        ismPort.setPortId(Long.valueOf(port.getPortID()));
        return ismPort;
    }

    private SasHostPort parseSasPort(SasPort port) {
        SasHostPort ismPort = new SasHostPort();
        ismPort.setName(null == port.getPortDescID() ? "--" : port.getPortDescID());
        Integer portType = NumberUtil.convertToInteger((Object)String.valueOf(port.getPortPhyicalType().getValue()));
        ismPort.setPortType(portType);
        ismPort.setWwn(port.getWWN());
        ismPort.setUuid(port.getUUID());
        ismPort.setNeSN(port.getDeviceID());
        ismPort.setBoardId(String.valueOf(port.getBoardID()));
        ismPort.setSpeed(Long.valueOf(port.getSpeed()));
        ismPort.setControllerId(String.valueOf(port.getControllerId()));
        Integer healthStatus = V1HealthStateMapper.V1_PORT_HEALTH_STATE.get(port.getHealthState());
        if (null == healthStatus) {
            healthStatus = 4;
        }
        ismPort.setStatus(healthStatus);
        ismPort.setHealthStatus(healthStatus);
        Integer runningStatus = V1RunningStateMapper.V1_PORT_RUNNING_STATE.get(port.getRunningState());
        if (null == runningStatus) {
            runningStatus = 33;
        }
        ismPort.setRunningStatus(runningStatus);
        ismPort.setConnectStatus(runningStatus);
        ismPort.setPortId(Long.valueOf(port.getPortID()));
        return ismPort;
    }

    private FcHostPort parseFcHostPort(FcPort port) {
        FcHostPort ismPort = new FcHostPort();
        ismPort.setName(null == port.getPortDescID() ? "--" : port.getPortDescID());
        Integer portType = NumberUtil.convertToInteger((Object)String.valueOf(port.getPortPhyicalType().getValue()));
        ismPort.setPortType(portType);
        ismPort.setWwn(port.getFCSwitchWwn());
        ismPort.setNeSN(port.getDeviceID());
        ismPort.setUuid(port.getUUID());
        ismPort.setBoardId(String.valueOf(port.getBoardID()));
        ismPort.setSpeed(Long.valueOf(port.getSpeed()));
        ismPort.setControllerId(String.valueOf(port.getControllerId()));
        Integer healthStatus = V1HealthStateMapper.V1_PORT_HEALTH_STATE.get(port.getHealthState());
        if (healthStatus == null) {
            this.logger.error((Object)("Unknown controller health state : " + port.getHealthState()), 90160777658643L);
            healthStatus = 4;
        }
        ismPort.setStatus(healthStatus);
        ismPort.setHealthStatus(healthStatus);
        Integer runningStatus = V1RunningStateMapper.V1_PORT_RUNNING_STATE.get(port.getRunningState());
        if (null == runningStatus) {
            runningStatus = 33;
        }
        ismPort.setRunningStatus(runningStatus);
        ismPort.setConnectStatus(runningStatus);
        ismPort.setPortId(Long.valueOf(port.getPortID()));
        if (port instanceof TargetFcPort) {
            TypeEnum.FCModeType fcPortMode = ((TargetFcPort)port).getFcPortMode();
            ismPort.setFcPortMode(Integer.valueOf(fcPortMode.getValue()));
        }
        return ismPort;
    }

    private com.huawei.ism.base.port.sdk.model.EthernetPort parseEthernetPort(EthernetPort port) {
        com.huawei.ism.base.port.sdk.model.EthernetPort ismPort = new com.huawei.ism.base.port.sdk.model.EthernetPort();
        ismPort.setName(port.getName());
        Integer portType = NumberUtil.convertToInteger((Object)String.valueOf(port.getPortPhyicalType().getValue()));
        ismPort.setPortType(portType);
        String mac = port.getMac();
        if (mac != null) {
            mac = mac.replaceAll("\\:", "");
            mac = this.formatMac(mac);
            mac = mac.toLowerCase(Locale.ENGLISH);
        }
        ismPort.setMac(mac);
        ismPort.setUuid(port.getUUID());
        ismPort.setNeSN(port.getDeviceID());
        ismPort.setNetmask(port.getMasking());
        ismPort.setSpeed(Long.valueOf(port.getSpeed()));
        ismPort.setIpAddress(port.getIP());
        ismPort.setIpv6Address(port.getIPV6());
        Integer healthStatus = V1HealthStateMapper.V1_PORT_HEALTH_STATE.get(port.getHealthState());
        if (null == healthStatus) {
            healthStatus = 4;
        }
        ismPort.setStatus(healthStatus);
        ismPort.setHealthStatus(healthStatus);
        Integer runningStatus = V1RunningStateMapper.V1_PORT_RUNNING_STATE.get(port.getRunningState());
        if (null == runningStatus) {
            runningStatus = 33;
        }
        ismPort.setRunningStatus(runningStatus);
        ismPort.setConnectStatus(runningStatus);
        ismPort.setPortId(Long.valueOf(port.getPortID()));
        return ismPort;
    }

    @Override
    public String getSmisType() {
        return "CIM_NetworkPort";
    }

    @Override
    public Class<?> getV1Type() {
        return com.huawei.ism.common.entity.components.Port.class;
    }

    @Override
    public Class<?> getV2Type() {
        return Port.class;
    }

    private String formatMac(String mac) {
        if (null == mac || "--".equals(mac) || mac.length() >= 12) {
            return mac;
        }
        StringBuilder sbMac = new StringBuilder(mac);
        int len = 12 - mac.length();
        for (int i = 0; i < len; ++i) {
            sbMac.insert(0, "0");
        }
        return sbMac.toString();
    }
}

