/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.commons.process;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.cbb.base.util.AlarmUtil;
import com.huawei.ism.cbb.discover.commons.process.BaseAntiBlackmailProcessor;
import com.huawei.ism.cbb.discover.framework.AbstractContext;
import com.huawei.ism.cbb.discover.framework.IProcessor;
import com.huawei.ism.cbb.discover.sdk.service.INeMgrProtocolExtendService;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnection;
import com.huawei.ism.cbb.proxy.util.DiscoverExUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import java.util.Optional;

public class AntiBlackmailPingProcessor
extends BaseAntiBlackmailProcessor
implements IProcessor {
    private final Log LOGGER = LogFactory.getInstance((Object)this);

    public boolean process(AbstractContext context) {
        if (this.checkParam(context)) {
            this.connect(context);
        }
        return true;
    }

    public void postProcess(AbstractContext context) {
        this.LOGGER.info((Object)"Execute the post method of AntiBlackmailPingProcessor.");
    }

    public void clean(AbstractContext context) {
        this.LOGGER.info((Object)"Execute the clean method of AntiBlackmailPingProcessor.");
    }

    private void connect(AbstractContext context) {
        Optional<RestConnection> restConnection = this.getOrBuildConnection(context);
        NetworkEntity storageArray = (NetworkEntity)context.getAttribute("StorageDevice", NetworkEntity.class);
        String platformType = this.getPlatformType(context).get();
        if (!restConnection.isPresent()) {
            this.LOGGER.error((Object)"Get ProtectManager connection failed, dev sn: %s", new Object[]{storageArray.getSn()});
            this.dealFailedPing(context, platformType);
        } else {
            this.processStatus(storageArray, 0, platformType);
        }
    }

    private void dealFailedPing(AbstractContext context, String platformType) {
        NetworkEntity storageArray = (NetworkEntity)context.getAttribute("StorageDevice", NetworkEntity.class);
        this.processStatus(storageArray, -1, platformType);
        if (context.getAttributeKeys().contains("protectManagerPasswordError")) {
            NeMgrProtocolExtend protocolExtend = (NeMgrProtocolExtend)context.getAttribute("NeMgrProtocolExtend", NeMgrProtocolExtend.class);
            protocolExtend.getExtendParams().put("protectManagerPasswordError", Boolean.TRUE.toString());
            ((INeMgrProtocolExtendService)ServiceLocator.getInstance().getService(INeMgrProtocolExtendService.class)).save(protocolExtend);
        }
    }

    private void processStatus(NetworkEntity ne, int status, String platformType) {
        Integer oldStatus = ne.getDevStatus();
        if (VerifyUtil.isEmpty((Object)oldStatus) || oldStatus == status) {
            return;
        }
        this.LOGGER.info((Object)"Process status, ne=%s, oldStatus=%s, newStatus=%s", new Object[]{ne, oldStatus, status});
        if (status == -1) {
            this.LOGGER.error((Object)"Alarm : The ProtectManager\u2018s status has changed from online to offline! dev sn: %s.", new Object[]{ne.getSn()});
            String[] alarmParams = new String[]{ne.getName(), ne.getLinkIp(), ne.getUuid() + platformType, platformType};
            AlarmUtil.sendNetworkEntityAlarm((String)"0x000803220005", (String)ne.getLinkIp(), (String)String.valueOf(ne.getMoId()), (FaultEnum.AlarmSeverity)FaultEnum.AlarmSeverity.CRITICAL, (String[])alarmParams);
        } else {
            this.LOGGER.info((Object)"The device's status alarm has restored, sn=%s, uuid=%s.", new Object[]{ne.getSn(), ne.getUuid()});
            AlarmUtil.restoreAlarm((String)"0x000803220005", (String[])new String[]{ne.getUuid() + platformType});
            AlarmUtil.restoreAlarm((String)"0x3230064", (String[])new String[]{ne.getSn()});
        }
        DiscoverExUtil.updateOceanProtectStatus(ne, status);
    }
}

