/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.commons.process;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.cbb.base.util.AlarmUtil;
import com.huawei.ism.cbb.discover.commons.process.BaseAntiBlackmailProcessor;
import com.huawei.ism.cbb.discover.framework.AbstractContext;
import com.huawei.ism.cbb.discover.framework.IProcessor;
import com.huawei.ism.cbb.discover.sdk.service.INeMgrProtocolExtendService;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnection;
import com.huawei.ism.cbb.proxy.util.DiscoverExUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.Map;
import java.util.Optional;

public class DiscoverAntiBlackmailAppProcessor
extends BaseAntiBlackmailProcessor
implements IProcessor {
    private final Log LOGGER = LogFactory.getInstance((Object)this);

    public boolean process(AbstractContext context) {
        try {
            if (this.checkParam(context)) {
                this.discoverAntiBlackmailApp(context);
            }
        }
        catch (Exception e) {
            this.LOGGER.error((Object)"Discover or refresh protectManager error, error msg: %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        }
        return true;
    }

    public void postProcess(AbstractContext context) {
    }

    public void clean(AbstractContext context) {
    }

    private void discoverAntiBlackmailApp(AbstractContext context) {
        NetworkEntity storageArray = (NetworkEntity)context.getAttribute("StorageArray", NetworkEntity.class);
        this.LOGGER.info((Object)"Start to discover antiBlackmail platform, dev sn: %s", new Object[]{storageArray.getSn()});
        Optional<RestConnection> restConnection = this.getOrBuildConnection(context);
        NeMgrProtocolExtend protocolExtend = (NeMgrProtocolExtend)context.getAttribute("NeMgrProtocolExtend", NeMgrProtocolExtend.class);
        if (!restConnection.isPresent()) {
            this.dealFailedDiscovery(context, storageArray, protocolExtend);
            return;
        }
        this.sendScanResourceMessage(context);
        DiscoverExUtil.updateOceanProtectStatus(storageArray, 0);
        AlarmUtil.restoreAlarm((String)"0x000803220005", (String[])new String[]{storageArray.getUuid() + this.getPlatformType(context).get()});
        AlarmUtil.restoreAlarm((String)"0x3230064", (String[])new String[]{storageArray.getSn()});
        this.erasePasswordErrorFlag(protocolExtend);
        this.LOGGER.info((Object)"Discover antiBlackmail platform successfully, dev sn: %s", new Object[]{storageArray.getSn()});
    }

    private void dealFailedDiscovery(AbstractContext context, NetworkEntity storageArray, NeMgrProtocolExtend protocolExtend) {
        this.LOGGER.error((Object)"Get ProtectManager connection failed, dev sn: %s", new Object[]{storageArray.getSn()});
        this.triggerAuthErrorAlarm(storageArray);
        DiscoverExUtil.updateOceanProtectStatus(storageArray, -1);
        if ("icommand:action:discovery".equals(context.getAttribute("icommand:action", String.class))) {
            protocolExtend.getExtendParams().remove("OceanProtectPort");
            protocolExtend.getExtendParams().remove("OceanProtectUsername");
            protocolExtend.getExtendParams().remove("OceanProtectPassword");
            return;
        }
        if (context.getAttributeKeys().contains("protectManagerPasswordError")) {
            protocolExtend.getExtendParams().put("protectManagerPasswordError", Boolean.TRUE.toString());
            ((INeMgrProtocolExtendService)ServiceLocator.getInstance().getService(INeMgrProtocolExtendService.class)).save(protocolExtend);
        }
    }

    private void erasePasswordErrorFlag(NeMgrProtocolExtend protocolExtend) {
        Map extendParams = protocolExtend.getExtendParams();
        if (!extendParams.containsKey("protectManagerPasswordError")) {
            return;
        }
        extendParams.remove("protectManagerPasswordError");
        ((INeMgrProtocolExtendService)ServiceLocator.getInstance().getService(INeMgrProtocolExtendService.class)).save(protocolExtend);
    }
}

