/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.commons.process;

import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.base.util.MOUtil;
import com.huawei.ism.cbb.discover.framework.AbstractContext;
import com.huawei.ism.cbb.discover.framework.ISaveNetworkEntityExtender;
import com.huawei.ism.cbb.discover.util.DiscoverUtil;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.HashMap;
import java.util.List;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;

public class SaveStorageDeviceTransactionCallback
implements TransactionCallback {
    private static final Log logger = LogFactory.getInstance(SaveStorageDeviceTransactionCallback.class);
    private final NetworkEntity array;
    private final AbstractContext context;
    private final ISaveNetworkEntityExtender saveStorageExtender;

    public SaveStorageDeviceTransactionCallback(NetworkEntity array, AbstractContext context, ISaveNetworkEntityExtender saveStorageExtender) {
        this.array = array;
        this.context = context;
        this.saveStorageExtender = saveStorageExtender;
    }

    public Object doInTransaction(TransactionStatus status) {
        IMoDao moDao = CommonDAOLocator.getMoDao();
        HashMap map = new HashMap();
        try {
            List removingMo = MOUtil.calRemovingMO((NetworkEntity)this.array, (IMoDao)moDao);
            moDao.clear();
            logger.info((Object)"begin to remmve mos.");
            moDao.deleteMoWithoutMsg(removingMo);
            logger.info((Object)("Remmving mos : " + removingMo.size()));
            logger.info((Object)"begin to save mo.");
            moDao.addMoAndSubMoEx((ManagedObject)this.array, map);
            logger.info((Object)"end to save mo.");
            this.extendProcess();
            Object userId = this.context.getAttribute("OperatorId");
            if (userId instanceof Long) {
                logger.info((Object)("Grant, user=" + userId + ", mo=" + this.array.getMoId() + ", sn=" + this.array.getSn()), 90160758784000L);
                DiscoverUtil.grantUserNeAuthority((NetworkEntity)this.array, (Long)((Long)userId));
            }
            logger.info((Object)("Save array finished, devSn=" + this.array.getSn()), 90160777658373L);
        }
        catch (Exception ex) {
            logger.error((Object)ExceptionUtil.getErrorMessage((Throwable)ex), 90160777658373L);
            status.setRollbackOnly();
            this.parseException(ex);
        }
        return map;
    }

    private void parseException(Exception ex) {
        if (ex instanceof LegoCheckedException) {
            throw (LegoCheckedException)((Object)ex);
        }
        String errorMessage = ex.getMessage();
        if (null != errorMessage && errorMessage.contains("Lock wait timeout exceeded")) {
            throw new LegoCheckedException(102401L, (Throwable)ex);
        }
        throw new LegoCheckedException(132416L, (Throwable)ex);
    }

    private void extendProcess() {
        String location = this.array.getLocation();
        logger.info((Object)("old location=" + location), 90160758784000L);
        String siteId = (String)this.context.getAttribute("SiteId");
        logger.info((Object)("SiteId=" + siteId), 90160758784000L);
        this.array.setLocation(siteId);
        if (null != this.saveStorageExtender) {
            this.saveStorageExtender.process(this.array);
        }
    }
}

