/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.util;

import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.base.sdk.model.StorageUnit;
import com.huawei.ism.cbb.proxy.protocol.tlv.connection.ConnectionManager;
import com.huawei.ism.cbb.proxy.protocol.tlv.connection.TLVConnection;
import com.huawei.ism.cbb.proxy.protocol.tlv.msg.Record;
import com.huawei.ism.cbb.proxy.protocol.tlv.msg.TLVMOMsg;
import com.huawei.ism.cbb.proxy.util.DiscoverExUtil;
import com.huawei.ism.cbb.proxy.util.SnmpCommandUtil;
import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.ism.cbb.proxy.xve.XveTLVPParent;
import com.huawei.lego.com.south.sdk.model.SnmpEnum;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TrapUtil {
    private static final Log logger = LogFactory.getInstance(TrapUtil.class);

    public static void deleteTrapIPBySmis(String deviceId, String ip) {
    }

    public static void deleteTrapIpByTlv(String deviceId, String ip) {
        TLVConnection connection = (TLVConnection)ConnectionManager.getInstance().getConnection(deviceId);
        if (null == connection) {
            logger.info((Object)("connection is null, sn=" + deviceId + ", ip=" + ip));
            return;
        }
        ArrayList tlvParamsGet = new ArrayList();
        Record recordToDelete = null;
        try {
            List tlvRcord = connection.pmGetBacthNext(XveMOType.SNMP_TRAP_ADDR.getValue(), tlvParamsGet, 30);
            for (Record record : tlvRcord) {
                String ipOnDevice = record.getParamStrValue(XveTLVPParent.SnmpTrap.CMO_TRAP_SERVER_IP.getParamIndex());
                if (null == ipOnDevice || !ipOnDevice.equals(ip)) continue;
                recordToDelete = record;
                break;
            }
        }
        catch (Exception e) {
            logger.error((Object)("Exception : " + ExceptionUtil.getErrorMessage((Throwable)e)), 90160777658902L);
            return;
        }
        if (null == recordToDelete) {
            return;
        }
        String id = recordToDelete.getParamStrValue(TLVMOMsg.ID.getParamIndex());
        connection.pmDelete(XveMOType.SNMP_TRAP_ADDR.getValue(), id, 30);
    }

    public static boolean deleteTrapIpBySnmp(StorageUnit deleteSubMo, String localIp, int localPort) {
        NetworkEntity parent = (NetworkEntity)deleteSubMo.getParentMo();
        try {
            HashMap<String, Map<String, String>> oidParameters = new HashMap<String, Map<String, String>>();
            HashMap<String, String> map = new HashMap<String, String>();
            if (DiscoverExUtil.isS5600V1R1Unit(deleteSubMo)) {
                String prefix = ".1.3.6.1.4.1.2011.2.91.10.4.1.1";
                String oid = prefix + ".1." + localIp;
                String value = localIp;
                map.put("oid", oid);
                map.put("type", "" + SnmpEnum.SnmpType.IPADDRESS.getValue());
                map.put("value", value);
                oidParameters.put("trapIp", map);
                map = new HashMap();
                oid = prefix + ".2." + localIp;
                value = String.valueOf(localPort);
                map.put("oid", oid);
                map.put("type", "" + SnmpEnum.SnmpType.INTEGER.getValue());
                map.put("value", value);
                oidParameters.put("trapPort", map);
                map = new HashMap();
                oid = prefix + ".3." + localIp;
                value = "6";
                map.put("oid", oid);
                map.put("type", "" + SnmpEnum.SnmpType.INTEGER.getValue());
                map.put("value", value);
                oidParameters.put("trapStatus", map);
            }
            logger.info((Object)("unregisterTrap on " + deleteSubMo.getLinkIp() + " for NMS " + localIp), 90160777658901L);
            SnmpCommandUtil.executeSnmpSetCommand("unregiesterTrapIp", parent, oidParameters);
        }
        catch (Exception e) {
            logger.error((Object)("Exception : " + ExceptionUtil.getErrorMessage((Throwable)e)), 90160777658902L);
            return false;
        }
        return true;
    }
}

