/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.proxy.protocol.tlv.connection;

import com.huawei.ism.cbb.proxy.protocol.tlv.connection.IConnection;
import com.huawei.ism.cbb.proxy.protocol.tlv.connection.TLVConnectionImpl;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;

public final class ConnectionManager {
    private static final Log logger = LogFactory.getInstance(ConnectionManager.class);
    private static final ConnectionManager instance = new ConnectionManager();
    private final Map<String, IConnection> connMap = new Hashtable<String, IConnection>();
    private final Map<String, Class<? extends IConnection>> connClassMap = new Hashtable<String, Class<? extends IConnection>>();

    private ConnectionManager() {
    }

    public static ConnectionManager getInstance() {
        return instance;
    }

    public IConnection getConnection(String deviceID) {
        return this.connMap.get(deviceID);
    }

    public IConnection removeConnection(String deviceID) {
        IConnection removed = null;
        if (this.connMap.containsKey(deviceID)) {
            removed = this.connMap.remove(deviceID);
            logger.info((Object)("Remove conn, devSn=" + deviceID + ", IP=" + removed.getUrl()), 90160758784000L);
        }
        return removed;
    }

    public void setConnection(String deviceID, IConnection conn) {
        logger.info((Object)("Set connection, devSn=" + deviceID + ", IP=" + conn.getUrl()), 90160758784000L);
        IConnection removed = this.removeConnection(deviceID);
        if (null != removed) {
            removed.close();
        }
        conn.setDeviceId(deviceID);
        this.connMap.put(deviceID, conn);
    }

    public IConnection buildConnection(String deviceType, Properties properties) {
        IConnection conn;
        Class<Object> clazz = this.connClassMap.get(deviceType);
        if (null == clazz) {
            clazz = TLVConnectionImpl.class;
            this.registerConnectionClass(deviceType, clazz);
        }
        try {
            conn = (IConnection)clazz.newInstance();
            conn.init(properties);
        }
        catch (InstantiationException e) {
            logger.error((Object)e, 90160758784009L);
            throw new LegoCheckedException(0x300001L, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)e, 90160758784000L);
            throw new LegoCheckedException(0x300001L, (Throwable)e);
        }
        return conn;
    }

    public void registerConnectionClass(String deviceType, Class<? extends IConnection> clazz) {
        this.connClassMap.put(deviceType, clazz);
    }
}

