/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.proxy.util;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.base.sdk.model.StorageUnit;
import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.TimeUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.common.Launcher;
import com.huawei.ism.common.LauncherManager;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.com.south.sdk.model.SnmpPara;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.mediation.synchronize.model.SynchronizeParameter;
import com.huawei.lego.nem.discover.sdk.model.DiscoveryPolicy;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.hibernate.query.Query;
import org.springframework.orm.hibernate5.HibernateTemplate;

public class DiscoverExUtil {
    private static final Log logger = LogFactory.getInstance((Object)new DiscoverExUtil());

    public static void updateTimeZoneToMo(ManagedObject mo, String deviceId) {
        Launcher launcher = LauncherManager.getInstance().getLauncher(deviceId);
        TimeZone timeZone = TimeZone.getDefault();
        if (null != launcher && null != launcher.getDeviceTimeZone()) {
            timeZone = launcher.getDeviceTimeZone();
        }
        String timezoneFormat = TimeUtil.getTimeZoneOffset((TimeZone)timeZone);
        mo.setTimezoneFormat(timezoneFormat);
    }

    public static void updateOceanProtectStatus(NetworkEntity networkEntity, int status) {
        if (VerifyUtil.isEmpty((Object)networkEntity)) {
            logger.error((Object)"The NetworkEntity object is null.");
            throw new LegoCheckedException(1073947393L);
        }
        IMoDao moDao = CommonDAOLocator.getMoDao();
        HibernateTemplate template = moDao.getHibernateTemplate();
        template.execute(session -> {
            String hql = "update NetworkEntity set devStatus=? where uuid=?";
            Query query = session.createQuery(hql);
            query.setParameter(0, (Object)status);
            query.setParameter(1, (Object)networkEntity.getUuid());
            query.executeUpdate();
            return null;
        });
    }

    public static NeMgrProtocolExtend parseHuaweiStorageParams(SynchronizeParameter param) {
        NeMgrProtocolExtend neMgrExtend = new NeMgrProtocolExtend();
        neMgrExtend.setNetworkIpAddress(param.getDeviceIp());
        neMgrExtend.setOtherParam(param.getLocation());
        DiscoveryPolicy policy = param.getDiscoveryPolicy();
        if (null == policy || VerifyUtil.isEmpty((Map)policy.getParamMap())) {
            return neMgrExtend;
        }
        Map extendParams = neMgrExtend.getExtendParams();
        Map paramMap = policy.getParamMap();
        String protocol = (String)paramMap.get("protocol");
        extendParams.put("protocol", protocol);
        if ("DEFAULT".equals(protocol) || "REST".equals(protocol) || "FSB-REST".equals(protocol)) {
            neMgrExtend = DiscoverExUtil.parseExtendParams(param);
            neMgrExtend.getExtendParams().put("protocol", protocol);
        }
        return neMgrExtend;
    }

    public static NeMgrProtocolExtend parseExtendParams(SynchronizeParameter param) {
        NeMgrProtocolExtend neMgrExtend = new NeMgrProtocolExtend();
        neMgrExtend.setNetworkIpAddress(param.getDeviceIp());
        neMgrExtend.setOtherParam(param.getLocation());
        DiscoveryPolicy policy = param.getDiscoveryPolicy();
        SnmpPara sp = null;
        int snmpVer = 0;
        if (null != param.getManagementProtocolMap()) {
            sp = (SnmpPara)param.getManagementProtocolMap().get("com.huawei.lego.com.south.sdk.model.SnmpPara");
        }
        if (null != sp) {
            snmpVer = sp.getVersion();
        }
        if (null == policy || VerifyUtil.isEmpty((Map)policy.getParamMap())) {
            return neMgrExtend;
        }
        Map paramMap = policy.getParamMap();
        neMgrExtend.setNetworkUserName((String)paramMap.get("name"));
        neMgrExtend.setNetworkPassword((String)paramMap.get("password"));
        Map<String, String> extendParams = DiscoverExUtil.getExtendParams(paramMap, snmpVer);
        neMgrExtend.setExtendParams(extendParams);
        logger.info((Object)"out NeMgrProtocolExtend", 90160777658372L);
        return neMgrExtend;
    }

    private static Map<String, String> getExtendParams(Map<String, String> paramMap, int snmpVer) {
        HashMap<String, String> extendParams = new HashMap<String, String>();
        extendParams.put("sslFlag", paramMap.get("ssl"));
        extendParams.put("protocol", paramMap.get("protocol"));
        extendParams.put("snmpVer", String.valueOf(snmpVer));
        if (!VerifyUtil.isEmpty((String)paramMap.get("port"))) {
            extendParams.put("port", paramMap.get("port"));
        }
        if (!VerifyUtil.isEmpty((String)paramMap.get("namespace"))) {
            extendParams.put("namespace", paramMap.get("namespace"));
        }
        DiscoverExUtil.extractOceanProtectAuthParams(paramMap, extendParams);
        extendParams.put("isFirstBuildTlv", "isFirstBuild");
        return extendParams;
    }

    private static void extractOceanProtectAuthParams(Map<String, String> paramMap, Map<String, String> extendParams) {
        if (paramMap.containsKey("OceanProtectPort")) {
            extendParams.put("OceanProtectPort", paramMap.get("OceanProtectPort"));
        }
        if (paramMap.containsKey("OceanProtectUsername")) {
            extendParams.put("OceanProtectUsername", paramMap.get("OceanProtectUsername"));
        }
        if (paramMap.containsKey("OceanProtectPassword")) {
            extendParams.put("OceanProtectPassword", paramMap.get("OceanProtectPassword"));
        }
    }

    public static boolean isS5600V1R1Unit(StorageUnit unit) {
        return null != unit && "S5600(V100R001)".equals(unit.getSubType());
    }
}

