/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.proxy.util;

import com.huawei.ism.cbb.proxy.protocol.snmp.OIDLauncher;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public final class OIDUtil {
    public static final String OID_POSTFIX = ".oid";
    public static final String OID_KEY = "oid";
    public static final String CONIFIGURE_PREFIX = "ism2.configure.";
    public static final String TYPE_POSTFIX = ".type";
    public static final String TYPE_KEY = "type";
    public static final String VALUE_KEY = "value";

    private OIDUtil() {
    }

    public static String[] getOIDs(String[] oidNames) {
        if (VerifyUtil.isEmpty((Object[])oidNames)) {
            return new String[0];
        }
        String[] oids = new String[oidNames.length];
        int i = 0;
        for (String oidName : oidNames) {
            Map<String, String> map = OIDUtil.generateOneOIDInfo(oidName, "");
            oids[i] = map.get(OID_KEY).trim();
            ++i;
        }
        return oids;
    }

    public static String[] getOIDs(Collection<String> oidNames) {
        String[] oids = new String[oidNames.size()];
        int i = 0;
        for (String oidName : oidNames) {
            Map<String, String> map = OIDUtil.generateOneOIDInfo(oidName, "");
            oids[i] = map.get(OID_KEY);
            ++i;
        }
        return oids;
    }

    public static String getOID(String oidName) {
        Map<String, String> map = OIDUtil.generateOneOIDInfo(oidName, "");
        return map.get(OID_KEY);
    }

    public static String getOIDWithIndex(String oidName, String index) {
        Map<String, String> map = OIDUtil.generateOneOIDInfo(oidName, "");
        return map.get(OID_KEY) + index;
    }

    public static String[] getOIDsWithIndex(String[] oidNames, String index) {
        String[] oids = new String[oidNames.length];
        int i = 0;
        for (String oidName : oidNames) {
            Map<String, String> map = OIDUtil.generateOneOIDInfo(oidName, "");
            oids[i] = map.get(OID_KEY) + index;
            ++i;
        }
        return oids;
    }

    public static String[] getOIDsWithIndex(Collection<String> oidNames, String index) {
        String[] oids = new String[oidNames.size()];
        int i = 0;
        for (String oidName : oidNames) {
            Map<String, String> map = OIDUtil.generateOneOIDInfo(oidName, "");
            oids[i] = map.get(OID_KEY) + index;
            ++i;
        }
        return oids;
    }

    public static String getOidSuffixOfIndex(String valueOfIndex) {
        char[] temp = valueOfIndex.toCharArray();
        StringBuffer sb = new StringBuffer();
        sb.append('.').append(temp.length);
        for (int i = 0; i < temp.length; ++i) {
            sb.append('.');
            sb.append((int)temp[i]);
        }
        return sb.toString();
    }

    public static String getOidSuffixOfIndex4SNMP4J(String valueOfIndex) {
        String[] temp = valueOfIndex.split(":");
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < temp.length; ++i) {
            sb.append('.');
            try {
                sb.append(Integer.parseInt(temp[i], 16));
                continue;
            }
            catch (NumberFormatException e) {
                throw new LegoCheckedException(1073947393L, (Throwable)e);
            }
        }
        return sb.toString();
    }

    public static String getOidSuffixOfIndexNoLength(String valueOfIndex) {
        char[] temp = valueOfIndex.toCharArray();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < temp.length; ++i) {
            sb.append('.');
            sb.append((int)temp[i]);
        }
        return sb.toString();
    }

    public static String getOidSuffixOfIndex(Collection<String> valueOfIndexs) {
        StringBuilder index = new StringBuilder();
        for (String indexValue : valueOfIndexs) {
            index.append(OIDUtil.getOidSuffixOfIndex(indexValue));
        }
        return index.toString();
    }

    public static Map<String, String> generateOneOIDInfo(String oidName, String oidValue) {
        HashMap<String, String> oneOidMap = new HashMap<String, String>();
        oneOidMap.put(OID_KEY, OIDLauncher.getInstance().getProperty(CONIFIGURE_PREFIX + oidName + OID_POSTFIX));
        oneOidMap.put(TYPE_KEY, OIDLauncher.getInstance().getProperty(CONIFIGURE_PREFIX + oidName + TYPE_POSTFIX));
        oneOidMap.put(VALUE_KEY, oidValue);
        return oneOidMap;
    }

    public static Map<String, String> generateOneOIDInfoWithIndex(String oidName, String oidValue, String indexStr) {
        HashMap<String, String> oneOidMap = new HashMap<String, String>();
        oneOidMap.put(OID_KEY, OIDLauncher.getInstance().getProperty(CONIFIGURE_PREFIX + oidName + OID_POSTFIX) + indexStr);
        oneOidMap.put(TYPE_KEY, OIDLauncher.getInstance().getProperty(CONIFIGURE_PREFIX + oidName + TYPE_POSTFIX));
        oneOidMap.put(VALUE_KEY, oidValue);
        return oneOidMap;
    }
}

