/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ubase.adaptor.hvs.discovery.process;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.cbb.discover.commons.process.AbstractPingProcessor;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.HvsRestConnection;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnection;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnectionManager;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.text.MessageFormat;

public class HVSRestPingProcessor
extends AbstractPingProcessor {
    private static final Log logger = LogFactory.getInstance(HVSRestPingProcessor.class);

    public String getName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    protected String getCurrentIp(String sn) {
        RestConnection connection = RestConnectionManager.getInstance().getConnection(sn);
        if (null != connection && connection.isValid()) {
            return connection.getIpAddress();
        }
        return null;
    }

    protected void connect(String sn, String ip, NeMgrProtocolExtend info) {
        String userName = info.getNetworkUserName();
        String password = info.getNetworkPassword();
        int port = NumberUtil.parseInteger(info.getExtendParams().get("port"));
        HvsRestConnection connection = new HvsRestConnection(ip, port, userName, password);
        ((RestConnection)connection).authenticate();
        RestConnectionManager.getInstance().setConnection(connection.getDeviceId(), connection);
        if (!sn.equals(connection.getDeviceId())) {
            logger.error((Object)MessageFormat.format("SN match fail, db devSn={0}, but realtime devSn={2} with the ip={1}", sn, ip, connection.getDeviceId()));
            throw new LegoCheckedException(1073947432L);
        }
        if (!ip.equals(connection.getIpAddress())) {
            logger.warn((Object)("The ip intended to be connected is " + ip + ", but realtime is " + connection.getIpAddress()));
        }
    }
}

