/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ubase.adaptor.hvs.discovery.synchronizer;

import com.huawei.ism.array.sdk.model.HvsStorage;
import com.huawei.ism.array.sdk.model.HvsUnit;
import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.cbb.discover.commons.DiscoverContext;
import com.huawei.ism.cbb.discover.framework.AbstractContext;
import com.huawei.ism.cbb.discover.framework.CommonTemplate;
import com.huawei.ism.cbb.discover.framework.CommonTemplateManager;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnection;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnectionManager;
import com.huawei.ism.cbb.proxy.util.DiscoverExUtil;
import com.huawei.ism.cbb.proxy.util.ResourceHelper;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.mediation.synchronize.AbstractSynchronizer;
import com.huawei.lego.core.sdk.mediation.synchronize.model.MoListOrMap;
import com.huawei.lego.core.sdk.mediation.synchronize.model.SynchronizeParameter;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.nem.discover.sdk.model.DiscoveryPolicy;
import com.huawei.ubase.adaptor.hvs.discovery.process.HVSDeviceProxyImpl;
import java.util.Arrays;

public class HvsStorageSynchronizer
extends AbstractSynchronizer {
    private static final Log LOGGER = LogFactory.getInstance(HvsStorageSynchronizer.class);
    private static final String STORAGE_VERSION = "V6";
    private static final String STORAGE_V5_VERSION = "V5";
    private static final String STORAGE_V3_VERSION = "V3";
    private static final String OCEAN_PROTECT_VERSION = "OceanProtect";
    private static final String STORAGE_CONVERGENCE = "OceanStor ";

    public MoListOrMap synchronizeDataAndConstructMo(SynchronizeParameter params, MoListOrMap moListOrMap) {
        if (null == params) {
            LOGGER.error((Object)"context is null", 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
        LOGGER.info((Object)("Begin to discover rest storage, device IP:" + params.getDeviceIp()), 90160777658372L);
        NeMgrProtocolExtend neMgrProtocolExtend = DiscoverExUtil.parseHuaweiStorageParams(params);
        if (VerifyUtil.isEmpty((Object)neMgrProtocolExtend) || VerifyUtil.isEmpty((String)neMgrProtocolExtend.getNetworkUserName()) || VerifyUtil.isEmpty((String)neMgrProtocolExtend.getNetworkPassword())) {
            throw new LegoCheckedException(1073947393L);
        }
        String restPort = (String)neMgrProtocolExtend.getExtendParams().get("port");
        if (VerifyUtil.isEmpty((String)restPort)) {
            restPort = ResourceHelper.getValue("hvs.port");
            LOGGER.info((Object)("Use default rest port, value=" + restPort), 90160758784000L);
            neMgrProtocolExtend.getExtendParams().put("port", restPort);
        }
        this.retrieveHVS(params, moListOrMap, neMgrProtocolExtend);
        return null;
    }

    private void retrieveHVS(SynchronizeParameter params, MoListOrMap moListOrMap, NeMgrProtocolExtend neMgrProtocolExtend) {
        CommonTemplate discoverTemplate = CommonTemplateManager.getInstance().getTemplateByManagementProtocol("REST", 1);
        if (null == discoverTemplate) {
            LOGGER.error((Object)"discoverTemplate is null.", 90160758784000L);
            throw new LegoCheckedException(127402L);
        }
        HVSDeviceProxyImpl proxy = new HVSDeviceProxyImpl();
        RestConnection connection = this.initConnection(neMgrProtocolExtend);
        HvsUnit hvsUnit = proxy.getComputerSystem(connection);
        String productModel = hvsUnit.getProductModel();
        if (!this.checkStorageVersion(params, productModel)) {
            LOGGER.error((Object)"storage productModel is not matched of airgap!, IP: %s", new Object[]{hvsUnit.getIpAddress()});
            throw new LegoCheckedException(1073948469L);
        }
        HvsStorage hvsStorage = new HvsStorage();
        hvsStorage.setSn(hvsUnit.getDevSn());
        hvsStorage.setProductModel(productModel);
        hvsStorage.setManagementProtocolMap(params.getManagementProtocolMap());
        hvsStorage.setIpAddress(params.getDeviceIp());
        hvsStorage.setLinkIp(params.getDeviceIp());
        DiscoverContext context = new DiscoverContext(params, moListOrMap);
        context.setAttribute("StorageDevice", (Object)hvsStorage);
        context.setAttribute("NeMgrProtocolExtend", (Object)neMgrProtocolExtend);
        context.setAttribute("AvailableIps", Arrays.asList(params.getDeviceIp()));
        context.setAttribute("SiteId", (Object)params.getDiscoveryPolicy().getLocation());
        context.setAttribute("OperatorId", (Object)params.getDiscoveryPolicy().getOperatorId());
        discoverTemplate.process((AbstractContext)context);
    }

    private boolean checkStorageVersion(SynchronizeParameter params, String productModel) {
        DiscoveryPolicy policy = params.getDiscoveryPolicy();
        if (!policy.getIsAirGapResource().booleanValue()) {
            return true;
        }
        if (productModel.contains(STORAGE_V5_VERSION) || productModel.contains(STORAGE_V3_VERSION)) {
            return false;
        }
        return productModel.contains(STORAGE_VERSION) || productModel.contains(OCEAN_PROTECT_VERSION) || productModel.contains(STORAGE_CONVERGENCE);
    }

    private RestConnection initConnection(NeMgrProtocolExtend neMgrProtocolExtend) {
        String ip = neMgrProtocolExtend.getNetworkIpAddress();
        RestConnection connection = RestConnectionManager.getInstance().buildConnection(neMgrProtocolExtend, null);
        connection.authenticate();
        String devSn = connection.getDeviceId();
        RestConnectionManager instance = RestConnectionManager.getInstance();
        RestConnection oldConnection = instance.getConnection(devSn);
        if (null == oldConnection || !oldConnection.isValid()) {
            instance.setConnection(devSn, connection);
        } else {
            try {
                connection.logout();
                LOGGER.info((Object)("logout success, devSn=" + devSn + ", ip=" + ip), 90160758784000L);
            }
            catch (Exception ex) {
                LOGGER.error((Object)("logout failed. devSn=" + devSn + ", ip=" + ip + ExceptionUtil.getErrorMessage((Throwable)ex)), 90160758784000L);
            }
            connection = oldConnection;
        }
        return connection;
    }
}

