/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.anti.blackmail.manager.oceanprotect.api;

import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnection;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.anti.blackmail.manager.oceanprotect.api.BaseOceanProtectApiManager;
import com.huawei.ism.drm.anti.blackmail.manager.sdk.model.AntiBlackmailSLA;
import com.huawei.ism.drm.anti.blackmail.manager.sdk.service.api.IAntiBlackmailSlaApiManager;
import com.huawei.ism.drm.anti.blackmail.util.OceanProtectRestTransition;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class OceanProtectSlaApiManager
extends BaseOceanProtectApiManager
implements IAntiBlackmailSlaApiManager {
    private static final Log LOGGER = LogFactory.getInstance(OceanProtectSlaApiManager.class);
    private static final String PROTECT_URI = "/v1/protected-objects";
    private static final String SLA_URI = "/v1/slas";

    public Optional<String> createSla(String devSn, Map<String, Object> params) {
        RestConnection connection = this.getConnection(devSn, "oceanProtectConnection");
        String resultStr = connection.postForObject(SLA_URI, params);
        JSONObject jsonObject = JSONObject.fromObject((Object)resultStr);
        if (!jsonObject.containsKey((Object)"uuid")) {
            return Optional.empty();
        }
        return Optional.of(jsonObject.getString("uuid"));
    }

    public String deleteSla(String devSn, String id) {
        RestConnection connection = this.getConnection(devSn, "oceanProtectConnection");
        Map resultMap = connection.deleteForObject("/v1/slas/" + id, null);
        return (String)resultMap.get("uuid");
    }

    public Optional<AntiBlackmailSLA> querySlaByName(String devSn, Map<String, String> queryParams) {
        String slaName = queryParams.get("name");
        if (VerifyUtil.isEmpty((String)slaName)) {
            LOGGER.error((Object)"Sla name is empty.");
            return Optional.empty();
        }
        queryParams.put("PMBatchResultKey", "items");
        List<Map<String, String>> resultList = this.queryAllByPage(SLA_URI, devSn, queryParams);
        List<AntiBlackmailSLA> slaList = OceanProtectRestTransition.transitionAntiBlackmailSLA(resultList);
        if (VerifyUtil.isEmpty(slaList)) {
            LOGGER.error((Object)"No sla named %s is found, dev sn: %s", new Object[]{slaName, devSn});
            return Optional.empty();
        }
        for (AntiBlackmailSLA sla : slaList) {
            if (!slaName.equals(sla.getName())) continue;
            return Optional.of(sla);
        }
        LOGGER.error((Object)"No sla named %s is found, dev sn: %s", new Object[]{slaName, devSn});
        return Optional.empty();
    }

    public OperationResult associateResourcesWithSla(String devSn, Map<String, Object> params) {
        try {
            RestConnection connection = this.getConnection(devSn, "oceanProtectConnection");
            connection.postForObject("/v1/protected-objects/batch?akOperationTips=false", params);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Failed to create sla protection, dev sn: %s, params: %s", new Object[]{devSn, params});
            return new OperationResult("anti.blackmail.sla.protection.associate.operation", true, false, String.valueOf(e.getErrorCode()), e.getParameters());
        }
        catch (Exception e) {
            LOGGER.error((Object)"Failed to create sla protection, dev sn: %s, params: %s", new Object[]{devSn, params});
            return new OperationResult("anti.blackmail.sla.protection.associate.operation", true, false, String.valueOf(0x300001L), new String[0]);
        }
        return new OperationResult("anti.blackmail.sla.protection.associate.operation", true, true, new String[0]);
    }

    public OperationResult removeSlaProtection(String devSn, List<String> resourceIdList) {
        if (VerifyUtil.isEmpty(resourceIdList)) {
            LOGGER.error((Object)"Param is empty.");
            return new OperationResult("anti.blackmail.sla.protection.remove.operation", true, false, String.valueOf(0x300001L), new String[0]);
        }
        HashMap<String, List<String>> deletedObject = new HashMap<String, List<String>>();
        deletedObject.put("resource_ids", resourceIdList);
        try {
            RestConnection connection = this.getConnection(devSn, "oceanProtectConnection");
            connection.deleteForObject(PROTECT_URI, deletedObject);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Failed to remove resources sla protection.dev sn: %s, resource Id: %s", new Object[]{devSn, resourceIdList});
            return new OperationResult("anti.blackmail.sla.protection.remove.operation", true, false, String.valueOf(e.getErrorCode()), e.getParameters());
        }
        catch (Exception e) {
            LOGGER.error((Object)"Failed to remove resources sla protection.dev sn: %s, resource Id: %s", new Object[]{devSn, resourceIdList});
            return new OperationResult("anti.blackmail.sla.protection.remove.operation", true, false, String.valueOf(0x300001L), new String[0]);
        }
        return new OperationResult("anti.blackmail.sla.protection.remove.operation", true, true, new String[0]);
    }

    public OperationResult disableSlaProtection(String devSn, List<String> resourceIdList) {
        if (VerifyUtil.isEmpty(resourceIdList)) {
            LOGGER.error((Object)"Param is empty.");
            return new OperationResult("anti.blackmail.sla.protection.disable.operation", true, false, String.valueOf(0x300001L), new String[0]);
        }
        HashMap<String, List<String>> disabledObjects = new HashMap<String, List<String>>();
        disabledObjects.put("resource_ids", resourceIdList);
        try {
            RestConnection connection = this.getConnection(devSn, "oceanProtectConnection");
            connection.putForObject("/v1/protected-objects/status/action/deactivate", disabledObjects);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Failed to disable resources sla protection.dev sn: %s, resource Id: %s", new Object[]{devSn, resourceIdList});
            return new OperationResult("anti.blackmail.sla.protection.disable.operation", true, false, String.valueOf(e.getErrorCode()), e.getParameters());
        }
        catch (Exception e) {
            LOGGER.error((Object)"Failed to disable resources sla protection.dev sn: %s, resource Id: %s", new Object[]{devSn, resourceIdList});
            return new OperationResult("anti.blackmail.sla.protection.disable.operation", true, false, String.valueOf(0x300001L), new String[0]);
        }
        return new OperationResult("anti.blackmail.sla.protection.disable.operation", true, true, new String[0]);
    }

    @Override
    protected String getPageSizeKey() {
        return "page_size";
    }

    @Override
    protected String getStartPageKey() {
        return "page_no";
    }
}

