/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.message;

import com.huawei.ism.base.sdk.model.StorageNE;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.storage.sdk.model.DrStorage;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.comm.internal.jms.IMessageCenter;
import com.huawei.lego.comm.internal.jms.MessageRegister;
import com.huawei.lego.comm.internal.jms.MessageTaskManager;
import com.huawei.lego.comm.internal.jms.MessageTopic;
import com.huawei.lego.comm.internal.jms.MessageUnit;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class StorageMessageSubscriber
extends MessageTaskManager {
    private final Log logger = LogFactory.getInstance(((Object)((Object)this)).getClass());

    public StorageMessageSubscriber(IMessageCenter msgCenter) {
        msgCenter.addSubscriberTo((MessageTaskManager)this);
    }

    public MessageRegister[] getTypes() {
        MessageRegister[] mrs = MessageRegister.getMessageRegisters((int)2);
        mrs[0].setMessageTopic(MessageTopic.DATA);
        mrs[0].addMessageCode(107L);
        mrs[1].setMessageTopic(MessageTopic.COMMAND);
        mrs[1].addMessageCode(109L);
        mrs[1].addMessageCode(110L);
        return mrs;
    }

    public void onMessage(MessageUnit mu) {
        Object msg = mu.getObj();
        if (!(msg instanceof Map)) {
            return;
        }
        if (MessageTopic.DATA.equals((Object)mu.getMt())) {
            this.processDataMessage(msg);
        } else if (MessageTopic.COMMAND.equals((Object)mu.getMt())) {
            this.processCmdMessage(msg);
        } else {
            this.logger.info((Object)("Not subscribed topic. Type:" + mu.getMt().name()));
        }
    }

    private void processCmdMessage(Object msg) {
        Map objs = (Map)msg;
        for (Map.Entry entry : objs.entrySet()) {
            ManagedObject mo = (ManagedObject)CommonDAOLocator.getMoDao().get((Serializable)entry.getKey());
            if (!(mo instanceof StorageNE)) continue;
            StorageNE ne = (StorageNE)mo;
            this.updateDrStorageStatus((Integer)entry.getValue(), ne.getSn());
        }
    }

    private void processDataMessage(Object msg) {
        Map objs = (Map)msg;
        for (Object obj : objs.values()) {
            if (!(obj instanceof StorageNE)) continue;
            StorageNE ne = (StorageNE)obj;
            this.updateDrStorageStatus(ne.getStatus(), ne.getSn());
        }
    }

    private void updateDrStorageStatus(Integer status, String devSn) {
        if (null != status) {
            List storages = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from DrStorage where deviceSn = ? and siteId in (select siteId from Site where siteType = 0)", new Object[]{devSn});
            if (!VerifyUtil.isEmpty((Collection)storages)) {
                DrStorage storage = (DrStorage)storages.get(0);
                storage.setStatus(String.valueOf(status));
                CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)storage);
            } else {
                this.logger.error((Object)("the storage is null when update status of storage. sn: " + devSn));
            }
        } else {
            this.logger.error((Object)"the status is null when update status of storage");
        }
    }
}

