/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.action;

import com.huawei.ism.cbb.proxy.xve.XveEuumDefineParent;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.DrmStorageUtil;
import com.huawei.ism.drm.protection.replica.sdk.model.HyperClonePair;
import com.huawei.ism.drm.storage.manager.proxy.StorageHyperCloneManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageHyperCloneManager;
import com.huawei.ism.drm.storage.sdk.model.HyperCloneTargetLun;
import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;

public class RefreshHyperClonePairsTask
implements Runnable {
    private static final Log logger = LogFactory.getInstance(RefreshHyperClonePairsTask.class);
    private static final int REFRESH_TASK_GROUP_SIZE = 20;
    private final Set<HyperClonePair> hyperClonePairs = new HashSet<HyperClonePair>();

    public RefreshHyperClonePairsTask(Set<HyperClonePair> hyperClonePairs) {
        if (null == hyperClonePairs) {
            return;
        }
        this.hyperClonePairs.addAll(hyperClonePairs);
    }

    @Override
    public void run() {
        StorageHyperCloneManagerProxy mgrProxy = StorageHyperCloneManagerProxy.getInstance();
        Iterator<HyperClonePair> iterator = this.hyperClonePairs.iterator();
        if (!iterator.hasNext()) {
            logger.error((Object)"hyperClonePairs is empty!");
            return;
        }
        String deviceSn = iterator.next().getDeviceSn();
        final IStorageHyperCloneManager hyperCloneMgr = mgrProxy.getStorageHyperCloneManager(deviceSn);
        List<Set<HyperClonePair>> groupingPairs = this.groupHyperClonePairs(this.hyperClonePairs);
        if (VerifyUtil.isEmpty(groupingPairs)) {
            return;
        }
        final CountDownLatch completedSignal = new CountDownLatch(groupingPairs.size());
        for (final Set<HyperClonePair> clonePairs : groupingPairs) {
            ExecutionService.submitTask((Runnable)new Runnable(){

                @Override
                public void run() {
                    RefreshHyperClonePairsTask.this.refreshHyperClonePairs(clonePairs, hyperCloneMgr);
                    completedSignal.countDown();
                }
            });
        }
        try {
            completedSignal.await();
        }
        catch (InterruptedException e) {
            logger.error((Object)"Wait refresh hyperclone pair failed.", (Throwable)e, 90160758784001L);
        }
    }

    private List<Set<HyperClonePair>> groupHyperClonePairs(Set<HyperClonePair> hyperClonePairParams) {
        ArrayList<Set<HyperClonePair>> groupingPairs = new ArrayList<Set<HyperClonePair>>();
        if (null == hyperClonePairParams || hyperClonePairParams.isEmpty()) {
            return groupingPairs;
        }
        HashSet<HyperClonePair> clonePairs = new HashSet<HyperClonePair>();
        groupingPairs.add(clonePairs);
        for (HyperClonePair clonePair : hyperClonePairParams) {
            clonePairs.add(clonePair);
            if (clonePairs.size() != 20) continue;
            clonePairs = new HashSet();
            groupingPairs.add(clonePairs);
        }
        return groupingPairs;
    }

    private void refreshHyperClonePairs(Set<HyperClonePair> hyperClonePairParams, IStorageHyperCloneManager hyperCloneMgr) {
        if (null == hyperClonePairParams || hyperClonePairParams.isEmpty()) {
            return;
        }
        Iterator<HyperClonePair> iter = hyperClonePairParams.iterator();
        HashSet<HyperClonePair> toRemovedPairs = new HashSet<HyperClonePair>();
        while (iter.hasNext()) {
            HyperClonePair clonePair = iter.next();
            boolean isNeedContinueRefresh = this.updateHyperClonePair(clonePair, hyperCloneMgr);
            if (isNeedContinueRefresh) continue;
            toRemovedPairs.add(clonePair);
        }
        if (!VerifyUtil.isEmpty(toRemovedPairs)) {
            hyperClonePairParams.removeAll(toRemovedPairs);
        }
        if (!hyperClonePairParams.isEmpty()) {
            CommonUtil.sleep((long)2000L);
            this.refreshHyperClonePairs(hyperClonePairParams, hyperCloneMgr);
        }
    }

    private boolean updateHyperClonePair(HyperClonePair clonePair, IStorageHyperCloneManager hyperCloneMgr) {
        try {
            HyperCloneTargetLun targetLun = hyperCloneMgr.getTargetLun(clonePair.getDeviceSn(), clonePair.getSrcLunId(), clonePair.getTgtLunId());
            if (null != targetLun) {
                DrmStorageUtil.saveOrUpdateHyperCloneTargetLun((String)clonePair.getDeviceSn(), (HyperCloneTargetLun)targetLun);
                if (String.valueOf(XveEuumDefineParent.RUNNING_STATUS_E.SYNCHRONIZING.getValue()).equals(targetLun.getRunningState())) {
                    return true;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("Updating hyperClone pair failed. devSn:" + clonePair.getDeviceSn() + ",SrcLunId:" + clonePair.getSrcLunId() + ",TgtLunId:" + clonePair.getTgtLunId() + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
        return false;
    }
}

