/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.calculator;

import com.huawei.ism.array.sdk.model.HvsUnit;
import com.huawei.ism.array.sdk.model.HyperMetroConsistentGroup;
import com.huawei.ism.array.sdk.model.HyperMetroPair;
import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.proxy.xve.XveEnumDefine;
import com.huawei.ism.cbb.proxy.xve.XveEuumDefineParent;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.calculator.BaseRecoveryPointObjectiveCalculator;
import com.huawei.ism.drm.protection.calculator.sdk.model.RPOContext;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.storage.service.router.StorageResourceServiceRouter;
import com.huawei.ism.unistor.sdk.model.NasFileSystem;
import com.huawei.ism.unistor.sdk.model.VstoreHyperMetroPair;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ArrayHyperMetroRecoveryPointObjectiveCalculator
extends BaseRecoveryPointObjectiveCalculator {
    public static final Log logger = LogFactory.getInstance(ArrayHyperMetroRecoveryPointObjectiveCalculator.class);
    private static final String RPO_KEY = "KEY";
    private static final String REMOTE_SITE = "REMOTE_SITE";
    private final String comma = ",";

    public List<String> getTypes() {
        return Arrays.asList("15");
    }

    protected Map<String, Object> calcConfiguredRPO(RPOContext context) {
        HashMap<String, Object> configuredRPO = new HashMap<String, Object>();
        Object pgobject = context.getObject("PG_ENTITY");
        if (pgobject == null) {
            return configuredRPO;
        }
        ProtectGroup protectGroup = (ProtectGroup)pgobject;
        String key = ",,";
        context.addObject(RPO_KEY, (Object)key);
        String vstorePairId = (String)protectGroup.getProps().get("PROP_KEY_VSTORE_PAIR_ID");
        String vstoreId = (String)protectGroup.getProps().get("PROP_KEY_VSTORE_ID");
        String devSN1 = null;
        String devSN2 = null;
        if (!VerifyUtil.isEmpty((String)vstoreId) && !VerifyUtil.isEmpty((String)vstorePairId)) {
            List<VstoreHyperMetroPair> vstoreHyperMetroPairs = this.getVstorePairInfo(context, vstoreId, vstorePairId);
            if (this.checkResourceSize(configuredRPO, key, vstoreHyperMetroPairs)) {
                return configuredRPO;
            }
            devSN1 = this.getVestorePairDevSn(vstoreHyperMetroPairs.get(0));
            devSN2 = this.getVestorePairDevSn(vstoreHyperMetroPairs.get(1));
        } else {
            String wwn = this.randomALunWwn(protectGroup);
            if (wwn == null) {
                configuredRPO.put(key, 0);
                return configuredRPO;
            }
            ArrayList<String> wwnList = new ArrayList<String>();
            wwnList.add(wwn);
            List<Lun> storageResources = this.getStorageResources(context, wwnList);
            if (this.checkResourceSize(configuredRPO, key, storageResources)) {
                return configuredRPO;
            }
            Iterator<Lun> iterator = storageResources.iterator();
            StorageResource storageResource = (StorageResource)iterator.next();
            devSN1 = storageResource.getDevSn() == null ? "" : storageResource.getDevSn();
            StorageResource storageResourceOther = (StorageResource)iterator.next();
            devSN2 = storageResourceOther.getDevSn() == null ? "" : storageResourceOther.getDevSn();
        }
        StringBuilder keyStringBuilder = new StringBuilder();
        keyStringBuilder.append(",");
        Site site = this.getSiteByResourceSN(devSN1);
        String siteId = site == null ? "" : site.getSiteId();
        keyStringBuilder.append(siteId + ",");
        site = this.getSiteByResourceSN(devSN2);
        siteId = site == null ? "" : site.getSiteId();
        keyStringBuilder.append(siteId);
        configuredRPO.put(keyStringBuilder.toString(), 0);
        context.addObject(RPO_KEY, (Object)keyStringBuilder.toString());
        return configuredRPO;
    }

    private String getVestorePairDevSn(VstoreHyperMetroPair vstoreHyperMetroPair) {
        ManagedObject managedObject = vstoreHyperMetroPair.getParentMo();
        if (managedObject instanceof HvsUnit) {
            String devSn = ((HvsUnit)managedObject).getDevSn();
            return devSn == null ? "" : devSn;
        }
        return "";
    }

    private boolean checkResourceSize(Map<String, Object> configuredRPO, String key, List storageResources) {
        if (VerifyUtil.isEmpty((Collection)storageResources) || storageResources.size() != 2) {
            logger.warn((Object)"storageResources is empty! or storageResources size is not two!", 90160758786897L);
            configuredRPO.put(key, 0);
            return true;
        }
        return false;
    }

    private List<Lun> getStorageResources(RPOContext context, List<String> wwnList) {
        ArrayList<Lun> lunList = new ArrayList();
        String serverUuid = this.getServerUuid(context);
        try {
            lunList = StorageResourceServiceRouter.getInstance().getStorageResourcesByWwns(serverUuid, wwnList, Lun.class);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("query the storageResources error!wwnList:" + wwnList + ",serverUuid:" + serverUuid), (Throwable)e);
        }
        return lunList;
    }

    private List<VstoreHyperMetroPair> getVstorePairInfo(RPOContext context, String vstoreId, String vstorePairId) {
        String serverUuid = this.getServerUuid(context);
        ArrayList<VstoreHyperMetroPair> result = new ArrayList<VstoreHyperMetroPair>();
        try {
            VstoreHyperMetroPair condition = new VstoreHyperMetroPair();
            condition.setVstorePairId(vstorePairId);
            condition.setLocalVstoreId(vstoreId);
            List vstoreHyperMetroPairList = StorageResourceServiceRouter.getInstance().getVstoreHyperPair(serverUuid, condition);
            if (!VerifyUtil.isEmpty((Collection)vstoreHyperMetroPairList)) {
                VstoreHyperMetroPair vstoreHyperMetroPair = (VstoreHyperMetroPair)vstoreHyperMetroPairList.get(0);
                condition.setLocalVstoreId(vstoreHyperMetroPair.getRemoteVstoreId());
                condition.setRemoteVstoreId(vstoreHyperMetroPair.getLocalVstoreId());
                result.add(vstoreHyperMetroPair);
                vstoreHyperMetroPairList = StorageResourceServiceRouter.getInstance().getVstoreHyperPair(serverUuid, condition);
                if (!VerifyUtil.isEmpty((Collection)vstoreHyperMetroPairList)) {
                    result.add((VstoreHyperMetroPair)vstoreHyperMetroPairList.get(0));
                }
            }
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("query the getVstorePairInfo error! vstoreId:" + vstoreId + "vstorePairId:" + vstorePairId + ",serverUuid:" + serverUuid), (Throwable)e);
        }
        return result;
    }

    private String getServerUuid(RPOContext context) {
        Object siteObj = context.getObject(REMOTE_SITE);
        String serverUuid = null;
        if (siteObj instanceof Site) {
            serverUuid = ((Site)siteObj).getServerUuid();
        }
        return serverUuid;
    }

    protected String randomALunWwn(ProtectGroup protectGroup) {
        Set polist = protectGroup.getPolist();
        if (VerifyUtil.isEmpty((Collection)polist)) {
            logger.warn((Object)"polist is empty!", 90160758786897L);
            return null;
        }
        ProtectObject po = (ProtectObject)polist.iterator().next();
        Set usedStorageResourceSet = po.getUsedStorageResourceSet();
        if (VerifyUtil.isEmpty((Collection)usedStorageResourceSet)) {
            logger.warn((Object)"usedStorageResourceSet is empty!", 90160758786897L);
            return null;
        }
        ProtectObjectStorageInfo usedStorageResourceInfo = (ProtectObjectStorageInfo)usedStorageResourceSet.iterator().next();
        String wwn = usedStorageResourceInfo.getLunWWN();
        return wwn;
    }

    protected Map<String, Object> calcActualRPO(RPOContext context) {
        HashMap<String, Object> actualRPO = new HashMap<String, Object>();
        Object pgobject = context.getObject("PG_ENTITY");
        if (pgobject == null) {
            return actualRPO;
        }
        ProtectGroup protectGroup = (ProtectGroup)pgobject;
        String productSiteId = protectGroup.getProductSiteId();
        Object keyObj = context.getObject(RPO_KEY);
        String key = keyObj == null ? "," + productSiteId + "," + productSiteId : (String)keyObj;
        String vstorePairId = (String)protectGroup.getProps().get("PROP_KEY_VSTORE_PAIR_ID");
        String vstoreId = (String)protectGroup.getProps().get("PROP_KEY_VSTORE_ID");
        List<HyperMetroPair> pairList = null;
        ArrayList<String> resourceIds = new ArrayList<String>(this.getAllWwns(protectGroup));
        if (!VerifyUtil.isEmpty((String)vstoreId) && !VerifyUtil.isEmpty((String)vstorePairId)) {
            if (this.isDeviceOffOnline(context, vstoreId, vstorePairId).booleanValue()) {
                actualRPO.put(key, -2);
                return actualRPO;
            }
            pairList = this.getNasHyperPairList(protectGroup, actualRPO, key, resourceIds);
        } else {
            if (this.isDeviceOffOnline(context, resourceIds).booleanValue()) {
                actualRPO.put(key, -2);
                return actualRPO;
            }
            pairList = this.getSanHyperPairList(context, protectGroup, actualRPO, key, resourceIds);
        }
        if (VerifyUtil.isEmpty(pairList)) {
            return actualRPO;
        }
        if (!this.checkPairStatusAndDataStatus(pairList, protectGroup, actualRPO, key)) {
            return actualRPO;
        }
        actualRPO.put(key, 0);
        return actualRPO;
    }

    private boolean checkPairStatusAndDataStatus(List<HyperMetroPair> pairList, ProtectGroup protectGroup, Map<String, Object> actualRPO, String key) {
        for (HyperMetroPair pair : pairList) {
            String runningState = pair.getRunningState();
            String healthStatus = pair.getHealthState();
            int runningStateInt = NumberUtil.convertToInteger((Object)runningState, (int)0);
            int localDataState = pair.getLocalDataState();
            int remoteDataState = pair.getRemoteDataState();
            String healthNormalStatus = XveEuumDefineParent.HEALTH_STATUS_E.NORMAL.getValue() + "";
            if (runningStateInt == XveEuumDefineParent.RUNNING_STATUS_E.NORMAL.getValue() && healthNormalStatus.equals(healthStatus) && localDataState == XveEnumDefine.HC_DATA_STATE.HC_DATA_INTEGRITY.getValue() && remoteDataState == XveEnumDefine.HC_DATA_STATE.HC_DATA_INTEGRITY.getValue()) continue;
            logger.warn((Object)("The running status is not nomal or the data status is not integrated!" + protectGroup.getName() + "./n pair:" + this.getPairStr(pair)), 90160758786897L);
            actualRPO.put(key, -3);
            return false;
        }
        if (!this.checkConsistentGroup(pairList)) {
            actualRPO.put(key, -3);
            return false;
        }
        if (!this.checkVstorePair(pairList)) {
            actualRPO.put(key, -3);
            return false;
        }
        return true;
    }

    private List<HyperMetroPair> getSanHyperPairList(RPOContext context, ProtectGroup protectGroup, Map<String, Object> actualRPO, String key, List<String> wwnList) {
        List pairList;
        String serverUuid = this.getServerUuid(context);
        try {
            StorageResourceServiceRouter storageService = StorageResourceServiceRouter.getInstance();
            pairList = storageService.getHyperMetroPairsByWwns(serverUuid, wwnList, Boolean.valueOf(true), true);
        }
        catch (LegoCheckedException e) {
            this.dealException(actualRPO, protectGroup, key, e);
            pairList = null;
        }
        if (VerifyUtil.isEmpty((Collection)pairList) || pairList.size() != wwnList.size()) {
            logger.warn((Object)("ArrayHyperMetro pairList is empty or the size is not equal of the wwnList. protectGroup name:" + protectGroup.getName() + ". all wwns:" + wwnList), 90160758786897L);
            actualRPO.put(key, -3);
        }
        return pairList;
    }

    private List<HyperMetroPair> getNasHyperPairList(ProtectGroup protectGroup, Map<String, Object> actualRPO, String key, List<String> reourceIds) {
        String vstorePairId = (String)protectGroup.getProps().get("PROP_KEY_VSTORE_PAIR_ID");
        ArrayList<HyperMetroPair> pairList = new ArrayList<HyperMetroPair>();
        try {
            String devSn = this.getStorageDevSn(protectGroup);
            String resourceId = (String)CommonUtil.getFirstElement(reourceIds);
            List nasFileSystems = StorageResourceServiceRouter.getInstance().getStorageResourcesByIds(devSn, Arrays.asList(resourceId), NasFileSystem.class);
            if (VerifyUtil.isEmpty((Collection)nasFileSystems)) {
                logger.error((Object)("getNasFileSystem is empty:" + devSn + ",resourceId" + resourceId));
                actualRPO.put(key, -3);
                return pairList;
            }
            String vstoreId = ((NasFileSystem)CommonUtil.getFirstElement((Collection)nasFileSystems)).getVstoreId();
            List tempList = StorageResourceServiceRouter.getInstance().getHyperMetroPairsByVstore(devSn, vstoreId);
            for (HyperMetroPair hyperMetroPair : tempList) {
                if (!vstorePairId.equals(hyperMetroPair.getVstorePairId()) || !reourceIds.contains(hyperMetroPair.getLocalObjId())) continue;
                pairList.add(hyperMetroPair);
            }
        }
        catch (LegoCheckedException e) {
            this.dealException(actualRPO, protectGroup, key, e);
        }
        if (VerifyUtil.isEmpty(pairList) || pairList.size() != reourceIds.size()) {
            logger.warn((Object)("ArrayHyperMetro pairList is empty or the size is not equal of the wwnList. protectGroup name:" + protectGroup.getName() + ". all wwns:" + reourceIds), 90160758786897L);
            actualRPO.put(key, -3);
        }
        return pairList;
    }

    private boolean checkConsistentGroup(List<HyperMetroPair> pairList) {
        HyperMetroPair hyperMetroPair = pairList.get(0);
        String cgId = hyperMetroPair.getCgId();
        String devSn = hyperMetroPair.getDevSn();
        if (VerifyUtil.isEmpty((String)cgId) || "--".equals(cgId)) {
            return true;
        }
        HyperMetroConsistentGroup cg = null;
        try {
            cg = StorageResourceServiceRouter.getInstance().getHyperMetroConsistentGroup(devSn, cgId, true);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("query the hyperMetroConsistentGroup error! cgId:" + cgId + ", devSn:" + devSn));
        }
        if (cg == null) {
            logger.error((Object)"cg is null!");
            return false;
        }
        String healthState = cg.getHealthState();
        String runningState = cg.getRunningState();
        String normalStatus = XveEuumDefineParent.RUNNING_STATUS_E.NORMAL.getValue() + "";
        String healthNormalStatus = XveEuumDefineParent.HEALTH_STATUS_E.NORMAL.getValue() + "";
        if (!normalStatus.equals(runningState) || !healthNormalStatus.equals(healthState)) {
            logger.warn((Object)("The consistent group running status is not nomal!pair:" + this.getPairStr(hyperMetroPair) + ". cg running status:" + runningState + ", normalStatus:" + normalStatus));
            return false;
        }
        return true;
    }

    private boolean checkVstorePair(List<HyperMetroPair> pairList) {
        HyperMetroPair hyperMetroPair = pairList.get(0);
        String vstorePairId = hyperMetroPair.getVstorePairId();
        String devSn = hyperMetroPair.getDevSn();
        if (VerifyUtil.isEmpty((String)vstorePairId) || "--".equals(vstorePairId)) {
            return true;
        }
        VstoreHyperMetroPair vstoreHyperMetroPair = null;
        try {
            vstoreHyperMetroPair = StorageResourceServiceRouter.getInstance().getVstoreHyperMetroPairByVstorePairId(devSn, vstorePairId);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("query the VstoreHyperMetroPair error! vstorePairId:" + vstorePairId + ", devSn:" + devSn));
        }
        if (vstoreHyperMetroPair == null) {
            logger.error((Object)"vstoreHyperMetroPair is null!");
            return false;
        }
        String healthState = vstoreHyperMetroPair.getHealthStatus();
        String runningState = vstoreHyperMetroPair.getRunningStatus();
        String normalStatus = XveEuumDefineParent.RUNNING_STATUS_E.NORMAL.getValue() + "";
        String healthNormalStatus = XveEuumDefineParent.HEALTH_STATUS_E.NORMAL.getValue() + "";
        if (!normalStatus.equals(runningState) || !healthNormalStatus.equals(healthState)) {
            logger.warn((Object)("The vstoreHyperMetroPair running status is not nomal!pair:" + this.getPairStr(hyperMetroPair) + ". vstoreHyperMetroPair running status:" + runningState + ", normalStatus:" + normalStatus));
            return false;
        }
        return true;
    }

    protected Set<String> getAllWwns(ProtectGroup protectGroup) {
        HashSet<String> wwnSet = new HashSet<String>();
        Set polist = protectGroup.getPolist();
        for (ProtectObject po : polist) {
            Set usedStorageResourceSet = po.getUsedStorageResourceSet();
            for (ProtectObjectStorageInfo storageInfo : usedStorageResourceSet) {
                if (Integer.valueOf(DrmEnumDefine.ResourceTypeE.NAS.getValue()).equals(storageInfo.getResourceType())) {
                    wwnSet.add(storageInfo.getResourceId());
                    continue;
                }
                String wwn = storageInfo.getLunWWN();
                wwnSet.add(wwn);
            }
        }
        return wwnSet;
    }

    private String getStorageDevSn(ProtectGroup protectGroup) {
        Set polist = protectGroup.getPolist();
        if (!VerifyUtil.isEmpty((Collection)polist)) {
            for (ProtectObject po : polist) {
                Set usedStorageResourceSet = po.getUsedStorageResourceSet();
                Iterator iterator = usedStorageResourceSet.iterator();
                if (!iterator.hasNext()) continue;
                ProtectObjectStorageInfo storageInfo = (ProtectObjectStorageInfo)iterator.next();
                return storageInfo.getResourceProviderSN();
            }
        }
        return null;
    }

    private Boolean isDeviceOffOnline(RPOContext context, List<String> wwnList) {
        List<Lun> storageResources = this.getStorageResources(context, wwnList);
        for (StorageResource storageResource : storageResources) {
            int storageStatus = this.getStorageStatus(storageResource.getDevSn());
            if (storageStatus == 0) continue;
            return true;
        }
        return false;
    }

    private Boolean isDeviceOffOnline(RPOContext context, String vstoreId, String vestorePairId) {
        List<VstoreHyperMetroPair> vstoreHyperMetroPairs = this.getVstorePairInfo(context, vstoreId, vestorePairId);
        for (VstoreHyperMetroPair vp : vstoreHyperMetroPairs) {
            int storageStatus = this.getStorageStatus(this.getVestorePairDevSn(vp));
            if (storageStatus == 0) continue;
            return true;
        }
        return false;
    }

    protected String getSiteId(String str) {
        String[] array = str.split(",");
        if (array.length != 3) {
            logger.error((Object)"getSiteId error!", 90160758787071L);
            return "";
        }
        return array[2];
    }

    protected Object getProductSiteId(String key) {
        String[] array = key.split(",");
        if (array.length != 3) {
            logger.error((Object)"getSiteId error!", 90160758787071L);
            return "";
        }
        return array[1];
    }

    private void dealException(Map<String, Object> actualRPO, ProtectGroup protectGroup, String key, LegoCheckedException e) {
        logger.error((Object)("query hyperMetro pair error! " + protectGroup.getName() + ", error : " + (Object)((Object)e)), e.getErrorCode());
        if (e.getErrorCode() == 104403L || e.getErrorCode() == 1073947647L) {
            actualRPO.put(key, -2);
        } else {
            actualRPO.put(key, -3);
        }
    }

    private String getPairStr(HyperMetroPair pair) {
        StringBuilder sb = new StringBuilder();
        String uuid = pair.getUuid();
        String resourceWwn = pair.getResourceWwn();
        String localObjId = pair.getLocalObjId();
        String remoteObjId = pair.getRemoteObjId();
        String remoteDevSn = pair.getRemoteDevSn();
        sb.append("pairUuid:" + uuid).append(",").append("runningStatus:" + pair.getRunningState()).append(",").append("localDataStatus:" + pair.getLocalDataState()).append(",").append("remoteDataStatus:" + pair.getRemoteDataState()).append(",").append("healthStatus:" + pair.getHealthState()).append(",").append("resourceWwn:" + resourceWwn).append(",").append("localObjId:" + localObjId).append(",").append("remoteObjId:" + remoteObjId).append(",").append("remoteDevSn:" + remoteDevSn).append("]");
        return sb.toString();
    }
}

