/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.interceptor.lun.group;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.drm.storage.manager.proxy.StorageLunGroupManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageLunGroupManager;
import com.huawei.lego.cbb.resource.rollback.IRollbackItem;
import java.util.ArrayList;
import java.util.List;

public class LunRollbackItem
implements IRollbackItem {
    private String devSn;
    private String consistencyGroupId;
    private List<Lun> luns;

    public LunRollbackItem(String devSn, String consistencyGroupId, Lun lun) {
        this.devSn = devSn;
        this.consistencyGroupId = consistencyGroupId;
        this.luns = new ArrayList<Lun>();
        this.luns.add(lun);
    }

    public LunRollbackItem(String devSn, String consistencyGroupId, String lunId) {
        this.devSn = devSn;
        this.consistencyGroupId = consistencyGroupId;
        this.luns = new ArrayList<Lun>();
        Lun lun = new Lun();
        lun.setDevSn(devSn);
        lun.setResourceId(lunId);
        this.luns.add(lun);
    }

    public String getDevSn() {
        return this.devSn;
    }

    public void setDevSn(String devSn) {
        this.devSn = devSn;
    }

    public String getConsistencyGroupId() {
        return this.consistencyGroupId;
    }

    public void setConsistencyGroupId(String consistencyGroupId) {
        this.consistencyGroupId = consistencyGroupId;
    }

    public List<Lun> getLuns() {
        return this.luns;
    }

    public void setLuns(List<Lun> luns) {
        this.luns = luns;
    }

    public boolean execute() {
        IStorageLunGroupManager lunGroupManager = StorageLunGroupManagerProxy.getInstance().getStorageSnapshotMgrByDevId(this.devSn);
        for (Lun lun : this.luns) {
            lunGroupManager.remove(this.devSn, this.consistencyGroupId, lun.getResourceId());
        }
        return true;
    }
}

