/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.path.builder;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.storage.protection.path.builder.ArrayAsyncHyperMetroProtectionPath;
import com.huawei.ism.drm.storage.protection.util.HyperDRRingPathUtil;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.lego.core.sdk.comm.BatchOperation;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.system.context.ExecutionContext;
import java.util.List;

public class ArrayAsyncHyperMetroRingProtectionPath
extends ArrayAsyncHyperMetroProtectionPath {
    private static final Log logger = LogFactory.getInstance(ArrayAsyncHyperMetroRingProtectionPath.class);

    @Override
    public int getPolicyTemplateType() {
        logger.debug((Object)"getPolicyTemplateType ProtectionPathBuilder: ArrayAsyncHyperMetroRingProtectionPath");
        return 27;
    }

    @Override
    protected String getSiteRelationStr(ProtectGroup protectgroup, ExecutionContext context) {
        StringBuilder siteRelationStr = new StringBuilder();
        StringBuilder errorMsg = new StringBuilder();
        errorMsg.append("pgname:" + protectgroup.getName());
        try {
            ReplicationPair pair;
            List repTgtLuns;
            BatchOperation batchOperation = this.getBatchOperation(context);
            ProtectObjectStorageInfo posi = this.randomSelectPOStorageInfo(protectgroup, batchOperation);
            String srcResourceProviderSN = posi.getResourceProviderSN();
            String srcResourceId = posi.getResourceId();
            Site srcSite = this.getSiteByStorageSn(srcResourceProviderSN);
            siteRelationStr.append(srcSite == null ? "" : srcSite.getName());
            siteRelationStr.append(" -(normal)-> ");
            Lun lun = this.checkLunExsist(srcResourceProviderSN, srcResourceId);
            List<ReplicationPair> pairs = this.getPairsByLun(lun, true);
            if (VerifyUtil.isEmpty(pairs)) {
                logger.error((Object)("the pairs is empty! resourceId:" + srcResourceId + ", providerSN:" + srcResourceProviderSN));
                pairs = this.getPairsByLun(lun, false);
            }
            if ((repTgtLuns = (pair = HyperDRRingPathUtil.getTarReplicationPair(pairs, false)).getRepTgtLuns()) == null || repTgtLuns.isEmpty()) {
                logger.error((Object)("the repTgtLuns is empty! resourceId:" + srcResourceId + ", providerSN:" + srcResourceProviderSN));
                return siteRelationStr.toString();
            }
            ReplicationTargetLun replicationTargetLun = (ReplicationTargetLun)repTgtLuns.iterator().next();
            String targetDevSn = replicationTargetLun.getTgtDevSN();
            Site targetSite = this.getSiteByStorageSn(targetDevSn);
            siteRelationStr.append(targetSite == null ? "" : targetSite.getName());
            siteRelationStr.append(" -- ");
            Lun targetLun = this.checkLunExsist(targetDevSn, replicationTargetLun.getTgtLunId());
            if (null == targetLun) {
                return siteRelationStr.toString();
            }
            String wwn = targetLun.getWwn();
            StorageResource otherStorageResource = this.getHyperMetroOtherStorageResource(targetDevSn, targetSite, wwn);
            if (otherStorageResource == null) {
                return siteRelationStr.toString();
            }
            Site otherSite = this.getSiteByStorageSn(otherStorageResource.getDevSn());
            siteRelationStr.append(otherSite == null ? "" : otherSite.getName());
            siteRelationStr.append("\n");
            ReplicationPair standPair = HyperDRRingPathUtil.getTarReplicationPair(pairs, true);
            List standRepTgtLuns = standPair.getRepTgtLuns();
            if (standRepTgtLuns == null || standRepTgtLuns.isEmpty()) {
                logger.error((Object)("the standRepTgtLuns is empty! resourceId:" + srcResourceId + ", providerSN:" + srcResourceProviderSN));
                return siteRelationStr.toString();
            }
            ReplicationTargetLun standRepTgtLun = (ReplicationTargetLun)standRepTgtLuns.iterator().next();
            Site product = this.getSiteByStorageSn(standRepTgtLun.getDevSn());
            Site recovery = this.getSiteByStorageSn(standRepTgtLun.getTgtDevSN());
            siteRelationStr.append(product == null ? "" : product.getName());
            siteRelationStr.append(" -(standby)-> ");
            siteRelationStr.append(recovery == null ? "" : recovery.getName());
        }
        catch (Exception e) {
            logger.error((Object)("getSiteRelationStr error.msg : " + errorMsg + "," + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
        return siteRelationStr.toString();
    }
}

