/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.path.builder;

import com.huawei.ism.array.sdk.model.HvsUnit;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.protection.framework.service.path.AbstractProtectionPathImpl;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.path.sdk.model.ProtectionPath;
import com.huawei.ism.drm.protection.path.sdk.model.ProtectionPathData;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.ism.unistor.sdk.model.VstoreHyperMetroPair;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.comm.BatchOperation;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.system.context.ExecutionContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;

public class ArrayHyperMetroProtectionPath
extends AbstractProtectionPathImpl {
    protected static final String CL_LOCAL_ID = "localObjId";
    protected static final String CL_REMOTE_ID = "remoteObjId";
    private static final Log logger = LogFactory.getInstance(ArrayHyperMetroProtectionPath.class);

    public ProtectionPathData buildPath(ProtectGroup protectgroup, Map<String, ? extends StorageResource> luns, BatchOperation batchOperation) {
        ExecutionContext context = this.init(luns, batchOperation);
        ArrayList<ProtectionPath> pathList = new ArrayList<ProtectionPath>();
        ProtectionPath siteprotectionpath = new ProtectionPath();
        ProtectionPath protectionpath = new ProtectionPath();
        ArrayList<String> sitePathDetails = new ArrayList<String>();
        ArrayList<String> rdPathDetails = new ArrayList<String>();
        ArrayList<List<String>> siteResOrder = new ArrayList<List<String>>();
        sitePathDetails.add(this.getSiteRelation(protectgroup, siteResOrder, context));
        siteprotectionpath.setPathDetails(sitePathDetails);
        pathList.add(siteprotectionpath);
        if (VerifyUtil.isEmpty(siteResOrder)) {
            logger.error((Object)("siteResOrder is empty!" + protectgroup.getName()), 90160758786897L);
            this.getBatchOperation(context).setErrorCode(-1L);
            return new ProtectionPathData();
        }
        rdPathDetails.add(this.getRDPath(protectgroup, siteResOrder, context));
        protectionpath.setPathDetails(rdPathDetails);
        pathList.add(protectionpath);
        ProtectionPathData ppd = new ProtectionPathData(pathList);
        if (batchOperation.getErrorCode() != 0L) {
            batchOperation.setTargetName(protectgroup.getName());
            ppd.setOperation(batchOperation);
        }
        return ppd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String getVstorePairIdByPg(ProtectGroup protectGroup) {
        String string;
        Session session;
        block5: {
            session = null;
            logger.debug((Object)("pgId:" + protectGroup.getUuid()));
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            String strSQL = "select PROPVALUE from ti_protectgroup_prop where PGID=:pgId and PROPNAME=:pgName";
            NativeQuery query = session.createSQLQuery(strSQL);
            query.setString("pgId", protectGroup.getUuid());
            query.setString("pgName", "PROP_KEY_VSTORE_PAIR_ID");
            List results = query.list();
            if (VerifyUtil.isEmpty((Collection)results)) break block5;
            String vstorePairId = (String)results.get(0);
            protectGroup.getProps().put("PROP_KEY_VSTORE_PAIR_ID", vstorePairId);
            String string2 = vstorePairId;
            DBOperationUtil.closeSession((Session)session);
            return string2;
        }
        try {
            string = null;
        }
        catch (Exception e) {
            try {
                logger.error((Object)("getVstorePairIdByPg failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession((Session)session);
            return null;
        }
        DBOperationUtil.closeSession((Session)session);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected List<StorageResource> getNasFileSystem(String vStorePairId, String nasFileId, String key) {
        List list;
        List list2;
        Session session;
        block7: {
            block6: {
                session = null;
                if (CL_LOCAL_ID.equals(key) || CL_REMOTE_ID.equals(key)) break block6;
                logger.error((Object)("getNasFileSystem failed. key:" + key), 90160758784001L);
                List list3 = Collections.EMPTY_LIST;
                DBOperationUtil.closeSession((Session)session);
                return list3;
            }
            session = CommonDAOLocator.getMoDao().getHibernateTemplate().getSessionFactory().openSession();
            StringBuilder strHQL = new StringBuilder();
            strHQL.append("select fs from NasFileSystem fs, HyperMetroPair hmp ");
            strHQL.append("where hmp.localObjId = fs.resourceId ");
            strHQL.append("and fs.devSn = hmp.devSn and hmp.vstorePairId=:vstorePairId ");
            strHQL.append("and hmp.").append(key).append("=:nasFileId");
            Query query = session.createQuery(strHQL.toString());
            query.setString("vstorePairId", vStorePairId);
            query.setString("nasFileId", nasFileId);
            list2 = query.list();
            if (!VerifyUtil.isEmpty((Collection)list2)) break block7;
            List list4 = Collections.EMPTY_LIST;
            DBOperationUtil.closeSession((Session)session);
            return list4;
        }
        try {
            list = list2;
        }
        catch (Exception e) {
            try {
                logger.error((Object)("Getting fs by nfs share failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession((Session)session);
            return Collections.EMPTY_LIST;
        }
        DBOperationUtil.closeSession((Session)session);
        return list;
    }

    protected String getVestorePairDevSn(VstoreHyperMetroPair vstoreHyperMetroPair) {
        ManagedObject managedObject = vstoreHyperMetroPair.getParentMo();
        if (managedObject instanceof HvsUnit) {
            String devSn = ((HvsUnit)managedObject).getDevSn();
            return devSn == null ? "" : devSn;
        }
        return "";
    }

    private String getRDPath(ProtectGroup protectgroup, List<List<String>> siteResOrder, ExecutionContext context) {
        StringBuffer sb = new StringBuffer();
        HashSet<String> items = new HashSet<String>();
        String vStorePairId = (String)protectgroup.getProps().get("PROP_KEY_VSTORE_PAIR_ID");
        boolean isNas = !VerifyUtil.isEmpty((String)vStorePairId);
        for (ProtectObject polist : protectgroup.getPolist()) {
            for (ProtectObjectStorageInfo protectobjectinfo : polist.getUsedStorageResourceSet()) {
                String resourceId = isNas ? protectobjectinfo.getResourceId() : protectobjectinfo.getLunWWN();
                if (items.contains(resourceId)) continue;
                items.add(resourceId);
                List storageResources = isNas ? this.getNasFileSystemByVstorePairId(protectobjectinfo.getResourceProviderSN(), resourceId, vStorePairId) : this.getStorageService().getStorageResourceByWwn(new String[]{resourceId});
                if (VerifyUtil.isEmpty(storageResources) || storageResources.size() != 2) {
                    logger.error((Object)("resources is empty or the size is not two!" + protectgroup.getName()), 90160758786897L);
                    this.getBatchOperation(context).setErrorCode(-1L);
                    return sb.toString();
                }
                String singlePath = this.getSinglePath(storageResources, siteResOrder);
                sb.append(singlePath).append(";\n");
            }
        }
        return sb.delete(sb.length() - 2, sb.length()).toString();
    }

    private List<StorageResource> getNasFileSystemByVstorePairId(String sn, String nasFileId, String vStorePairId) {
        ArrayList<StorageResource> result = new ArrayList<StorageResource>();
        List<StorageResource> list = this.getNasFileSystem(vStorePairId, nasFileId, CL_LOCAL_ID);
        for (StorageResource storageResource : list) {
            if (!storageResource.getDevSn().equals(sn)) continue;
            result.add(storageResource);
        }
        list = this.getNasFileSystem(vStorePairId, nasFileId, CL_REMOTE_ID);
        for (StorageResource storageResource : list) {
            if (storageResource.getDevSn().equals(sn)) continue;
            result.add(storageResource);
        }
        return result;
    }

    private String getSinglePath(List<StorageResource> storageResources, List<List<String>> siteResOrder) {
        StringBuilder sb = new StringBuilder();
        StorageResource storageResourceA = storageResources.get(0);
        DrResource resourceA = this.getStorageBySn(storageResourceA.getDevSn());
        StorageResource storageResourceB = storageResources.get(1);
        DrResource resourceB = this.getStorageBySn(storageResourceB.getDevSn());
        List<String> siteResOrderA = siteResOrder.get(0);
        String ipAddressA = "";
        String ipAddressB = "";
        if (resourceA == null) {
            logger.error((Object)("resourceA is null! devSn : " + storageResourceA.getDevSn()), 90160758786897L);
        } else {
            ipAddressA = resourceA.getIpAddress();
        }
        if (resourceB == null) {
            logger.error((Object)("resourceB is null! devSn : " + storageResourceB.getDevSn()), 90160758786897L);
        } else {
            ipAddressB = resourceB.getIpAddress();
        }
        if (siteResOrderA.contains(ipAddressA)) {
            sb.append(storageResourceA.getName()).append("(").append(ipAddressA).append(")").append(" -- ").append(storageResourceB.getName()).append("(").append(ipAddressB).append(")");
        } else {
            sb.append(storageResourceB.getName()).append("(").append(ipAddressB).append(")").append(" -- ").append(storageResourceA.getName()).append("(").append(ipAddressA).append(")");
        }
        return sb.toString();
    }

    private String getSiteRelation(ProtectGroup protectgroup, List<List<String>> siteResOrder, ExecutionContext context) {
        Set polist = protectgroup.getPolist();
        if (VerifyUtil.isEmpty((Collection)polist)) {
            logger.error((Object)("protect object is empty! protectGroup name : " + protectgroup.getName()), 1073947394L);
            this.getBatchOperation(context).setErrorCode(1073947394L);
            return "";
        }
        ProtectObject po = (ProtectObject)polist.iterator().next();
        Set usedStorageResourceSet = po.getUsedStorageResourceSet();
        if (VerifyUtil.isEmpty((Collection)usedStorageResourceSet)) {
            logger.error((Object)("usedStorageResourceSet is empty! protectGroup name : " + protectgroup.getName()), 1073947394L);
            this.getBatchOperation(context).setErrorCode(1073947394L);
            return "";
        }
        HashSet<String> devSnSet = new HashSet<String>();
        String vStorePairId = this.getVstorePairIdByPg(protectgroup);
        if (!VerifyUtil.isEmpty((String)vStorePairId)) {
            HashMap<String, String> condition = new HashMap<String, String>();
            condition.put("vstorePairId", vStorePairId);
            List vstoreHyperMetroPairList = CommonDAOLocator.getMoDao().findMoBy(VstoreHyperMetroPair.class, condition);
            if (VerifyUtil.isEmpty((Collection)vstoreHyperMetroPairList) || vstoreHyperMetroPairList.size() != 2) {
                logger.error((Object)("vstoreHyperMetroPairList is empty or the size is not two!" + protectgroup.getName()), 90160758786897L);
                this.getBatchOperation(context).setErrorCode(-1L);
                return "";
            }
            for (VstoreHyperMetroPair vstoreHyperMetroPair : vstoreHyperMetroPairList) {
                devSnSet.add(this.getVestorePairDevSn(vstoreHyperMetroPair));
            }
        } else {
            ProtectObjectStorageInfo protectObjectStorageInfo = (ProtectObjectStorageInfo)usedStorageResourceSet.iterator().next();
            String wwn = protectObjectStorageInfo.getLunWWN();
            List resources = ((IStorageService)ServiceLocator.getInstance().getService(IStorageService.class)).getStorageResourceByWwn(new String[]{wwn});
            if (VerifyUtil.isEmpty((Collection)resources) || resources.size() != 2) {
                logger.error((Object)("resources is empty or the size is not two!" + protectgroup.getName()), 90160758786897L);
                this.getBatchOperation(context).setErrorCode(-1L);
                return "";
            }
            for (StorageResource storageResource : resources) {
                devSnSet.add(storageResource.getDevSn());
            }
        }
        StringBuilder sbBuilder = new StringBuilder();
        ISiteService siteService = (ISiteService)ServiceLocator.getInstance().getService(ISiteService.class);
        for (String devSn : devSnSet) {
            Site site = this.getSiteByStorageSn(devSn);
            if (site == null) {
                logger.error((Object)("site is null! devSn : " + devSn + ", protectGroup Name : " + protectgroup.getName()), 90160758786897L);
                this.getBatchOperation(context).setErrorCode(-1L);
                continue;
            }
            this.setSiteResOrder(siteResOrder, siteService, site);
            sbBuilder.append(site.getName()).append(" -- ");
        }
        return sbBuilder.substring(0, sbBuilder.length() - 4);
    }

    private void setSiteResOrder(List<List<String>> siteResOrder, ISiteService siteService, Site site) {
        List drResources = siteService.getAllResourceBySite(site.getSiteId(), "ism.deviceType.storage.mainType");
        ArrayList<String> ipList = new ArrayList<String>();
        for (DrResource res : drResources) {
            ipList.add(res.getIpAddress());
        }
        siteResOrder.add(ipList);
    }

    public int getPolicyTemplateType() {
        return 15;
    }
}

