/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.path.builder;

import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.path.sdk.model.ProtectionPath;
import com.huawei.ism.drm.protection.path.sdk.model.ProtectionPathData;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.storage.protection.path.builder.CascadeSAsyncProtectionPath;
import com.huawei.lego.core.sdk.comm.BatchOperation;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.system.context.ExecutionContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ConCurrentSAsyncProtectionPath
extends CascadeSAsyncProtectionPath {
    private static final Log logger = LogFactory.getInstance(ConCurrentSAsyncProtectionPath.class);

    @Override
    public ProtectionPathData buildPath(ProtectGroup protectgroup, Map<String, ? extends StorageResource> luns, BatchOperation batchOperation) {
        ExecutionContext context = this.init(luns, batchOperation);
        ArrayList<ProtectionPath> pathList = new ArrayList<ProtectionPath>();
        ProtectionPath siteprotectionpath = new ProtectionPath();
        ProtectionPath recoveryprotectionpath = new ProtectionPath();
        ArrayList<String> sitePathDetails = new ArrayList<String>();
        ArrayList<String> rdPathDetails = new ArrayList<String>();
        sitePathDetails.add(this.getSiteRelation(protectgroup, context));
        siteprotectionpath.setPathDetails(sitePathDetails);
        pathList.add(siteprotectionpath);
        rdPathDetails.add(this.getRDPath(protectgroup, context));
        recoveryprotectionpath.setPathDetails(rdPathDetails);
        pathList.add(recoveryprotectionpath);
        ProtectionPathData ppd = new ProtectionPathData(pathList);
        if (batchOperation.getErrorCode() != 0L) {
            batchOperation.setTargetName(protectgroup.getName());
            ppd.setOperation(batchOperation);
        }
        ppd.setTemplateType(this.getPolicyTemplateType());
        if (!VerifyUtil.isEmpty((Object)context.getAttribute("ACTUAL_TEMPLATE_TYPE"))) {
            ppd.setTemplateType(((Integer)context.getAttribute("ACTUAL_TEMPLATE_TYPE")).intValue());
        }
        return ppd;
    }

    @Override
    public int getPolicyTemplateType() {
        return 5;
    }

    @Override
    protected String getSiteInfo(List<ProtectGroupReplica> replicalist, ExecutionContext context) {
        if (VerifyUtil.isEmpty(replicalist) || replicalist.size() < 2) {
            logger.error((Object)"replicalist is empty! size of replicalist is less than two!", 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
        Site siteA = this.getSiteByStorageSn(replicalist.get(0).getProductArray());
        Site siteB = this.getSiteByStorageSn(replicalist.get(0).getRecoveryArray());
        Site siteC = this.getSiteByStorageSn(replicalist.get(1).getProductArray());
        Site siteD = this.getSiteByStorageSn(replicalist.get(1).getRecoveryArray());
        if (null == siteA || null == siteB || null == siteC || null == siteD) {
            this.getBatchOperation(context).setErrorCode(1073948207L);
        }
        if (replicalist.get(1).getProtectLocation() == DrmEnumDefine.ProtectLocation.C_C.getValue()) {
            this.getActualTemplateType(replicalist.get(0), context);
            return this.getSiteHeadInfoDRRing(siteA, siteB, siteD, context);
        }
        return this.getSiteHeadInfo(siteA, siteB, siteC, siteD);
    }

    protected String getSiteHeadInfo(Site siteA, Site siteB, Site siteC, Site siteD) {
        StringBuffer sb = new StringBuffer();
        if (null != siteA && null != siteB && null != siteC && null != siteD) {
            sb.append(siteA.getName());
            sb.append(" --> ");
            sb.append(siteB.getName());
            sb.append(" + ");
            sb.append(siteC.getName());
            sb.append(" --> ");
            sb.append(siteD.getName() + "\n");
        }
        return sb.toString();
    }

    @Override
    protected RelicaStorageInfo[] getExist(List<RelicaStorageInfo[]> m, RelicaStorageInfo info) {
        RelicaStorageInfo[] result = null;
        for (RelicaStorageInfo[] each : m) {
            if (each == null || each.length < 2) continue;
            RelicaStorageInfo that = each[0];
            if (each[1] != null || !that.getSrcStorageProviderSN().equals(info.getSrcStorageProviderSN())) continue;
            result = each;
            break;
        }
        return result;
    }
}

