/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.replica.builder;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RemoteStorageReplica;
import com.huawei.ism.drm.protection.template.sdk.service.AbstractReplicaBuilder;
import com.huawei.ism.drm.storage.protection.template.filter.Array4DCCascadeAsyncAsyncFilter;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.system.context.ExecutionContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class Array4DCCascadeAsyncAsyncBuilder
extends AbstractReplicaBuilder {
    private static final Log logger = LogFactory.getInstance(Array4DCCascadeAsyncAsyncBuilder.class);
    private Array4DCCascadeAsyncAsyncFilter array4DCCascadeAsyncAsyncFilter;

    public void buildReplica(ProtectGroup protectGroup) {
        List siteInfoList;
        if (protectGroup == null) {
            logger.error((Object)"protectGroup is null", 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
        this.array4DCCascadeAsyncAsyncFilter.isMatchNotCheckStatus(new ArrayList<ProtectObject>(protectGroup.getPolist()));
        ProtectGroupUtil.clearRemoteReplicas((Set)protectGroup.getReplicaList());
        ExecutionContext siteAContext = (ExecutionContext)this.array4DCCascadeAsyncAsyncFilter.getFilterContext().get("SITE_A_CONTEXT");
        Map siteAPairMap = (Map)siteAContext.getAttribute("pairMap");
        if (!VerifyUtil.isEmpty((Map)siteAPairMap)) {
            List pairList = (List)((Map.Entry)siteAPairMap.entrySet().stream().findFirst().get()).getValue();
            ReplicationPair anyPair = (ReplicationPair)pairList.stream().findFirst().get();
            String siteDevSn = anyPair.getSrcDevSN();
            HashMap<String, ReplicationPair> repMap = new HashMap<String, ReplicationPair>();
            for (ReplicationPair replicationPair : pairList) {
                repMap.put(replicationPair.getSrcLunWWN(), replicationPair);
            }
            this.getBuilderContext().put("REPLICA_INDEX", 1);
            this.getBuilderContext().put("PROTECT_TYPE", anyPair.getReplicationMode());
            this.getBuilderContext().put("PROTECT_LOCATION", DrmEnumDefine.ProtectLocation.A_B.getValue());
            this.getBuilderContext().put("SRC_DEVICE", siteDevSn);
            this.generatePgReplicaByPair(protectGroup, repMap);
        }
        Map siteAWwnMap = (Map)siteAContext.getAttribute("wwnMap");
        ExecutionContext siteBContext = (ExecutionContext)this.array4DCCascadeAsyncAsyncFilter.getFilterContext().get("SITE_B_CONTEXT");
        Map siteBPairMap = (Map)siteBContext.getAttribute("pairMap");
        if (!VerifyUtil.isEmpty((Map)siteBPairMap)) {
            List pairList = (List)((Map.Entry)siteBPairMap.entrySet().stream().findFirst().get()).getValue();
            ReplicationPair anyPair = (ReplicationPair)pairList.stream().findFirst().get();
            String siteDevSn = anyPair.getSrcDevSN();
            HashMap<String, ReplicationPair> repMap = new HashMap<String, ReplicationPair>();
            for (ReplicationPair replicationPair : pairList) {
                repMap.put(replicationPair.getSrcLunWWN(), replicationPair);
                repMap.put((String)siteAWwnMap.get(replicationPair.getSrcLunWWN()), replicationPair);
            }
            this.getBuilderContext().put("REPLICA_INDEX", 2);
            this.getBuilderContext().put("PROTECT_TYPE", anyPair.getReplicationMode());
            this.getBuilderContext().put("PROTECT_LOCATION", DrmEnumDefine.ProtectLocation.B_C.getValue());
            this.getBuilderContext().put("SRC_DEVICE", siteDevSn);
            this.generatePgReplicaByPair(protectGroup, repMap);
        }
        if (null != (siteInfoList = (List)this.array4DCCascadeAsyncAsyncFilter.getFilterContext().get("siteInfoList"))) {
            protectGroup.getProps().put("PROP_KEY_SITE_INFO", JSONArray.fromObject((Object)siteInfoList).toString());
        }
    }

    protected void generatePgReplicaByPair(ProtectGroup protectGroup, Map<String, ReplicationPair> repMap) {
        ProtectGroupReplica protectGroupReplica = new ProtectGroupReplica();
        protectGroupReplica.setId(UUIDGenerator.getUUID());
        protectGroupReplica.setName("REMOTEREPLICA-" + protectGroup.getName() + "-" + this.getString("REPLICA_INDEX"));
        protectGroupReplica.setProductArray(this.getString("SRC_DEVICE"));
        protectGroupReplica.setType(this.getInt("PROTECT_TYPE"));
        protectGroupReplica.setIndex(this.getInt("REPLICA_INDEX"));
        protectGroupReplica.setPg(protectGroup);
        protectGroupReplica.setStatus(DrmEnumDefine.ReplicaStatus.UNACTIVE_STATUS.getValue());
        protectGroupReplica.setProtectLocation(this.getInt("PROTECT_LOCATION"));
        protectGroup.getReplicaList().add(protectGroupReplica);
        for (ProtectObject protectObject : protectGroup.getPolist()) {
            ProtectObjectReplica protectObjectReplica = new ProtectObjectReplica();
            protectObjectReplica.setId(UUIDGenerator.getUUID());
            protectObjectReplica.setPoId(protectObject.getUuid());
            protectObjectReplica.setPgReplica(protectGroupReplica);
            this.generatePosi(protectObject, protectObjectReplica, repMap);
            protectGroupReplica.getReplicas().add(protectObjectReplica);
        }
        Iterator<Map.Entry<String, ReplicationPair>> iterator = repMap.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry<String, ReplicationPair> replicationPairEntry = iterator.next();
            ReplicationPair firstPair = replicationPairEntry.getValue();
            logger.debug((Object)"protect group [%s] have pair of replica. pair: %s", new Object[]{protectGroup.getName(), firstPair});
            protectGroupReplica.setStatus(Objects.equals(firstPair.getReplicationMode(), 1) ? DrmEnumDefine.ReplicaStatus.ACTIVE_STATUS.getValue() : DrmEnumDefine.ReplicaStatus.UNACTIVE_STATUS.getValue());
        }
        logger.info((Object)"Pg name:%s, src dev sn:%s, tgt dev sn:%s, protect location:%s.", new Object[]{protectGroup.getName(), this.getString("SRC_DEVICE"), protectGroupReplica.getRecoveryArray(), this.getInt("PROTECT_LOCATION")});
    }

    private void generatePosi(ProtectObject protectObject, ProtectObjectReplica protectObjectReplica, Map<String, ReplicationPair> repMap) {
        for (ProtectObjectStorageInfo posi : protectObject.getUsedStorageResourceSet()) {
            ReplicationPair replicationPair = repMap.get(posi.getLunWWN());
            if (VerifyUtil.isEmpty((Object)replicationPair)) {
                logger.warn((Object)("no pair for:" + posi.getResourceName()));
                continue;
            }
            for (ReplicationTargetLun replicationTargetLun : replicationPair.getRepTgtLuns()) {
                RemoteStorageReplica remoteStorageReplica = new RemoteStorageReplica();
                remoteStorageReplica.setId(UUIDGenerator.getUUID());
                remoteStorageReplica.setSrcStorageId(replicationPair.getSrcLunId());
                remoteStorageReplica.setSrcStorageProviderSN(replicationPair.getSrcDevSN());
                remoteStorageReplica.setStorageId(replicationTargetLun.getTgtLunId());
                remoteStorageReplica.setStorageProviderSN(replicationTargetLun.getTgtDevSN());
                remoteStorageReplica.setPoReplica(protectObjectReplica);
                remoteStorageReplica.setReplicationPairId(replicationPair.getReplicationId());
                remoteStorageReplica.setConsistentGroupId(replicationPair.getConsistentGroupId());
                remoteStorageReplica.setSynchronization(Boolean.valueOf(1 == replicationPair.getReplicationMode()));
                remoteStorageReplica.setProtectObjectStorageWwn(posi.getLunWWN());
                protectObjectReplica.getStorageInfos().add(remoteStorageReplica);
                protectObjectReplica.getPgReplica().setRecoveryArray(replicationTargetLun.getTgtDevSN());
                String recoverySiteId = this.getSiteBySn(replicationTargetLun.getTgtDevSN());
                protectObjectReplica.getPgReplica().setRecoverySite(recoverySiteId);
            }
        }
    }

    public int getType() {
        return 35;
    }

    public void setArray4DCCascadeAsyncAsyncFilter(Array4DCCascadeAsyncAsyncFilter array4DCCascadeAsyncAsyncFilter) {
        this.array4DCCascadeAsyncAsyncFilter = array4DCCascadeAsyncAsyncFilter;
    }
}

