/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.protection.replica.builder;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.storage.protection.replica.builder.ArraySyncAsyncConcurrent3DCBuilder;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.core.system.context.ExecutionContext;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ArrayAsyncAsyncConcurrent3DCBuilder
extends ArraySyncAsyncConcurrent3DCBuilder {
    private static final Log logger = LogFactory.getInstance(ArrayAsyncAsyncConcurrent3DCBuilder.class);

    @Override
    public void buildReplica(ProtectGroup protectGroup) {
        if (protectGroup == null) {
            logger.error((Object)"protectGroup is null", 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((Collection)protectGroup.getPolist())) {
            logger.error((Object)"Polist is empty", 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((Collection)((ProtectObject)protectGroup.getPolist().iterator().next()).getUsedStorageResourceSet())) {
            logger.error((Object)"UsedStorageResourceSet is empty", 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
        protectGroup.getReplicaList().clear();
        String srcDevSN = ((ProtectObjectStorageInfo)((ProtectObject)protectGroup.getPolist().iterator().next()).getUsedStorageResourceSet().iterator().next()).getResourceProviderSN();
        String productSite = protectGroup.getProductSiteId();
        protectGroup.setPgReplicaIndex(1);
        protectGroup.setProductSiteId(productSite);
        if (VerifyUtil.isEmpty((String)srcDevSN)) {
            logger.error((Object)"product array is null", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        boolean allScheduleNameVaild = this.allScheduleNameVaild(protectGroup);
        this.getBuilderContext().put("REPLICA_INDEX", 1);
        this.getBuilderContext().put("PROTECT_TYPE", 2);
        this.getBuilderContext().put("PROTECT_LOCATION", DrmEnumDefine.ProtectLocation.A_B.getValue());
        this.getBuilderContext().put("SRC_DEVICE", srcDevSN);
        ExecutionContext context = this.initData(protectGroup);
        ProtectGroupReplica protectGroupReplicaAB = this.getProtectGroupReplica(protectGroup, context);
        protectGroupReplicaAB.setStatus(DrmEnumDefine.ReplicaStatus.UNACTIVE_STATUS.getValue());
        protectGroup.getReplicaList().add(protectGroupReplicaAB);
        HashMap<String, Set<RelicaStorageInfo>> poReplicaStorInfos = new HashMap<String, Set<RelicaStorageInfo>>();
        if (allScheduleNameVaild) {
            this.filterDeviceByDetermineSchedule(protectGroup, protectGroupReplicaAB, DrmEnumDefine.ProtectLocation.A_B.getValue());
        } else {
            Set protectObjectReplicas = protectGroupReplicaAB.getReplicas();
            this.orderByBRecoveryArray(protectObjectReplicas, poReplicaStorInfos, protectGroupReplicaAB);
        }
        this.getBuilderContext().put("REPLICA_INDEX", 2);
        this.getBuilderContext().put("PROTECT_TYPE", 2);
        this.getBuilderContext().put("PROTECT_LOCATION", DrmEnumDefine.ProtectLocation.A_C.getValue());
        this.getBuilderContext().put("SRC_DEVICE", srcDevSN);
        ProtectGroupReplica protectGroupReplicaAC = this.getProtectGroupReplica(protectGroup, context);
        protectGroupReplicaAC.setStatus(DrmEnumDefine.ReplicaStatus.UNACTIVE_STATUS.getValue());
        protectGroup.getReplicaList().add(protectGroupReplicaAC);
        if (allScheduleNameVaild) {
            this.filterDeviceByDetermineSchedule(protectGroup, protectGroupReplicaAC, DrmEnumDefine.ProtectLocation.A_C.getValue());
        } else {
            Set protectObjectReplicasAC = protectGroupReplicaAC.getReplicas();
            this.orderByCRecoveryArray(protectObjectReplicasAC, protectGroupReplicaAC, poReplicaStorInfos);
        }
    }

    private boolean allScheduleNameVaild(ProtectGroup protectGroup) {
        for (Schedule schedule : protectGroup.getTemplate().getSchedules()) {
            if (!VerifyUtil.isEmpty((String)schedule.getSourceSiteId()) && !VerifyUtil.isEmpty((String)schedule.getTargetSiteId())) continue;
            return false;
        }
        return true;
    }

    private void filterDeviceByDetermineSchedule(ProtectGroup protectGroup, ProtectGroupReplica protectGroupReplica, int protectLocation) {
        Set protectObjectReplicas = protectGroupReplica.getReplicas();
        String recoverySiteId = this.getRecoveryIdBySchedule(protectGroup, protectLocation);
        if (VerifyUtil.isNone((String)recoverySiteId)) {
            logger.error((Object)"can not find recoverySiteId", 90160758784001L);
            throw new LegoCheckedException(1073948207L);
        }
        String recoveryStorageBSN = "";
        for (ProtectObjectReplica protectObjectReplica : protectObjectReplicas) {
            RelicaStorageInfo relicaStorageInfo2;
            String siteId;
            Set relicaStorageInfos = protectObjectReplica.getStorageInfos();
            HashSet cloneReplicaStorages = new HashSet(relicaStorageInfos);
            Iterator iterator = cloneReplicaStorages.iterator();
            while (iterator.hasNext() && !recoverySiteId.equals(siteId = this.getSiteBySn(recoveryStorageBSN = (relicaStorageInfo2 = (RelicaStorageInfo)iterator.next()).getStorageProviderSN()))) {
            }
            for (RelicaStorageInfo relicaStorageInfo2 : cloneReplicaStorages) {
                if (recoveryStorageBSN.equals(relicaStorageInfo2.getStorageProviderSN())) continue;
                relicaStorageInfos.remove(relicaStorageInfo2);
            }
        }
        protectGroupReplica.setRecoveryArray(recoveryStorageBSN);
        protectGroupReplica.setRecoverySite(recoverySiteId);
    }

    private String getRecoveryIdBySchedule(ProtectGroup protectGroup, int protectLocation) {
        String recoverySiteId = "";
        for (Schedule schedule : protectGroup.getTemplate().getSchedules()) {
            if (VerifyUtil.isEmpty((String)schedule.getSourceSiteId()) || VerifyUtil.isEmpty((String)schedule.getTargetSiteId())) {
                logger.error((Object)"schedule error", 90160758784001L);
                throw new LegoCheckedException(1073947393L);
            }
            if (schedule.getProtectLocation() != protectLocation) continue;
            recoverySiteId = schedule.getTargetSiteId();
        }
        return recoverySiteId;
    }

    @Override
    public int getType() {
        return 6;
    }

    protected void generatePoStorageInfoByLun(int type, ProtectObjectReplica protectObjectReplica, ProtectGroupReplica protectGroupReplica, ProtectObjectStorageInfo protectObjectStorageInfo, int protectLocation, ExecutionContext context) {
        String resourceId = protectObjectStorageInfo.getResourceId();
        Map lunId2Pair = (Map)context.getAttribute("LUNID_TO_PAIR");
        if (null == lunId2Pair) {
            logger.warn((Object)("master lun(" + resourceId + ")'s ReplicationPair is empty."));
            throw new LegoCheckedException(1073948175L);
        }
        List pairs = (List)lunId2Pair.get(resourceId);
        if (VerifyUtil.isEmpty((Collection)pairs)) {
            logger.warn((Object)("master lun(" + resourceId + ")'s ReplicationPair is empty."));
            throw new LegoCheckedException(1073948175L);
        }
        this.generateRp(type, protectObjectReplica, protectObjectStorageInfo, pairs, protectGroupReplica, context);
    }

    @Override
    protected void generatePosi(int protectLocation, ProtectObject protectObject, ProtectObjectReplica protectObjectReplica, ProtectGroupReplica protectGroupReplica, ExecutionContext context) {
        for (ProtectObjectStorageInfo posi : protectObject.getUsedStorageResourceSet()) {
            this.generatePoStorageInfoByLun(2, protectObjectReplica, protectGroupReplica, posi, protectLocation, context);
        }
    }

    private void orderByBRecoveryArray(Set<ProtectObjectReplica> protectObjectReplicas, Map<String, Set<RelicaStorageInfo>> poReplicaStorInfos, ProtectGroupReplica protectGroupReplicaAB) {
        String recoveryStorageBSN = null;
        for (ProtectObjectReplica protectObjectReplica : protectObjectReplicas) {
            HashSet<RelicaStorageInfo> retainRelicaStorages = new HashSet<RelicaStorageInfo>();
            String poID = protectObjectReplica.getPoId();
            Set relicaStorageInfos = protectObjectReplica.getStorageInfos();
            HashSet cloneReplicaStorages = new HashSet(relicaStorageInfos);
            for (RelicaStorageInfo relicaStorageInfo : cloneReplicaStorages) {
                if (null == recoveryStorageBSN) {
                    recoveryStorageBSN = relicaStorageInfo.getStorageProviderSN();
                }
                if (recoveryStorageBSN.equals(relicaStorageInfo.getStorageProviderSN())) continue;
                retainRelicaStorages.add(relicaStorageInfo);
                relicaStorageInfos.remove(relicaStorageInfo);
            }
            poReplicaStorInfos.put(poID, retainRelicaStorages);
        }
        protectGroupReplicaAB.setRecoveryArray(recoveryStorageBSN);
        protectGroupReplicaAB.setRecoverySite(this.getSiteBySn(recoveryStorageBSN));
    }

    private void orderByCRecoveryArray(Set<ProtectObjectReplica> protectObjectReplicasAC, ProtectGroupReplica protectGroupReplicaAC, Map<String, Set<RelicaStorageInfo>> poReplicaStorInfos) {
        String recoveryStorageSN = null;
        for (ProtectObjectReplica protectObjectReplica : protectObjectReplicasAC) {
            String poID = protectObjectReplica.getPoId();
            Set relicaStorageInfos = protectObjectReplica.getStorageInfos();
            Set<RelicaStorageInfo> replicaStorages = poReplicaStorInfos.get(poID);
            if (VerifyUtil.isEmpty(replicaStorages)) {
                logger.error((Object)"replicaStorages is empty", 1073947393L);
                throw new LegoCheckedException(1073947393L);
            }
            RelicaStorageInfo relicaStorageInfo = replicaStorages.iterator().next();
            recoveryStorageSN = relicaStorageInfo.getStorageProviderSN();
            relicaStorageInfos.retainAll(replicaStorages);
        }
        protectGroupReplicaAC.setRecoveryArray(recoveryStorageSN);
        protectGroupReplicaAC.setRecoverySite(this.getSiteBySn(recoveryStorageSN));
    }
}

